/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public final class VCSURLFilters {
    private VCSURLFilters() {
    }

    public static final URLFilter createProtocolFilter(String protocol) {
        return new ProtocolFilter(protocol);
    }

    public static final URLFilter createFileProtocolFilter() {
        return new ProtocolFilter("file");
    }

    public static final URLFilter createHttpProtocolFilter() {
        return new ProtocolFilter("http");
    }

    public static final URLFilter createFilesFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url);
            }
        };
    }

    public static final URLFilter createDirectoriesFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isDirectory((URL)url);
            }
        };
    }

    public static final URLFilter createFilePathFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return !URLFileSystem.isDirectoryPath((URL)url);
            }
        };
    }

    public static final URLFilter createDirectoryPathFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isDirectoryPath((URL)url);
            }
        };
    }

    public static final URLFilter createSpecificURLFilter(URL[] urls) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        final Collection<VCSHashURL> urls2 = VCSHashURL.convertFromURLs(Arrays.asList(urls));
        return new URLFilter(){

            public boolean accept(URL url) {
                return urls2.contains(new VCSHashURL(url));
            }
        };
    }

    public static final URLFilter createDirectoryContentsFilter(URL[] directoryUrls) {
        final URL[] directoryUrls2 = VCSFileSystemUtils.removeRefAndQueryParts(directoryUrls);
        return new URLFilter(){

            public boolean accept(URL url) {
                URL parent = URLFileSystem.getParent((URL)url);
                for (int i = 0; i < directoryUrls2.length; ++i) {
                    if (!URLFileSystem.equals((URL)directoryUrls2[i], (URL)parent)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final URLFilter createBaseURLContentsFilter(URL[] baseUrls) {
        final URL[] baseUrls2 = VCSFileSystemUtils.removeRefAndQueryParts(baseUrls);
        return new URLFilter(){

            public boolean accept(URL url) {
                for (int i = 0; i < baseUrls2.length; ++i) {
                    if (!VCSFileSystemUtils.isBaseURLFor(baseUrls2[i], url)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final URLFilter createNullFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return true;
            }
        };
    }

    public static final URLFilter createFileSuffixFilter(final String suffix) {
        return new URLFilter(){
            private String _suffix;
            {
                this._suffix = this.removeDot(suffix);
            }

            public boolean accept(URL url) {
                if (URLFileSystem.isDirectoryPath((URL)url)) {
                    return false;
                }
                String suffix2 = URLFileSystem.getSuffix((URL)url);
                return suffix2 != null ? this.removeDot(suffix2).equals(this._suffix) : false;
            }

            private String removeDot(String s) {
                return s.startsWith(".") ? s.substring(1) : s;
            }
        };
    }

    public static final URLFilter createChainedANDFilter(final URLFilter[] filters) {
        return new URLFilter(){

            public boolean accept(URL url) {
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].accept(url)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static final URLFilter createChainedORFilter(final URLFilter[] filters) {
        return new URLFilter(){

            public boolean accept(URL url) {
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].accept(url)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static final class ProtocolFilter
    implements URLFilter {
        private String _protocol;

        private ProtocolFilter(String protocol) {
            this._protocol = protocol;
        }

        public boolean accept(URL url) {
            String protocol = url.getProtocol();
            if (protocol == null) {
                return false;
            }
            return protocol.equals(this._protocol);
        }
    }
}

