/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;

public class VCSCommandUtils {
    private VCSCommandUtils() {
    }

    public static final Collection<Locatable> getFilteredSelection(Locatable[] locatables, StatusCacheBridge<VCSStatus> cache, VCSStatus[] statuses) throws Exception {
        VCSStatus[] statuses2 = (VCSStatus[])VCSCollectionUtils.toArrayType(Arrays.asList(statuses), VCSStatus.class);
        return VCSCommandUtils.getFilteredSelection(locatables, cache, VCSStatusFilters.createStatusFilter(statuses2));
    }

    public static final Collection<Locatable> getFilteredSelection(Locatable[] locatables, StatusCacheBridge<VCSStatus> cache, VCSStatusFilter filter) throws Exception {
        if (locatables.length == 0 || cache == null || filter == null) {
            return new ArrayList<Locatable>(Arrays.asList(locatables));
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(locatables);
        VCSStatus[] statuses = cache.get(urls);
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!filter.accept(statuses[i])) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final Collection<Locatable> getVersionedSelection(Locatable[] locatables, StatusCacheBridge<VCSStatus> cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.emptySet();
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!statuses[i].isVersioned()) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final Collection<Locatable> getCandidateSelection(Locatable[] locatables, StatusCacheBridge<VCSStatus> cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.emptySet();
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!statuses[i].isCandidate()) continue;
            nodes.add(locatables[i]);
        }
        return nodes;
    }

    public static final boolean saveDirtyNodes(Locatable[] locatables) throws Exception {
        return VersioningCoreUtil.saveDirtyNodes((Locatable[])locatables);
    }

    public static final Collection<Node> getDirtyNodesFrom(URLFilter filter, Locatable[] locatables) {
        HashSet<Node> dirtyNodes = new HashSet<Node>(20);
        Iterator it = NodeFactory.getCachedNodes();
        block0: while (it.hasNext()) {
            URL url;
            Node node = (Node)it.next();
            if (!node.isDirty() || !filter.accept(url = node.getURL())) continue;
            for (int i = 0; i < locatables.length; ++i) {
                if (!VCSFileSystemUtils.isBaseURLFor(locatables[i].getURL(), url)) continue;
                dirtyNodes.add(node);
                continue block0;
            }
        }
        return dirtyNodes;
    }

    public static final boolean saveDirtyNodesSilently(Locatable[] locatables) throws Exception {
        return VersioningCoreUtil.saveDirtyNodesSilently((Locatable[])locatables);
    }

    @Deprecated
    public static final boolean saveDirtyNodes(Locatable[] locatables, boolean silent, String helpTopicId) throws Exception {
        return VersioningCoreUtil.saveDirtyNodes((Locatable[])locatables, (boolean)silent, (String)helpTopicId);
    }

    @Deprecated
    public static final void closeMissingNodes(Node[] nodes) {
        VCSCommandUtils.closeFilteredNodes(nodes, new URLFilter(){

            public final boolean accept(URL url) {
                return url == null || URLFileSystem.exists((URL)url);
            }
        });
    }

    public static final void removeNonEditableNodes(Collection<?> nodes) {
        Iterator<?> itr = nodes.iterator();
        while (itr.hasNext()) {
            URL url = VCSModelUtils.getLocatableURL(itr.next());
            if (url == null || !VCSFileSystemUtils.isNonEditable(url)) continue;
            itr.remove();
        }
    }

    private static final void closeFilteredNodesImpl(Node[] nodes, URLFilter filter) throws Exception {
        ArrayList<Node> c = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (filter.accept(nodes[i].getURL())) continue;
            c.add(nodes[i]);
        }
        if (c.size() <= 0) {
            return;
        }
        Context context = Context.newIdeContext();
        context.setSelection(c.toArray(new Element[0]));
        Command command = VCSNodeCommands.createQuietCloseNodeCommand(context);
        command.doit();
    }

    private static final void closeFilteredNodes(final Node[] nodes, final URLFilter filter) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    VCSCommandUtils.closeFilteredNodesImpl(nodes, filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

