/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ide.Ide;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public class VCSWorkingCopyLocator {
    private static final Map<String, VCSWorkingCopyLocator> _locators = new HashMap<String, VCSWorkingCopyLocator>();
    private final String _vcsId;
    private final String _adminPath;
    private Set<URL> _roots = null;
    private final Lock _updateLock = new ReentrantLock();
    private ExecutorService _executor;

    private VCSWorkingCopyLocator(String vcsId, String adminPath) {
        this._vcsId = vcsId;
        this._adminPath = adminPath;
        Observer o = new Observer(){

            @Override
            public final void update(Observable o, Object arg) {
                if (arg == null || arg.equals(VCSWorkingCopyLocator.this._vcsId)) {
                    VCSWorkingCopyLocator.this.updateRoots(false);
                }
            }
        };
        VCSApplicationSystem.getApplicationSystem().addObserver(o);
        VCSControlCache.getInstance().addObserver(o);
        this.updateRoots(true);
    }

    public final Lock getUpdateLock() {
        return this._updateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VCSWorkingCopyLocator getLocatorInstance(String vcsId, String adminPath) {
        Map<String, VCSWorkingCopyLocator> map = _locators;
        synchronized (map) {
            VCSWorkingCopyLocator instance = _locators.get(vcsId);
            if (instance == null) {
                instance = new VCSWorkingCopyLocator(vcsId, adminPath);
                _locators.put(vcsId, instance);
            }
            return instance;
        }
    }

    public final URL[] getRoots() {
        this.acquireUpdateLock();
        try {
            Set<URL> roots = this.getNonNullRoots();
            URL[] uRLArray = roots.toArray(new URL[roots.size()]);
            return uRLArray;
        }
        finally {
            this._updateLock.unlock();
        }
    }

    public final URL getRootContaining(URL url) {
        return this._getRootContaining(url);
    }

    public final URL getDeepestCopyContaining(URL url) {
        URL dirUrl = URLFileSystem.isDirectory((URL)url) ? url : URLFileSystem.getParent((URL)url);
        URL root = this._getRootContaining(dirUrl);
        URL deepestAdmin = null;
        while (true) {
            URL parent;
            if (this.isAdministered(dirUrl)) {
                deepestAdmin = dirUrl;
                break;
            }
            if (JarUtil.isJarURL((URL)dirUrl) || (parent = URLFileSystem.getParent((URL)dirUrl)) == null || parent.equals(dirUrl) || root != null && !URLFileSystem.isBaseURLFor((URL)root, (URL)parent) || root == null && !VCSApplicationSystem.getApplicationSystem().isControlledDirectory(parent)) break;
            dirUrl = parent;
        }
        return deepestAdmin;
    }

    public final boolean isAdministered(URL dirUrl) {
        return URLFileSystem.exists((URL)URLFactory.newURL((URL)dirUrl, (String)this._adminPath));
    }

    private final void updateRoots(final boolean notify) {
        this.getExecutor().submit(new Runnable(){

            @Override
            public final void run() {
                VCSWorkingCopyLocator.this._updateRoots(notify);
            }
        });
    }

    private final synchronized ExecutorService getExecutor() {
        if (this._executor == null) {
            this._executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final ThreadFactory _delegate = Executors.defaultThreadFactory();

                @Override
                public final Thread newThread(Runnable r) {
                    Thread t = this._delegate.newThread(r);
                    t.setName("VCSWorkingCopyLocator@" + VCSWorkingCopyLocator.this._vcsId);
                    return t;
                }
            });
        }
        return this._executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _updateRoots(boolean notify) {
        Collection workspaces = Ide.getWorkspaces().workspaces();
        HashMap<Project, Collection> contentSetRootMap = new HashMap<Project, Collection>();
        for (Workspace workspace : workspaces) {
            Iterator iterator = workspace.projects().iterator();
            while (iterator.hasNext()) {
                Project project;
                contentSetRootMap.put(project, (project = (Project)iterator.next()).isOpen() ? ContentSetRoot.getContentSetRoots((Project)project) : null);
            }
        }
        this._updateLock.lock();
        try {
            LinkedHashSet<URL> roots = new LinkedHashSet<URL>();
            for (Workspace workspace : workspaces) {
                this.populateRoots(URLFileSystem.getParent((URL)workspace.getURL()), roots);
            }
            for (Map.Entry entry : contentSetRootMap.entrySet()) {
                this.populateRoots(URLFileSystem.getParent((URL)((Project)entry.getKey()).getURL()), roots);
                if (entry.getValue() == null) continue;
                for (ContentSetRoot contentSetRoot : (Collection)entry.getValue()) {
                    if (JarUtil.isJarURL((URL)contentSetRoot.getURL())) continue;
                    this.populateRoots(VCSFileSystemUtils.getDirectoryPathURL(contentSetRoot.getURL()), roots);
                }
            }
            if (this._roots == null) {
                this._roots = new LinkedHashSet<URL>();
            } else {
                this._roots.clear();
            }
            this._roots.addAll(roots);
        }
        finally {
            this._updateLock.unlock();
        }
        if (notify) {
            VCSControlCache.getInstance().fireControlStateChanged(this._vcsId);
        }
    }

    private final void populateRoots(URL dirUrl, Set<URL> roots) {
        if (this._getRootContaining(dirUrl, roots) != null) {
            return;
        }
        URL shallowestAdmin = null;
        while (true) {
            if (this.isAdministered(dirUrl)) {
                shallowestAdmin = dirUrl;
            } else if (shallowestAdmin != null || JarUtil.isJarURL((URL)dirUrl) || !VCSApplicationSystem.getApplicationSystem().isControlledDirectory(URLFileSystem.getParent((URL)dirUrl))) break;
            URL parent = URLFileSystem.getParent((URL)dirUrl);
            if (parent == null || parent.equals(dirUrl)) break;
            dirUrl = parent;
        }
        if (shallowestAdmin != null && this._getRootContaining(shallowestAdmin, roots) == null) {
            Iterator<URL> itr = roots.iterator();
            while (itr.hasNext()) {
                if (!URLFileSystem.isBaseURLFor((URL)shallowestAdmin, (URL)itr.next())) continue;
                itr.remove();
            }
            roots.add(shallowestAdmin);
        }
    }

    private final URL _getRootContaining(URL url) {
        this.acquireUpdateLock();
        try {
            URL uRL = this._getRootContaining(url, this.getNonNullRoots());
            return uRL;
        }
        finally {
            this._updateLock.unlock();
        }
    }

    private final void acquireUpdateLock() {
        this._updateLock.lock();
    }

    private final Set<URL> getNonNullRoots() {
        return this._roots != null ? this._roots : Collections.emptySet();
    }

    private final URL _getRootContaining(URL url, Set<URL> roots) {
        for (URL root : roots) {
            if (!URLFileSystem.isBaseURLFor((URL)root, (URL)url)) continue;
            return root;
        }
        return null;
    }
}

