/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSIdeCommandProcessor;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public abstract class VCSImportBackupHelper {
    private final URL _directoryUrl;

    public VCSImportBackupHelper(URL directoryUrl) {
        this._directoryUrl = directoryUrl;
    }

    public URL backupDirectoryFiles() throws Exception {
        return this.backupDirectoryFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL backupDirectoryFiles(VCSCancellable cancellable) throws Exception {
        URL backupDirectoryUrl = this.generateBackupDirectoryURL(this._directoryUrl);
        this.createBackupDirectory(backupDirectoryUrl);
        try {
            JarIndex.flushCache();
        }
        catch (RuntimeException re) {
            Assert.printStackTrace((Throwable)re);
        }
        Storage urls = URLFileSystem.list((URL)this._directoryUrl);
        HashSet<Node> nodesToClose = new HashSet<Node>();
        for (int i = 0; i < ((URL[])urls).length; ++i) {
            this.addNodesForURL(urls[i], nodesToClose);
        }
        if (!nodesToClose.isEmpty()) {
            this.closeNodes(nodesToClose.toArray(new Node[0]));
        }
        HashSet<Storage> storages = new HashSet<Storage>();
        for (Node node : nodesToClose) {
            Storage storage;
            if (node instanceof Project) {
                storage = Storages.getProjectStorage((Project)((Project)node));
                if (!storages.add(storage)) continue;
                storage.lockClosed();
                continue;
            }
            if (!(node instanceof Workspace) || !storages.add(storage = Storages.getApplicationStorage((Workspace)((Workspace)node)))) continue;
            storage.lockClosed();
        }
        try {
            URL[] targetUrls = VCSFileSystemUtils.newTargetURLs((URL[])urls, backupDirectoryUrl);
            HashSet<Node> nodesToRemove = new HashSet<Node>();
            for (Storage url : urls) {
                if (cancellable != null && cancellable.isCancelled()) {
                    URL uRL = null;
                    return uRL;
                }
                if (URLFileSystem.equals((URL)url, (URL)backupDirectoryUrl)) continue;
                this.addNodesForURL((URL)url, nodesToRemove);
            }
            if (!nodesToRemove.isEmpty()) {
                this.removeNodes(nodesToRemove.toArray(new Node[0]));
                nodesToRemove.clear();
            }
            block15: for (int i = 0; i < ((Storage)urls).length; ++i) {
                if (cancellable != null && cancellable.isCancelled()) {
                    URL uRL = null;
                    return uRL;
                }
                if (URLFileSystem.equals((URL)urls[i], (URL)backupDirectoryUrl)) continue;
                while (true) {
                    URL renameFailureUrl = null;
                    try {
                        this.preprocessBackup((URL)urls[i]);
                        this.addNodesForURL((URL)urls[i], nodesToRemove);
                        Iterator itr = nodesToRemove.iterator();
                        while (itr.hasNext()) {
                            NodeFactory.uncache((URL)((Node)itr.next()).getURL());
                        }
                        boolean success = URLFileSystem.renameTo((URL)urls[i], (URL)targetUrls[i]);
                        for (Node node : nodesToRemove) {
                            NodeFactory.recache(null, (URL)node.getURL(), (Node)node);
                        }
                        nodesToRemove.clear();
                        if (success) continue block15;
                        renameFailureUrl = this.findRenameFailureURL((URL)urls[i]);
                    }
                    finally {
                        this.postprocessBackup((URL)urls[i]);
                    }
                    if (this.confirmRetryBackupAfterFailure(renameFailureUrl != null ? renameFailureUrl : urls[i])) continue;
                    URL uRL = null;
                    return uRL;
                }
            }
        }
        finally {
            for (Storage storage : storages) {
                storage.allowOpen();
            }
        }
        return backupDirectoryUrl;
    }

    private void addNodesForURL(URL url, Collection<Node> nodes) {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            nodes.addAll(Arrays.asList(VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(new URL[]{url}))));
        } else {
            Node node = NodeFactory.find((URL)url);
            if (node != null) {
                nodes.add(node);
            }
        }
    }

    private URL findRenameFailureURL(URL url) {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            for (URL listUrl : URLFileSystem.list((URL)url)) {
                URL renameFailureUrl = this.findRenameFailureURL(listUrl);
                if (renameFailureUrl == null) continue;
                return renameFailureUrl;
            }
        }
        String fileName = URLFileSystem.getFileName((URL)url);
        URL renamedUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)url), (String)("." + fileName));
        if (!URLFileSystem.canWrite((URL)url) || !URLFileSystem.renameTo((URL)url, (URL)renamedUrl)) {
            return url;
        }
        URLFileSystem.renameTo((URL)renamedUrl, (URL)url);
        return null;
    }

    protected void removeNodes(Node[] nodes) throws Exception {
        Context context = new Context();
        context.setSelection((Element[])nodes);
        VCSIdeCommandProcessor.invokeAndWait(VCSNodeCommands.createRemoveNodeOnlyCommand(context));
    }

    protected void closeNodes(Node[] nodes) throws Exception {
        Context context = new Context();
        context.setSelection((Element[])nodes);
        VCSIdeCommandProcessor.invokeAndWait(VCSNodeCommands.createCloseNodeOnlyCommand(context));
    }

    protected URL generateBackupDirectoryURL(URL directoryUrl) {
        String filename = URLFileSystem.getFileName((URL)directoryUrl) + ".backup";
        filename = filename.replace('/', '-');
        filename = filename.replace('\\', '-');
        directoryUrl = URLFileSystem.getParent((URL)directoryUrl);
        URL backupDirectoryUrl = URLFactory.newDirURL((URL)directoryUrl, (String)filename);
        int i = 2;
        while (URLFileSystem.exists((URL)backupDirectoryUrl)) {
            backupDirectoryUrl = URLFactory.newDirURL((URL)directoryUrl, (String)(filename + i));
            ++i;
        }
        return backupDirectoryUrl;
    }

    protected void createBackupDirectory(URL backupDirectoryUrl) throws Exception {
        if (!URLFileSystem.mkdirs((URL)backupDirectoryUrl)) {
            this.bounceBackupDirectoryCreation(backupDirectoryUrl);
        }
    }

    protected void bounceBackupDirectoryCreation(URL backupDirectoryUrl) throws Exception {
        throw new IOException("URLFileSystem.mkdirs failed for " + backupDirectoryUrl);
    }

    protected abstract boolean confirmRetryBackupAfterFailure(URL var1);

    protected void preprocessBackup(URL url) {
    }

    protected void postprocessBackup(URL url) {
    }
}

