/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;

public abstract class VCSIgnorePanel
extends JPanel
implements ActionListener {
    private JLabel _existingPatternLabel;
    private JLabel _pathLabel;
    private JTextField _existingPatternField;
    private JLabel _chooseTextLabel;
    private ButtonGroup _radioGroup;
    private JRadioButton _fileRadio;
    private JTextField _fileTextField;
    private JRadioButton _extensionRadio;
    private JTextField _extensionTextField;
    private JRadioButton _customRadio;
    private JTextField _customTextField;
    private URL[] _urls;
    private String _existingPattern;
    private URL _ignoreURL;

    public VCSIgnorePanel(URL[] urls, String existingPattern) {
        this(null, urls, existingPattern);
    }

    public VCSIgnorePanel(URL ignoreUrl, URL[] urls, String existingPattern) {
        super(new GridBagLayout());
        this._ignoreURL = ignoreUrl;
        this._urls = urls;
        this._existingPattern = existingPattern;
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    private void createComponents() {
        this._pathLabel = new JLabel();
        this._pathLabel.setText(this.getIgnoreURL().getPath());
        this._existingPatternLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._existingPatternLabel, (Component)this._existingPatternLabel, (String)this.getExistingPattern());
        this._existingPatternField = new JTextField();
        this._existingPatternField.setEditable(false);
        this._existingPatternField.setText(this._existingPattern);
        this._chooseTextLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._chooseTextLabel, (Component)this._chooseTextLabel, (String)this.getLabelChoose());
        this._radioGroup = new ButtonGroup();
        this._fileRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._fileRadio, (String)this.getRadioFile());
        this._fileRadio.setSelected(true);
        this._fileTextField = new JTextField();
        this._fileTextField.setEditable(false);
        this._fileTextField.setEnabled(true);
        this._fileTextField.setText(this.getNameBasedPattern(this._urls));
        this._extensionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._extensionRadio, (String)this.getRadioExtension());
        this._extensionTextField = new JTextField();
        this._extensionTextField.setEditable(false);
        this._extensionTextField.setEnabled(false);
        this._extensionTextField.setText(this.getExtensionBasedPattern());
        this._customRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._customRadio, (String)this.getRadioCustom());
        this._customTextField = new JTextField();
        this._customTextField.setEnabled(false);
        this._radioGroup.add(this._fileRadio);
        this._radioGroup.add(this._extensionRadio);
        this._radioGroup.add(this._customRadio);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsFields = new Insets(6, 40, 2, 6);
        Insets insetsRadio = new Insets(6, 18, 2, 6);
        this.add((Component)this._pathLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._existingPatternLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._existingPatternField, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, insets, 0, 0));
        this.add((Component)this._chooseTextLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fileRadio, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._fileTextField, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, insetsFields, 0, 0));
        this.add((Component)this._extensionRadio, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._extensionTextField, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 1, insetsFields, 0, 0));
        this.add((Component)this._customRadio, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._customTextField, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 1, insetsFields, 0, 0));
        this.setVisible(true);
        this._fileRadio.requestFocus();
    }

    private void initListeners() {
        this._fileRadio.addActionListener(this);
        this._extensionRadio.addActionListener(this);
        this._customRadio.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._fileTextField.setEnabled(this._fileRadio.isSelected());
        this._extensionTextField.setEnabled(this._extensionRadio.isSelected());
        this._customTextField.setEnabled(this._customRadio.isSelected());
    }

    protected URL getIgnoreURL() {
        if (this._ignoreURL == null) {
            this._ignoreURL = URLFileSystem.getParent((URL)this._urls[0]);
        }
        return this._ignoreURL;
    }

    protected String getNameBasedPattern(URL[] urls) {
        StringBuilder buffer = new StringBuilder();
        for (URL url : urls) {
            buffer.append(URLFileSystem.getFileName((URL)url));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private String getExtensionBasedPattern() {
        HashSet<String> extSet = new HashSet<String>();
        for (URL url : this._urls) {
            String ext = URLFileSystem.getSuffix((URL)url);
            if (ext.length() <= 0) continue;
            extSet.add("*" + URLFileSystem.getSuffix((URL)url));
        }
        StringBuffer buffer = new StringBuffer();
        for (String ext : extSet) {
            buffer.append(ext);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private String getCustomPattern() {
        String pattern = this._customTextField.getText();
        String[] patternSegs = pattern.split("\\s+");
        StringBuffer buffer = new StringBuffer();
        for (String str : patternSegs) {
            buffer.append(str);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String getPattern() {
        if (this._fileRadio.isSelected()) {
            return this.getNameBasedPattern(this._urls);
        }
        if (this._extensionRadio.isSelected()) {
            return this.getExtensionBasedPattern();
        }
        if (this._customRadio.isSelected()) {
            return this.getCustomPattern();
        }
        return "";
    }

    public Component getInitialFocusComponent() {
        return this._fileRadio;
    }

    protected abstract String getExistingPattern();

    protected abstract String getLabelChoose();

    protected abstract String getRadioFile();

    protected abstract String getRadioExtension();

    protected abstract String getRadioCustom();
}

