/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.infotip.InfoTipStyles;

public class VCSExtendHover {
    private VCSExtendHover() {
    }

    public static void addExtendedProperties(InfoTipStyles style, JPanel panel, String labelTxt, GridBagConstraints gbc, int preferredWidth, boolean enabled, Collection<String> bugs, MouseListener mlistener, ActionListener aListener) {
        if (bugs != null && !bugs.isEmpty()) {
            ArrayList<String> bugList = new ArrayList<String>(bugs);
            Collections.sort(bugList);
            JPanel bugPanel = new JPanel(new FlowLayout(0, 0, 0));
            bugPanel.setOpaque(false);
            JLabel label = new JLabel(labelTxt);
            label.setOpaque(false);
            label.setForeground(style.getContentTextColor());
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
            bugPanel.add(label);
            int w = 0;
            int h = 0;
            int maxHeight = 0;
            for (String bug : bugList) {
                HyperlinkButton bugField = new HyperlinkButton(bug);
                if (enabled) {
                    bugField.setForeground(style.getHyperLinkTextColor(false));
                } else {
                    bugField.setForeground(style.getContentTextColor());
                    bugField.setEnabled(false);
                }
                bugField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                Dimension d = bugField.getPreferredSize();
                d.width += 5;
                bugField.setPreferredSize(d);
                if ((w += d.width) > preferredWidth) {
                    w = d.width;
                    h += maxHeight;
                    maxHeight = 0;
                }
                maxHeight = Math.max(maxHeight, d.height);
                bugField.addMouseListener(mlistener);
                bugField.addActionListener(aListener);
                bugPanel.add((Component)bugField);
            }
            bugPanel.setPreferredSize(new Dimension(w + 3, h += maxHeight));
            gbc.insets = new Insets(3, 0, 0, 0);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            panel.add((Component)bugPanel, gbc);
        }
    }
}

