/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.properties;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.properties.PropertiesPanelProvider;
import oracle.jdeveloper.vcs.properties.PropertiesUtil;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public abstract class VersionPropertiesPanelProvider
extends PropertiesPanelProvider {
    private static final URLFilter _localFileFilter = VCSContextUtils.createLocalProtocolFilter();
    private final StatusCacheBridge<VCSStatus> _cache;
    private final String _vcsId;

    protected VersionPropertiesPanelProvider() {
        this(null);
    }

    protected VersionPropertiesPanelProvider(StatusCacheBridge<VCSStatus> cache) {
        this(cache, null);
    }

    public VersionPropertiesPanelProvider(StatusCacheBridge<VCSStatus> cache, String vcsId) {
        this._cache = cache;
        this._vcsId = vcsId;
    }

    @Override
    public String getTabName() {
        return VCSArb.get("PROPERTIES_VERSIONING");
    }

    @Override
    public float getTabWeight() {
        return 1.0f;
    }

    @Override
    public boolean isDefaultTab() {
        return true;
    }

    @Override
    public boolean isHandled(Context context) {
        URL url = this.getContextURL(context);
        if (url == null || !this.isHandledURL(url)) {
            return false;
        }
        try {
            return this._cache == null || this._cache.get(url).isVersioned();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return false;
        }
    }

    protected Element getContextElement(Context context) {
        return PropertiesUtil.getContextElement(context);
    }

    protected URL getContextURL(Context context) {
        URL[] compositeFileUrls;
        Element element = this.getContextElement(context);
        if (element == null) {
            return null;
        }
        String viewType = VCSContextUtils.getContextViewType(context);
        if (CompositeFileElementRegistry.isCompositeElement((Element)element, (String)viewType) && (compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)element, (String)viewType)) != null) {
            if (compositeFileUrls.length == 1) {
                return compositeFileUrls[0];
            }
            if (compositeFileUrls.length > 1) {
                return this.isElementInComposite(element, compositeFileUrls);
            }
        }
        return VCSModelUtils.getLocatableURL(element);
    }

    private boolean isHandledURL(URL url) {
        if (!_localFileFilter.accept(url) || !URLFileSystem.exists((URL)url)) {
            return false;
        }
        return this._vcsId == null || VCSControlCache.getInstance().isControlled(url, this._vcsId);
    }

    private URL isElementInComposite(Element element, URL[] compositeFileUrls) {
        URL url = VCSModelUtils.getLocatableURL(element);
        if (url != null) {
            for (URL compositeFileUrl : compositeFileUrls) {
                if (!compositeFileUrl.getPath().equals(url.getPath())) continue;
                return url;
            }
        }
        return null;
    }
}

