/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.commithistory;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.controls.ThrobberLabel;
import oracle.javatools.ui.Ellipses;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.javatools.ui.table.LabelTableCellRenderer;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.commithistory.CommitCancel;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryDetail;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryItem;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryTableModel;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdeveloper.vcs.spi.CommonTableModel;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.util.PopupMenuListener;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class CommitVersionDockableWindow
extends DockableWindow {
    public static final String COMMIT_FILE_PATH = "commit-version-file-path";
    public static final String COMMIT_ID = "commit-version-id";
    private static final String GUI_PROGRESS = "Progress";
    private static final String GUI_MESSAGE = "Message";
    private static final String GUI_RESULTS = "Results";
    private final Controller _controller;
    private boolean _initialized;
    private boolean _busy;
    private ContextMenu _contextMenu;
    private JPanel _gui;
    private JPanel _center;
    private CardLayout _layout;
    private JPanel _guiResults;
    private ThrobberLabel _progress;
    private FocusableLabel _message;
    private Toolbar _toolbar;
    private GenericTable _commitTable;
    private CommitDetail _commitDetail;
    private RequestProcessor _processor;
    private RequestProcessor.Task _task;
    private JCheckBox _pathCheckbox;
    private URL _pathUrl;
    private static String STARTFILENAME = "+++ b/";

    protected abstract Controller createController();

    protected abstract String getThobberLabel();

    protected abstract Toolbar getToolbarImpl();

    protected abstract ContextMenuListener getContextMenuListener();

    protected abstract void refresh();

    protected abstract CommitHistoryDetail getCommitVersionDetail(Object var1, CommitCancel var2) throws VCSException;

    protected abstract void createLocalActions();

    protected abstract String getSettingsKey();

    protected abstract Pair<String, Action> getLinkTextFromMessage(String var1);

    protected abstract void setSelectedCommitId(String var1);

    protected abstract String getCommitId(CommitHistoryItem var1);

    public CommitVersionDockableWindow(String viewId) {
        super(viewId);
        this.createLocalActions();
        this._controller = this.createController();
    }

    public final Controller getController() {
        return this._controller;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._layout = new CardLayout();
            this._center = new JPanel(this._layout);
            this._guiResults = new JPanel(new BorderLayout());
            this._progress = new ThrobberLabel(this.getThobberLabel());
            this._message = new FocusableLabel();
            this._message.setName("CommitVersionMessageLabel");
            this._center.add((Component)this._progress, GUI_PROGRESS);
            this._center.add((Component)this._message, GUI_MESSAGE);
            this._center.add((Component)this._guiResults, GUI_RESULTS);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.getCommitTable(), "Center");
            this._guiResults.add((Component)new JScrollPane((Component)this.getCommitTable()), "Center");
            this._guiResults.add((Component)this.getCommitDetail(), "East");
            this._gui.add((Component)this.getToolbar(), "North");
            this._gui.add((Component)this._center, "Center");
            PopupMenuListener listener = new PopupMenuListener((View)this);
            this._guiResults.addMouseListener(listener);
            this.getCommitTable().addMouseListener((MouseListener)listener);
            this.getCommitDetail().addMouseListener(listener);
        }
        return this._gui;
    }

    public final void dockableShown(DockableEvent event) {
        super.dockableShown(event);
        if (this.isBusy()) {
            return;
        }
        this.initialize();
    }

    public final Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = this.getToolbarImpl();
        }
        return this._toolbar;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu(new MnemonicSolver());
            this._contextMenu.addContextMenuListener(this.getContextMenuListener());
        }
        return this._contextMenu;
    }

    public Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        String filepath = this.getCommitDetail().getSelectedFile();
        if (filepath != null) {
            context.setProperty(COMMIT_FILE_PATH, (Object)filepath);
        }
        int row = this._commitTable.getSelectedRowInModel();
        if (this._commitTable.getModel() instanceof CommitHistoryTableModel && row >= 0) {
            CommitHistoryTableModel model = (CommitHistoryTableModel)((Object)this._commitTable.getModel());
            context.setProperty(COMMIT_ID, (Object)this.getCommitId(model.getRowItem(row)));
        }
        return context;
    }

    public final boolean isBusy() {
        return this._busy;
    }

    public void update(URL url, String commitId) {
        this.setSelectedCommitId(commitId);
        if (url != null && this.isVersioned(url)) {
            this._pathUrl = url;
            this._pathCheckbox.setText(this.getPathCheckboxLabel(url));
            this._pathCheckbox.setVisible(true);
            if (!this._pathCheckbox.isSelected()) {
                this._pathCheckbox.setSelected(true);
            } else {
                this.refresh();
            }
        } else {
            this._pathCheckbox.setVisible(false);
            this._pathUrl = null;
        }
    }

    protected String getPathCheckboxLabel(URL url) {
        return Bundle.format("COMMIT_HISTORY_DIR", URLFileSystem.getPlatformPathName((URL)url));
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    protected String getClipBoardValue(ActionEvent e) {
        return null;
    }

    protected boolean extendClipboard() {
        return false;
    }

    protected final void showProgress() {
        this._busy = true;
        if (this.getGUI() != null) {
            this._layout.show(this._center, GUI_PROGRESS);
            this._center.invalidate();
            this.updateVisibleActions();
            if (this.isWindowActive()) {
                this._progress.requestFocusInWindow();
            }
        }
    }

    protected final void showMessage(String message) {
        this._busy = false;
        if (this.getGUI() != null) {
            this._message.setText(message);
            this._layout.show(this._center, GUI_MESSAGE);
            this._center.invalidate();
            this.updateVisibleActions();
            if (this.isWindowActive()) {
                this._message.requestFocusInWindow();
            }
        }
    }

    protected final void showResults() {
        this._busy = false;
        if (this._gui != null) {
            this._layout.show(this._center, GUI_RESULTS);
            this._center.invalidate();
            this.updateVisibleActions();
            if (this.isWindowActive()) {
                this._guiResults.requestFocusInWindow();
            }
        }
    }

    protected JCheckBox getPathCheckBox() {
        if (this._pathCheckbox == null) {
            this._pathCheckbox = new JCheckBox();
            this._pathCheckbox.setVisible(false);
            this._pathCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (CommitVersionDockableWindow.this._pathUrl != null) {
                        if (!((JCheckBox)e.getSource()).isSelected()) {
                            CommitVersionDockableWindow.this._pathCheckbox.setVisible(false);
                            CommitVersionDockableWindow.this._pathUrl = null;
                        }
                        CommitVersionDockableWindow.this.refresh();
                    }
                }
            });
        }
        return this._pathCheckbox;
    }

    protected void clearPath() {
        if (this._pathCheckbox != null) {
            this._pathCheckbox.setSelected(false);
        }
        this._pathUrl = null;
    }

    protected URL getDirectoryURL() {
        return this._pathUrl;
    }

    protected final GenericTable getCommitTable() {
        if (this._commitTable == null) {
            this._commitTable = new GenericTable();
            this._commitTable.setName("CommitTable");
            this._commitTable.addMouseListener((MouseListener)new TableMouseListener());
            this._commitTable.setShowGrid(false);
            this._commitTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int row = CommitVersionDockableWindow.this._commitTable.getSelectedRow();
                        if (row > -1) {
                            row = CommitVersionDockableWindow.this._commitTable.convertRowIndexToModel(row);
                            CommitVersionDockableWindow.this.populateCommitDetail(((CommitHistoryTableModel)((Object)CommitVersionDockableWindow.this._commitTable.getModel())).getRowItem(row));
                        }
                        CommitVersionDockableWindow.this.persistTableSettings();
                    }
                }
            });
            this._commitTable.setSelectionMode(0);
            if (this.extendClipboard()) {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String value = CommitVersionDockableWindow.this.getClipBoardValue(e);
                        if (value != null) {
                            StringSelection sel = new StringSelection(value);
                            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clip.setContents(sel, sel);
                        }
                    }
                };
                KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
                this._commitTable.registerKeyboardAction(listener, "Copy", stroke, 0);
            }
        }
        return this._commitTable;
    }

    protected void installTableModel(CommitHistoryTableModel model) {
        this.getCommitTable().setModel((TableModel)((Object)model));
        Map settings = (Map)Ide.getDTCache().getData(this.getSettingsKey());
        if (settings == null) {
            this.autoSizeCoumnstoFit(this.getCommitTable(), model);
        } else {
            this.getCommitTable().setPersistentSettings(new GenericTablePersistentSettings(settings));
        }
    }

    protected void resetCommitDetail() {
        this.getCommitDetail().setCommitId("");
        this.getCommitDetail().setMessage(null);
        this.getCommitDetail().setFiles(new ArrayList());
        this.getCommitDetail().setLink(null);
    }

    protected String getDescription(CommitHistoryItem item) {
        return item.toString();
    }

    protected boolean getCommitVersionDetailDiff(Object userObject, Collection<CommitHistoryDetail.FileDetail> fileDetail, CommitCancel cancel) throws VCSException {
        return false;
    }

    protected boolean populateTabs(Object userObject, Collection<CommitHistoryDetail.FileDetail> fileDetail, CommitCancel cancel) throws VCSException {
        return true;
    }

    protected TabbedComponent[] getTabbedComponents() {
        return new TabbedComponent[0];
    }

    protected String getMessageLabel() {
        return Bundle.get("COMMIT_HISTORY_MESSAGE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Pair<Integer, Integer>> getFileDifferences(OutputStream stream) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new StringReader(stream.toString()));
            HashMap<String, Pair<Integer, Integer>> details = new HashMap<String, Pair<Integer, Integer>>();
            String line = null;
            String filename = null;
            int addL = 0;
            int delL = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(STARTFILENAME)) {
                    if (filename != null) {
                        details.put(filename, (Pair<Integer, Integer>)new Pair((Object)new Integer(addL), (Object)new Integer(delL)));
                        filename = null;
                        addL = 0;
                        delL = 0;
                    }
                    filename = line.substring(STARTFILENAME.length());
                    continue;
                }
                if (line.startsWith("+")) {
                    ++addL;
                    continue;
                }
                if (!line.startsWith("-") || line.startsWith("--")) continue;
                ++delL;
            }
            if (filename != null) {
                details.put(filename, (Pair<Integer, Integer>)new Pair((Object)new Integer(addL), (Object)new Integer(delL)));
            }
            HashMap<String, Pair<Integer, Integer>> hashMap = details;
            return hashMap;
        }
    }

    protected void exceptionHandler(VCSException ex) {
    }

    protected boolean isVersioned(URL url) {
        return true;
    }

    private void autoSizeCoumnstoFit(GenericTable table, CommonTableModel model) {
        Object[] prototypeValues = new Object[model.getColumnCount()];
        for (int i = 0; i < prototypeValues.length; ++i) {
            prototypeValues[i] = model.getProperty(i).getPrototypeValue();
        }
        table.autoSizeColumnsToFit(prototypeValues);
    }

    private void persistTableSettings() {
        GenericTablePersistentSettings settings = this.getCommitTable().getPersistentSettings();
        Ide.getDTCache().putData(this.getSettingsKey(), settings.toMap());
    }

    private void populateCommitDetail(final CommitHistoryItem item) {
        if (this._processor == null) {
            this._processor = new RequestProcessor("Commit History", 1, true);
        }
        if (this._task != null) {
            this._task.cancel();
        }
        this._task = this._processor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CommitCancel cancel = new CommitCancel();
                ProgressHandle handle = ProgressHandle.createHandle((String)CommitVersionDockableWindow.this.getDescription(item), (Cancellable)cancel);
                try {
                    handle.start();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommitVersionDockableWindow.this.getCommitDetail().clear();
                        }
                    });
                    final CommitHistoryDetail detail = CommitVersionDockableWindow.this.getCommitVersionDetail(item.getUserObject(), cancel);
                    if (detail == null) {
                        return;
                    }
                    final Pair<String, Action> linkInfo = CommitVersionDockableWindow.this.getLinkTextFromMessage(detail.getMessage());
                    CommitVersionDockableWindow.this.populateTabs(item.getUserObject(), detail.getFile(), cancel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommitVersionDockableWindow.this.getCommitDetail().setCommitId(detail.getRevId());
                            CommitVersionDockableWindow.this.getCommitDetail().setMessage(detail.getMessage());
                            CommitVersionDockableWindow.this.getCommitDetail().setFiles(detail.getFile());
                            CommitVersionDockableWindow.this.getCommitDetail().setLink(linkInfo == null ? null : (Action)linkInfo.getSecond());
                            CommitVersionDockableWindow.this.getCommitDetail().setLinkLabel(linkInfo == null ? "" : (String)linkInfo.getFirst());
                        }
                    });
                    if (CommitVersionDockableWindow.this.getCommitVersionDetailDiff(item.getUserObject(), detail.getFile(), cancel)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CommitVersionDockableWindow.this.getCommitDetail().setFiles(detail.getFile());
                            }
                        });
                    }
                }
                catch (VCSException e) {
                    CommitVersionDockableWindow.this.exceptionHandler(e);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private final void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                CommitVersionDockableWindow.this.refresh();
            }
        });
    }

    private CommitDetail getCommitDetail() {
        if (this._commitDetail == null) {
            this._commitDetail = new CommitDetail();
        }
        return this._commitDetail;
    }

    private final boolean isWindowActive() {
        return (DockStation.getDockStation().getDockableStatus((Dockable)this) & 0x10) > 0;
    }

    public class CommitDetail
    extends JPanel {
        private JTextField _commitId;
        private JLabel _msgLabel;
        private JTextArea _message;
        private JLabel _fileLst;
        private GenericTable _table;
        private JLabel _linkLabel;
        private HyperlinkButton _linkButton;
        private GITFilePathTableEllipseRenderer _labelEllipseRenderer;
        private JTabbedPane _tabPane;

        CommitDetail() {
            this.init();
            this.initRes();
            this.layoutComponents();
        }

        @Override
        public void addMouseListener(MouseListener listener) {
            super.addMouseListener(listener);
            this._message.addMouseListener(listener);
            this._table.addMouseListener(listener);
        }

        private void setCommitId(String id) {
            this._commitId.setText(id);
        }

        private void setMessage(String msg) {
            this._message.setText(msg);
        }

        private void init() {
            this._commitId = new JTextField();
            this._msgLabel = new JLabel();
            this._message = new JTextArea();
            this._fileLst = new JLabel();
            this._table = new GenericTable();
            this._linkButton = new HyperlinkButton();
            this._linkLabel = new JLabel();
        }

        private void initRes() {
            this._message.setEditable(false);
            this._message.setWrapStyleWord(true);
            this._message.setLineWrap(true);
            this._message.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._message.setRows(3);
            Font font = this._commitId.getFont();
            this._commitId.setFont(new Font(font.getFontName(), 1, font.getSize()));
            this._commitId.setEditable(false);
            this._commitId.setBackground(null);
            this._commitId.setBorder(null);
            ResourceUtils.resLabel((JLabel)this._msgLabel, (Component)this._message, (String)CommitVersionDockableWindow.this.getMessageLabel());
            ResourceUtils.resLabel((JLabel)this._fileLst, (Component)this._table, (String)Bundle.get("COMMIT_HISTORY_FILE_LIST"));
            this._linkButton.setVisible(false);
            this._table.setName("Table File List");
            this._fileLst.setName("Label File List");
        }

        private void layoutComponents() {
            TabbedComponent[] tabbed = CommitVersionDockableWindow.this.getTabbedComponents();
            Insets ins = new Insets(5, 5, 5, 5);
            Insets insS = new Insets(5, 5, 0, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._commitId, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._linkLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
            this.add((Component)this._linkButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
            this.add((Component)this._msgLabel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, insS, 0, 0));
            this.add((Component)new JScrollPane(this._message), new GridBagConstraints(0, 2, 3, 2, 1.0, 0.25, 17, 1, ins, 0, 0));
            if (tabbed.length > 0) {
                this._tabPane = new JTabbedPane();
                this._tabPane.add(StringUtils.stripMnemonic((String)Bundle.get("COMMIT_HISTORY_FILE_LIST")), new JScrollPane((Component)this._table));
                this.add((Component)this._tabPane, new GridBagConstraints(0, 5, 3, 2, 1.0, 1.0, 17, 1, ins, 0, 0));
                for (int ind = 0; ind < tabbed.length; ++ind) {
                    this._tabPane.add(tabbed[ind].getName(), tabbed[ind].getComponent());
                }
            } else {
                this.add((Component)this._fileLst, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, insS, 0, 0));
                this.add((Component)new JScrollPane((Component)this._table), new GridBagConstraints(0, 5, 3, 2, 1.0, 1.0, 17, 1, ins, 0, 0));
            }
        }

        private void setFiles(Collection<CommitHistoryDetail.FileDetail> fileDetail) {
            Object model = this._table.getModel();
            this._table.setSorted(false);
            if (!(model instanceof CommitDetailModel)) {
                DisplayProperty[] properties = this.getDisplayProperties();
                model = new CommitDetailModel(properties);
                this.installModel((CommitDetailModel)((Object)model));
            }
            ((CommitDetailModel)((Object)model)).addItems(fileDetail);
            this._table.setSorted(true);
        }

        private void installModel(CommitDetailModel model) {
            this._table.setModel((TableModel)((Object)model));
            if (this._labelEllipseRenderer == null) {
                this._labelEllipseRenderer = new GITFilePathTableEllipseRenderer();
            }
            this._table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)((Object)this._labelEllipseRenderer)));
            this._table.setSorted(true);
            CommitVersionDockableWindow.this.autoSizeCoumnstoFit(this._table, model);
        }

        private DisplayProperty[] getDisplayProperties() {
            DisplayProperty[] props = new DisplayProperty[]{new ClientDisplayProperty(Bundle.get("COMMIT_HISTORY_EDIT_TYPE"), null, 2, " Modified ", null, String.class, 100), new ClientDisplayProperty(Bundle.get("COMMIT_HISTORY_FILE_PATH"), null, 2, " /some/example/path/that/is/reasonably/long/for/a/file/that/is/under/git/control ", null, String.class, 300), new ClientDisplayProperty(Bundle.get("COMMIT_HISTORY_ADD"), null, 0, " 99999 ", null, String.class, 100), new ClientDisplayProperty(Bundle.get("COMMIT_HISTORY_DELETE"), null, 0, " 99999 ", null, String.class, 100)};
            return props;
        }

        private String getSelectedFile() {
            int row = this._table.getSelectedRowInModel();
            if (row > -1) {
                return (String)this._table.getModel().getValueAt(row, 1);
            }
            return null;
        }

        private String getCommitId() {
            return this._commitId.getText();
        }

        private void setLink(Action action) {
            if (action != null) {
                this._linkButton.setAction(action);
                this._linkButton.setVisible(true);
                this._linkLabel.setVisible(true);
            } else {
                this._linkButton.setAction(null);
                this._linkButton.setVisible(false);
                this._linkLabel.setVisible(false);
            }
        }

        private void setLinkLabel(String text) {
            ResourceUtils.resLabel((JLabel)this._linkLabel, (Component)this._linkButton, (String)text);
        }

        private void clear() {
            this.setCommitId("");
            this.setMessage("");
            this.setFiles(Collections.emptyList());
            this.setLink(null);
            this.setLinkLabel("");
        }

        private class GITFilePathTableEllipseRenderer
        extends LabelTableCellRenderer {
            private GITFilePathTableEllipseRenderer() {
            }

            public void formatLabel(JLabel label, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Ellipses.setEllipsesLocation((JLabel)label, (int)10);
            }
        }

        private class CommitDetailModel
        extends CommonTableModel {
            private List<CommitHistoryDetail.FileDetail> _items;

            CommitDetailModel(DisplayProperty[] prop) {
                super(prop);
            }

            public Object getValueAt(int row, int col) {
                if (row >= this._items.size()) {
                    return null;
                }
                CommitHistoryDetail.FileDetail detail = this._items.get(row);
                switch (col) {
                    case 0: {
                        return detail.getEditType();
                    }
                    case 1: {
                        return detail.getPath();
                    }
                    case 2: {
                        return detail.getAdd();
                    }
                    case 3: {
                        return detail.getDelete();
                    }
                }
                return null;
            }

            public int getRowCount() {
                if (this._items == null) {
                    return 0;
                }
                return this._items.size();
            }

            private void addItems(Collection<CommitHistoryDetail.FileDetail> items) {
                if (this._items == null) {
                    this._items = Collections.synchronizedList(new ArrayList());
                } else {
                    if (this._items.size() > 0) {
                        this.fireTableRowsDeleted(0, this._items.size() - 1);
                    }
                    this._items.clear();
                }
                this._items.addAll(items);
                if (items.size() > 0) {
                    this.fireTableRowsInserted(0, items.size() - 1);
                }
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        private final void selectOnRightClick(MouseEvent me) {
            int row = CommitVersionDockableWindow.this.getCommitTable().rowAtPoint(me.getPoint());
            if (row < 0 || row >= CommitVersionDockableWindow.this.getCommitTable().getModel().getRowCount()) {
                return;
            }
            if (!CommitVersionDockableWindow.this.getCommitTable().isRowSelected(row)) {
                CommitVersionDockableWindow.this.getCommitTable().setRowSelectionInterval(row, row);
            }
            CommitVersionDockableWindow.this.getGUI().requestFocus();
        }
    }

    public class TabbedComponent {
        private String _name;
        private char _mnemonic;
        private JComponent _component;

        public TabbedComponent(String name, char mnemonic, JComponent component) {
            this._name = name;
            this._mnemonic = mnemonic;
            this._component = component;
        }

        public String getName() {
            return this._name;
        }

        public char getMnemonic() {
            return this._mnemonic;
        }

        public JComponent getComponent() {
            return this._component;
        }
    }
}

