/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset.cmd;

import java.util.HashMap;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;

public final class CommentTemplatesConfiguration {
    private static final Map<String, CommentTemplatesConfiguration> _configurations = new HashMap<String, CommentTemplatesConfiguration>();
    private VCSRecentCommentsModel _commentsModel;
    private String _systemShortLabel;
    private String[] _settingsRelativePath;

    public final void setRecentCommentsModel(VCSRecentCommentsModel commentsModel) {
        this._commentsModel = commentsModel;
    }

    public final VCSRecentCommentsModel getRecentCommentsModel() {
        return this._commentsModel;
    }

    public final void setTemplatesSettingsPathParams(String systemShortLabel, String[] settingsRelativePath) {
        this._systemShortLabel = systemShortLabel;
        this._settingsRelativePath = settingsRelativePath;
    }

    public final String getSystemShortLabel() {
        return this._systemShortLabel;
    }

    public final String[] getTemplatesSettingsRelativePath() {
        return this._settingsRelativePath;
    }

    public static final void register(String extensionId, CommentTemplatesConfiguration configuration) {
        _configurations.put(extensionId, configuration);
    }

    static final void configure(VCSCommentsCustomizer commentsCustomizer, String extensionId) {
        commentsCustomizer.setShowTemplatesAndCommentsCombo(false);
        CommentTemplatesConfiguration configuration = _configurations.get(extensionId);
        if (configuration == null) {
            return;
        }
        commentsCustomizer.setShowTemplatesAndCommentsCombo(true);
        commentsCustomizer.setRecentCommentsModel(configuration.getRecentCommentsModel());
        commentsCustomizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath(configuration.getSystemShortLabel(), configuration.getTemplatesSettingsRelativePath()));
    }
}

