/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.util.VCSNodeIconUtils;

public class ChangeListItem
extends DefaultElement
implements Locatable {
    private final URL _url;
    private final Collection<Project> _projects;
    private IconOverlay _overlay;
    private Icon _icon;

    public ChangeListItem(URL url, IconOverlay overlay) {
        this(url, null, overlay);
    }

    public ChangeListItem(URL url, Collection<Project> projects, IconOverlay overlay) {
        this._url = url;
        this._projects = projects != null ? Collections.unmodifiableCollection(projects) : null;
        this.setOverlay(overlay);
    }

    public Node findNode() {
        return NodeFactory.find((URL)this._url);
    }

    public Node findOrCreateNode() throws IllegalAccessException, InstantiationException {
        return NodeFactory.findOrCreate((URL)this._url);
    }

    public synchronized Icon getIcon() {
        if (this._icon == null) {
            this._icon = this.createIcon();
        }
        return this._icon;
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this._url);
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o instanceof ChangeListItem) {
            return URLFileSystem.equals((URL)((ChangeListItem)((Object)o)).getURL(), (URL)this.getURL());
        }
        return false;
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    public IconOverlay getOverlay() {
        return this._overlay;
    }

    public synchronized void setOverlay(IconOverlay overlay) {
        if (overlay != this._overlay) {
            this._icon = null;
        }
        this._overlay = overlay;
    }

    public final Project getProject() {
        return this._projects != null && !this._projects.isEmpty() ? this._projects.iterator().next() : null;
    }

    public final Collection<Project> getProjects() {
        return this._projects;
    }

    private final Icon createIcon() {
        Node n = this.findNode();
        Icon baseIcon = null;
        if (baseIcon == null && n != null) {
            baseIcon = n.getIcon();
        }
        if (baseIcon == null) {
            baseIcon = VCSNodeIconUtils.getIconForURL(this._url);
        }
        if (this._overlay == null) {
            return baseIcon;
        }
        try {
            return new OverlayIcon(baseIcon, this._overlay.getDisplayable().getIcon());
        }
        catch (Exception e) {
            return baseIcon;
        }
    }
}

