/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingWorker;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCategorizer;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventListener;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.RemovedEntryLister;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.DisplayableComparator;
import oracle.jdevimpl.vcs.util.FileSystemLister;
import oracle.jdevimpl.vcs.util.ProfileFileSystemLister;

public class ChangeListEventQueue {
    private final ChangeList _changeList;
    private final List<ChangeListEvent> _queue = new LinkedList<ChangeListEvent>();
    private boolean _alive = true;
    private int _updateDelay;
    private Thread _thread;
    private VCSCancellable _cancellable;
    private Collection<ChangeListEventListener> _eventListeners = new ArrayList<ChangeListEventListener>();
    private static final boolean DEBUG = true;
    private String _vcsId;
    private static final Log LOG = new Log("vcs");

    public final void setSystemId(String vcsId) {
        this._vcsId = vcsId;
    }

    public final String getSystemId() {
        return this._vcsId;
    }

    public ChangeListEventQueue(ChangeList changeList) {
        this(changeList, 500);
    }

    public ChangeListEventQueue(ChangeList changeList, int updateDelay) {
        this._updateDelay = updateDelay;
        this._changeList = changeList;
    }

    protected ChangeList getChangeList() {
        return this._changeList;
    }

    public synchronized void addEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.add(eventListener);
    }

    public synchronized void removeEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.remove(eventListener);
    }

    public synchronized void setUpdateDelay(int updateDelay) {
        this._updateDelay = updateDelay;
    }

    public synchronized int getUpdateDelay() {
        return this._updateDelay;
    }

    public synchronized boolean isAlive() {
        return this._alive;
    }

    public synchronized void enqueue(ChangeListEvent event) {
        this._queue.add(event);
        this.notifyAll();
    }

    synchronized void curtail() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            cle.curtail();
        }
    }

    protected ChangeListItem[] createChangeListItems(URL[] urls) {
        return this.createChangeListItems(urls, true);
    }

    protected ChangeListItem[] createChangeListItems(URL[] urls, boolean bOverlay) {
        ChangeListItem[] items = new ChangeListItem[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            items[i] = this.createChangeListItem(urls[i], bOverlay);
        }
        return items;
    }

    protected ChangeListItem createChangeListItem(URL url) {
        VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        VCSOverlayItem overlayItem = null;
        try {
            overlayItem = overlayItemProducer != null ? overlayItemProducer.getOverlayItems(new URL[]{url})[0] : null;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return new ChangeListItem(url, this.findProjectsForURL(url), overlayItem != null ? overlayItem.getOverlay() : null);
    }

    private final Collection<Project> findProjectsForURL(URL url) {
        Collection contentSetRoots = ContentSetRoot.getContentSetRootsContaining((URL)url);
        if (contentSetRoots == null) {
            return null;
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        for (ContentSetRoot contentSetRoot : contentSetRoots) {
            projects.add(contentSetRoot.getProject());
        }
        return projects;
    }

    protected ChangeListItem createChangeListItem(URL url, boolean bOverlay) {
        if (bOverlay) {
            return this.createChangeListItem(url);
        }
        return new ChangeListItem(url, this.findProjectsForURL(url), null);
    }

    protected void setChangeListBusy(final boolean isBusy) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeListEventQueue.this._changeList.setBusy(isBusy);
            }
        });
    }

    protected void processEvent(ChangeListEvent cle) throws Exception {
        if (cle.getKind() == 0) {
            this.processRequeryEvent(cle);
        }
        if (cle.getKind() == 1) {
            this.processOverlayChange(cle);
        }
        if (cle.getKind() == 2) {
            cle.getRunnable().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void processRequeryEvent(final ChangeListEvent cle) throws Exception {
        Map<VCSHashURL, String> categoryCache;
        void var7_23;
        final ChangeListCategorizer categorizer = this._changeList.getCategorizer();
        if (categorizer != null) {
            Object object = categorizer.getRequeryMutex();
            synchronized (object) {
                if (!categorizer.canRequery()) {
                    categorizer.getRequeryMutex().wait();
                }
            }
        }
        LinkedHashSet<? extends VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
        if (this.useVCSStatusURLS()) {
            urls.addAll(this.getVCSStatusURLS(cle));
        } else {
            if (cle.getWorkspaces() != null) {
                for (Workspace workspace : cle.getWorkspaces()) {
                    Iterator<URL> itr = VCSApplicationSystem.getApplicationSystem().createWorkspaceOnlyIterator(workspace, VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES);
                    while (itr.hasNext()) {
                        urls.add(new VCSHashURL(itr.next()));
                    }
                }
            }
            if (cle.getProjects() != null) {
                for (Workspace workspace : cle.getProjects()) {
                    urls.addAll(this.listProjectURLs((Project)workspace));
                }
            }
            if (cle.getURLs() != null) {
                urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(cle.getURLs())));
            }
        }
        StatusCacheEvent sce = cle.getStatusCacheEvent();
        if (sce != null) {
            urls.addAll(this.listURLs(sce.getURLs(), sce.getDepth()));
        }
        if (cle.getObjects() != null) {
            URL[] urls0 = VCSModelUtils.convertNodesToURLs(VCSModelUtils.getValidLocatables(cle.getObjects(), null));
            urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(urls0)));
            if (!this._changeList.isExcludeDirectories()) {
                URLPath projectUrlPath = new URLPath();
                for (Project project : VCSModelUtils.findCachedProjects()) {
                    projectUrlPath.add(new ChangeListProjectContent(project).getBaseURLPath());
                }
                for (URL uRL : VCSFileSystemUtils.getParentURLs(urls0)) {
                    if (projectUrlPath.getLongestMatchingEntry(uRL) == null) continue;
                    urls.add(new VCSHashURL(uRL));
                }
            }
        }
        ArrayList<VCSHashURL> urls0 = new ArrayList<VCSHashURL>(urls);
        this.filterByProtocol(urls0);
        for (int i = 0; i < urls0.size(); ++i) {
            VCSHashURL vCSHashURL = urls0.get(i);
            String suffix = URLFileSystem.getSuffix((URL)vCSHashURL.getURL());
            if (!suffix.equals(".jws") && !suffix.equals(".jpr")) continue;
            urls0.set(i, new VCSHashURL(URLFileSystem.canonicalize((URL)vCSHashURL.getURL())));
        }
        ArrayList<VCSHashURL> urls1 = new ArrayList<VCSHashURL>(urls0);
        Object var7_21 = null;
        ArrayList<VCSHashURL> urls3 = null;
        if (categorizer != null) {
            ArrayList<VCSHashURL> arrayList = new ArrayList<VCSHashURL>(urls0);
            urls3 = new ArrayList<VCSHashURL>(urls0);
        }
        this.filterByStatus(urls0);
        if (!this.isAlive()) {
            return;
        }
        urls1.removeAll(urls0);
        final ArrayList<ChangeListItem> validItems = new ArrayList<ChangeListItem>(Arrays.asList(this.createChangeListItems(VCSHashURL.convertToURLs(urls0).toArray(new URL[0]))));
        final List<ChangeListItem> list = cle.isReplace() ? null : Arrays.asList(this.createChangeListItems(VCSHashURL.convertToURLs(urls1).toArray(new URL[0]), false));
        Collections.sort(validItems, new DisplayableComparator());
        if (categorizer != null) {
            this.filterByStatus((Collection<VCSHashURL>)var7_23, false);
        }
        Map<VCSHashURL, String> map = categoryCache = categorizer != null ? categorizer.mapURLsToCategory(VCSHashURL.convertToURLs((Collection<VCSHashURL>)var7_23)) : null;
        if (categorizer != null) {
            urls3.removeAll((Collection<?>)var7_23);
        }
        final ArrayList<VCSHashURL> final_urls3 = urls3;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (cle.isReplace()) {
                    if (categorizer != null) {
                        ChangeListEventQueue.this._changeList.setCategoryCache(categoryCache);
                    }
                    ChangeListEventQueue.this._changeList.getModel().replace(validItems);
                    return;
                }
                if (categorizer != null) {
                    HashMap<VCSHashURL, String> currentCache = new HashMap<VCSHashURL, String>(ChangeListEventQueue.this._changeList.getCategoryCache());
                    currentCache.keySet().removeAll(final_urls3);
                    currentCache.putAll(categoryCache);
                    ChangeListEventQueue.this._changeList.setCategoryCache(currentCache);
                }
                ChangeListEventQueue.this._changeList.getModel().remove(list);
                ChangeListEventQueue.this._changeList.getModel().add(validItems);
                if (cle.isUpdate()) {
                    ChangeListEventQueue.this._changeList.getModel().update(validItems);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<VCSHashURL> listURLs(URL[] urls, Depth depth) throws Exception {
        VCSCancellable cancellable = new VCSCancellable();
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this._cancellable = cancellable;
        }
        Collection<VCSHashURL> listedUrls = this.listURLs(urls, depth, cancellable);
        ChangeListEventQueue changeListEventQueue2 = this;
        synchronized (changeListEventQueue2) {
            this._cancellable = null;
        }
        return listedUrls;
    }

    private final Collection<VCSHashURL> listURLs(URL[] urls, Depth depth, VCSCancellable cancellable) {
        if (this.overridesRootTraversal()) {
            ArrayList<VCSHashURL> listedUrls = new ArrayList<VCSHashURL>();
            for (URL url : urls) {
                if (cancellable.isCancelled()) break;
                listedUrls.add(new VCSHashURL(url));
                if (depth == Depth.EMPTY || !URLFileSystem.isDirectoryPath((URL)url)) continue;
                listedUrls.addAll(this.listURLsForRoot(url, depth));
            }
            return listedUrls;
        }
        return VCSHashURL.convertFromURLs(Arrays.asList(new ProfileFileSystemLister(this.getSystemId()).listFiles(urls, FileSystemLister.ListMode.FILES_AND_DIRECTORIES, depth, null).toArray(new URL[0])));
    }

    protected Collection<VCSHashURL> listURLsForRoot(URL root, Depth depth) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<VCSHashURL> listProjectURLs(Project project) throws Exception {
        VCSCancellable cancellable = new VCSCancellable();
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this._cancellable = cancellable;
        }
        List<VCSHashURL> listedUrls = Collections.emptyList();
        if (project.isOpen()) {
            listedUrls = this.listProjectURLs(project, new ChangeListProjectContent(project), cancellable);
        }
        ChangeListEventQueue changeListEventQueue2 = this;
        synchronized (changeListEventQueue2) {
            this._cancellable = null;
        }
        return listedUrls;
    }

    protected Collection<VCSHashURL> listProjectURLs(Project project, ChangeListProjectContent projectContent, VCSCancellable cancellable) throws Exception {
        if (this.overridesRootTraversal()) {
            ArrayList<VCSHashURL> listedUrls = new ArrayList<VCSHashURL>();
            listedUrls.addAll(this.listURLsForRoot(URLFileSystem.getParent((URL)project.getURL()), Depth.IMMEDIATES));
            for (URL root : projectContent.getBaseDirectoryURLs()) {
                listedUrls.addAll(this.listURLsForRoot(root, Depth.INFINITY));
            }
            return listedUrls;
        }
        Collection<VCSHashURL> urls = VCSHashURL.convertFromURLs(Arrays.asList(projectContent.listURLs(!this._changeList.isExcludeDirectories(), cancellable)));
        if (!this.supportsRemovedEntries()) {
            return urls;
        }
        urls = new HashSet<VCSHashURL>(urls);
        if (project.isOpen() && this.isAlive()) {
            this.addRemovedEntryURLs(urls, URLFileSystem.getParent((URL)project.getURL()), cancellable);
        }
        Iterator<URL> itr = VCSApplicationSystem.getApplicationSystem().createProjectIterator(project, VCSApplicationSystem.ListMode.DIRECTORIES_ONLY);
        while (itr.hasNext() && (cancellable == null || !cancellable.isCancelled()) && this.isAlive()) {
            this.addRemovedEntryURLs(urls, itr.next(), cancellable);
        }
        return new ArrayList<VCSHashURL>(urls);
    }

    protected boolean supportsRemovedEntries() {
        VCSProfile profile;
        VCSProfile vCSProfile = profile = this._vcsId != null ? VCSProfileRegistry.getInstance().getProfile(this._vcsId) : null;
        if (profile == null) {
            return false;
        }
        RemovedEntryLister removedEntryLister = profile.getRemovedEntryLister();
        return removedEntryLister != null;
    }

    protected boolean overridesRootTraversal() {
        return false;
    }

    protected boolean overridesFilterByStatus() {
        return false;
    }

    protected void addRemovedEntryURLs(Collection<VCSHashURL> urls, URL directoryUrl, VCSCancellable cancellable) throws Exception {
        VCSProfile profile;
        VCSProfile vCSProfile = profile = this._vcsId != null ? VCSProfileRegistry.getInstance().getProfile(this._vcsId) : null;
        if (profile == null) {
            return;
        }
        RemovedEntryLister removedEntryLister = profile.getRemovedEntryLister();
        if (removedEntryLister == null) {
            return;
        }
        urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(removedEntryLister.listRemovedEntries(directoryUrl))));
    }

    private void filterByProtocol(Collection<VCSHashURL> urls) throws Exception {
        Iterator<VCSHashURL> itr = urls.iterator();
        while (itr.hasNext() && this.isAlive()) {
            VCSHashURL url = itr.next();
            if (this._changeList.getItemURLFilter().accept(url.getURL())) continue;
            LOG.trace("ChangeList: Ignoring URL: " + url);
            itr.remove();
        }
    }

    protected void filterByStatus(Collection<VCSHashURL> urls) throws Exception {
        ChangeListWindow.ScopeFilter scopeFilter = (ChangeListWindow.ScopeFilter)this.getChangeList().getScopeFilter();
        this.filterByStatus(urls, scopeFilter == null ? false : scopeFilter.isScoped());
    }

    protected void filterByStatus(Collection<VCSHashURL> urls, boolean applyScope) throws Exception {
        ChangeListWindow.ScopeFilter scopeFilter;
        if (this._changeList.isExcludeDirectories()) {
            Iterator<VCSHashURL> itr = urls.iterator();
            while (itr.hasNext()) {
                if (!URLFileSystem.isDirectoryPath((URL)itr.next().getURL())) continue;
                itr.remove();
            }
        }
        if (applyScope && (scopeFilter = (ChangeListWindow.ScopeFilter)this._changeList.getScopeFilter()) != null) {
            scopeFilter.clearCache();
            Iterator<VCSHashURL> itr = urls.iterator();
            while (itr.hasNext()) {
                if (scopeFilter.accept(itr.next().getURL())) continue;
                itr.remove();
            }
        }
        if (!this.overridesFilterByStatus()) {
            this.filterByStatusImpl(urls);
        }
    }

    private final void filterByStatusImpl(Collection<VCSHashURL> urls) throws Exception {
        LinkedList<VCSHashURL> urls0 = new LinkedList<VCSHashURL>(urls);
        ArrayList<VCSHashURL> urls1 = new ArrayList<VCSHashURL>();
        ArrayList<Object> urlStatuses = new ArrayList<Object>();
        int batchCount = this.getBatchCount();
        while (!urls0.isEmpty() && this.isAlive()) {
            for (int i = 0; i < batchCount && !urls0.isEmpty(); ++i) {
                urls1.add(urls0.removeFirst());
            }
            urlStatuses.addAll(Arrays.asList(this.getStatuses(VCSHashURL.convertToURLs(urls1).toArray(new URL[0]))));
            urls1.clear();
        }
        if (!this.isAlive()) {
            return;
        }
        List<Object> displayStatuses = this._changeList.getVisibleStatuses() != null ? Arrays.asList(this._changeList.getVisibleStatuses()) : null;
        List<Object> filterStatuses = this._changeList.getFilterStatuses() != null ? Arrays.asList(this._changeList.getFilterStatuses()) : null;
        int i = 0;
        Iterator<VCSHashURL> itr = urls.iterator();
        while (itr.hasNext()) {
            VCSHashURL url = itr.next();
            if (url != null) {
                if (!displayStatuses.contains(urlStatuses.get(i))) {
                    itr.remove();
                } else if (filterStatuses != null && !filterStatuses.contains(urlStatuses.get(i))) {
                    itr.remove();
                }
            }
            ++i;
        }
    }

    private final Object[] getStatuses(URL[] urls) throws Exception {
        if (this._changeList.getPolicyStatusCache() != null) {
            return this._changeList.getPolicyStatusCache().get(urls);
        }
        if (this._changeList.getStatusCache() != null) {
            return this._changeList.getStatusCache().getValues(urls);
        }
        throw new IllegalStateException();
    }

    protected int getBatchCount() {
        return 10;
    }

    protected void processOverlayChange(ChangeListEvent cle) throws Exception {
        final URLFilter filter = cle.getURLs() != null ? StatusCacheUtil.createDepthFilter(cle.getURLs(), Depth.EMPTY) : StatusCacheUtil.createDepthFilter(cle.getStatusCacheEvent().getURLs(), cle.getStatusCacheEvent().getDepth());
        final VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        if (overlayItemProducer == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final ArrayList<URL> urls = new ArrayList<URL>();
                final ArrayList<ChangeListItem> items = new ArrayList<ChangeListItem>();
                for (int i = 0; i < ChangeListEventQueue.this._changeList.getModel().getCount(); ++i) {
                    ChangeListItem changeListItem = (ChangeListItem)ChangeListEventQueue.this._changeList.getModel().getItem(i);
                    if (!filter.accept(changeListItem.getURL())) continue;
                    urls.add(changeListItem.getURL());
                    items.add(changeListItem);
                }
                SwingWorker<VCSOverlayItem[], Object> worker = new SwingWorker<VCSOverlayItem[], Object>(){

                    @Override
                    public VCSOverlayItem[] doInBackground() throws Exception {
                        return overlayItemProducer.getOverlayItems(urls.toArray(new URL[0]));
                    }

                    @Override
                    public void done() {
                        try {
                            VCSOverlayItem[] overlayItems = (VCSOverlayItem[])this.get();
                            for (int i = 0; i < urls.size(); ++i) {
                                ((ChangeListItem)((Object)items.get(i))).setOverlay(overlayItems[i].getOverlay());
                                ChangeListEventQueue.this._changeList.getModel().update(Collections.singleton(items.get(i)));
                            }
                        }
                        catch (Exception e) {
                            FeedbackManager.reportException((Throwable)e);
                        }
                    }
                };
                worker.execute();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ChangeListEventQueue.this.eventLoop();
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
                ChangeListEventQueue.this._alive = false;
                ChangeListEventQueue.this.cancelListProjects();
            }
        };
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this._thread = new Thread(r, "ChangeListEventQueue " + this._changeList.getWindowId());
            this._thread.setPriority(1);
            this._alive = true;
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this.setAlive(false);
            this.cancelListProjects();
            this._thread = null;
        }
    }

    private synchronized void setAlive(boolean isAlive) {
        this._alive = isAlive;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelListProjects() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            if (this._cancellable != null) {
                this._cancellable.cancel();
            }
            this._cancellable = null;
        }
    }

    private void processEvents() throws InterruptedException {
        while (!this.isEmpty()) {
            if (!this.isAlive()) {
                return;
            }
            ChangeListEvent cle = this.dequeue();
            if (cle.isCurtailed()) continue;
            LOG.trace("ChangeList: Processing " + cle);
            try {
                this.fireEventDispatched(cle);
                this.processEvent(cle);
                this.fireEventProcessed(cle);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void fireEventDispatched(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].eventDispatched(cle);
        }
    }

    private synchronized void fireEventProcessed(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].eventProcessed(cle);
        }
    }

    private synchronized ChangeListEvent peekMajorEvent() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            return cle;
        }
        return null;
    }

    private synchronized ChangeListEvent dequeue() {
        ChangeListEvent event = this._queue.remove(0);
        this.notifyAll();
        return event;
    }

    private synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    private synchronized void awaitEvents() throws InterruptedException {
        while (this.isEmpty() && this.isAlive()) {
            this.wait();
        }
    }

    private void eventLoop() throws InterruptedException {
        while (true) {
            this.setChangeListBusy(false);
            this.awaitEvents();
            if (!this.isAlive()) {
                return;
            }
            Thread.sleep(this._updateDelay);
            if (this.peekMajorEvent() != null) {
                this.setChangeListBusy(true);
            }
            this.processEvents();
        }
    }

    protected boolean useVCSStatusURLS() {
        return false;
    }

    protected Collection<? extends VCSHashURL> getVCSStatusURLS(ChangeListEvent cle) {
        return Collections.emptyList();
    }
}

