/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.merge.MergeNode;
import oracle.jdeveloper.merge.MergeURLFileSystemHelper;

public abstract class BaseMergeNode<T>
extends Node
implements MergeNode<T> {
    private T _saveResult;
    private URL _saveUrl;
    private boolean _skipSave;

    @Override
    public final void setSaveResult(T saveResult) {
        this._saveResult = saveResult;
    }

    @Override
    public final void setSaveURL(URL saveUrl) {
        this._saveUrl = saveUrl;
    }

    @Override
    public final void setSkipSave(boolean skipSave) {
        this._skipSave = skipSave;
    }

    @Override
    public final boolean isSkipSave() {
        return this._skipSave;
    }

    public BaseMergeNode(URL url) {
        super(MergeURLFileSystemHelper.newMergeURL(url));
        this.initializeAttributes();
    }

    protected void initializeAttributes() {
        this.getAttributes().unset(ElementAttributes.DELETEABLE);
        this.getAttributes().unset(ElementAttributes.RENAMEABLE);
        this.getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
    }

    public final boolean setReadOnly(boolean readOnly) {
        return true;
    }

    public final Icon getIcon() {
        return OracleIcons.getIcon((String)"union.png");
    }

    protected final void saveImpl() throws IOException {
        URL saveUrl;
        if (this.isSkipSave()) {
            return;
        }
        if (this._saveResult == null) {
            return;
        }
        URL uRL = saveUrl = this._saveUrl != null ? this._saveUrl : MergeURLFileSystemHelper.getSaveURL(this.getURL());
        if (saveUrl == null) {
            throw new NullPointerException("saveUrl");
        }
        if ("ide.merge".equals(saveUrl.getProtocol())) {
            throw new IllegalStateException("attempt to save merge protocol URL");
        }
        this.saveResultToURL(this._saveResult, saveUrl);
    }

    protected abstract void saveResultToURL(T var1, URL var2);
}

