/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class UnsupportedOIDsInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_UnsupportedOIDs;
    Vector oids = new Vector();

    public UnsupportedOIDsInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public UnsupportedOIDsInfo(ASN1ObjectID oid) {
        this();
        this.addOID(oid);
    }

    public UnsupportedOIDsInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public void addOID(ASN1ObjectID oid) {
        this.oids.addElement(oid);
        this.encoded = false;
    }

    public Vector getOIDs() {
        this.decodeValue();
        return this.oids;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("UnsupportedOIDs { ");
        int n = this.oids.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.oids.elementAt(i).toString());
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append(" }");
        return s.toString();
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue((ASN1Object)new ASN1Sequence(this.oids));
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.getValue()));
                this.oids.removeAllElements();
                while (sis.hasMoreData()) {
                    this.oids.addElement(new ASN1ObjectID((InputStream)sis));
                }
                sis.terminate();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

