/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.RegistrationControl;

public class RegTokenRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_regToken;
    private String regToken;

    public RegTokenRegControl() {
        super(TYPE, null);
    }

    public RegTokenRegControl(String regToken) {
        this();
        this.regToken = regToken;
    }

    public RegTokenRegControl(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public String getToken() {
        this.decodeValue();
        return this.regToken;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            ASN1String str = new ASN1String(this.regToken, 12);
            this.setValue((ASN1Object)str);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            this.regToken = ((ASN1String)this.getValue()).getValue();
            this.decoded = true;
        }
    }
}

