/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.attribute.RegistrationControl;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.StreamableOutputException;

public class ProtocolEncrKeyRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_protocolEncrKey;
    private PublicKey key;

    public ProtocolEncrKeyRegControl() {
        super(TYPE, null);
    }

    public ProtocolEncrKeyRegControl(PublicKey key) {
        this();
        this.key = key;
    }

    public ProtocolEncrKeyRegControl(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public PublicKey getEncryptionKey() {
        this.decodeValue();
        return this.key;
    }

    @Override
    protected void encodeValue() {
        try {
            if (!this.encoded) {
                this.setValue((ASN1Object)CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)CMPUtils.toPhaosPublicKey(this.key)));
                this.encoded = true;
                this.decoded = true;
            }
        }
        catch (InvalidKeyException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                this.key = CMPUtils.toJCEPublicKey(CryptoUtils.inputSPKI((ASN1Sequence)((ASN1Sequence)this.getValue())));
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

