/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class PreferredSymmAlgInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_PreferredSymmAlg;
    private AlgorithmIdentifier algID;

    public PreferredSymmAlgInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public PreferredSymmAlgInfo(AlgorithmIdentifier algID) {
        this();
        this.algID = algID;
        this.encoded = false;
    }

    public PreferredSymmAlgInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public AlgorithmIdentifier getAlgID() {
        this.decodeValue();
        return this.algID;
    }

    @Override
    public String toString() {
        return "PreferredSymmAlg { " + this.getAlgID() + " }";
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue((ASN1Object)this.algID);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            if (this.getValue() != null) {
                try {
                    this.algID = new AlgorithmIdentifier(Utils.toStream((Streamable)this.getValue()));
                }
                catch (IOException ex) {
                    throw new StreamableInputException(ex.toString());
                }
            } else {
                this.algID = null;
            }
            this.decoded = true;
        }
    }
}

