/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.RegistrationControl;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class OldCertIDRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_olderCertID;
    private GeneralName issuer;
    private BigInteger serialNumber;

    public OldCertIDRegControl() {
        super(TYPE, null);
    }

    public OldCertIDRegControl(GeneralName issuer, BigInteger serialNumber) {
        this();
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public OldCertIDRegControl(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public GeneralName getIssuer() {
        this.decodeValue();
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        this.decodeValue();
        return this.serialNumber;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.issuer);
            seq.addElement((ASN1Object)new ASN1Integer(this.serialNumber));
            this.setValue((ASN1Object)seq);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.getValue()));
                this.issuer = new GeneralName((InputStream)sis);
                this.serialNumber = ASN1Integer.inputValue((InputStream)sis);
                sis.terminate();
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

