/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class CurrentCRLInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_CurrentCRL;
    private CRL crl;

    public CurrentCRLInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public CurrentCRLInfo(CRL crl) {
        this();
        this.crl = crl;
        this.encoded = false;
    }

    public CurrentCRLInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public CRL getCRL() {
        this.decodeValue();
        return this.crl;
    }

    @Override
    public String toString() {
        return "CurrentCRL { " + this.getCRL() + " }";
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue((ASN1Object)this.crl);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            if (this.getValue() != null) {
                try {
                    this.crl = new CRL(Utils.toStream((Streamable)this.getValue()));
                }
                catch (IOException ex) {
                    throw new StreamableOutputException(ex.toString());
                }
            } else {
                this.crl = null;
            }
            this.decoded = true;
        }
    }
}

