/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cmp.CAKeyUpdateAnn;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class CAKeyUpdateInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_CAKeyUpdateInfo;
    private CAKeyUpdateAnn keyUpdate;

    public CAKeyUpdateInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public CAKeyUpdateInfo(CAKeyUpdateAnn keyUpdate) {
        this();
        this.keyUpdate = keyUpdate;
        this.encoded = false;
    }

    public CAKeyUpdateInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public CAKeyUpdateAnn getKeyUpdAnn() {
        this.decodeValue();
        return this.keyUpdate;
    }

    @Override
    public String toString() {
        return "CAKeyUpdateInfo { " + this.getKeyUpdAnn() + " }";
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue(this.keyUpdate);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            try {
                this.keyUpdate = (CAKeyUpdateAnn)PKIMessageBody.inputInstance(Utils.toStream((Streamable)this.getValue()));
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
            this.decoded = true;
        }
    }
}

