/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.KeyAgreementPOP;
import oracle.security.crypto.cmp.KeyEnciphermentPOP;
import oracle.security.crypto.cmp.RAVerifiedPOP;
import oracle.security.crypto.cmp.SignaturePOP;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.StreamableOutputException;

public abstract class ProofOfPossession
implements ASN1Object {
    private transient ASN1Object contents;

    public abstract Type getType();

    public static ProofOfPossession inputInstance(InputStream is) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is);
        int id = pis.read();
        int tag = id & 0x1F;
        ProofOfPossession pop = null;
        if (tag == 0) {
            pis.unread((id & 0) + 5);
            pop = new RAVerifiedPOP(pis);
        } else if (tag == 1) {
            pis.unread((id & 0x20) + 16);
            pop = new SignaturePOP(pis);
        } else if (tag == 2) {
            pis.unread(id);
            ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)pis, 2);
            pop = new KeyEnciphermentPOP((InputStream)cis);
            cis.terminate();
        } else if (tag == 3) {
            pis.unread(id);
            ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)pis, 3);
            pop = new KeyAgreementPOP((InputStream)cis);
            cis.terminate();
        } else {
            throw new ASN1FormatException("Unexpected POP tag: " + tag);
        }
        return pop;
    }

    abstract ASN1Object toASN1Object();

    abstract void clearCache();

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1().output(os);
        }
        catch (StreamableOutputException ex) {
            throw new OutputGenerationException(ex.toString());
        }
    }

    public int length() {
        return this.toASN1().length();
    }

    void update() {
        this.contents = null;
        this.clearCache();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            int tag = this.getType().getValue();
            ASN1Object pop = this.toASN1Object();
            if (tag == 0 || tag == 1) {
                this.contents = ASN1Utils.addImplicitTag((ASN1Object)pop, (int)tag);
            } else if (tag == 2 || tag == 3) {
                this.contents = new ASN1GenericConstructed(pop, tag);
            } else {
                throw new StreamableOutputException("Unrecognized proof-of-possession tag: " + tag);
            }
        }
        return this.contents;
    }

    public static class SubsequentMsg {
        public static final SubsequentMsg ENCR_CERT = new SubsequentMsg(0);
        public static final SubsequentMsg CHALLENGE_RESP = new SubsequentMsg(1);
        private int value;

        private SubsequentMsg(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "encrCert";
                }
                case 1: {
                    return "challengeResp";
                }
            }
            return "tag" + this.value;
        }
    }

    public static class Type {
        public static final Type RA_VERIFIED = new Type(0);
        public static final Type SIGNATURE = new Type(1);
        public static final Type KEY_ENCIPHERMENT = new Type(2);
        public static final Type KEY_AGREEMENT = new Type(3);
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "raVerified";
                }
                case 1: {
                    return "signature";
                }
                case 2: {
                    return "keyEncipherment";
                }
                case 3: {
                    return "keyAgreement";
                }
            }
            return "tag" + this.value;
        }
    }
}

