/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class POPResponse
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.POP_RESPONSE;
    private Vector challengeInts = new Vector();
    private transient ASN1Object contents;

    public POPResponse() {
    }

    public POPResponse(BigInteger challengeInt) {
        this.challengeInts.addElement(challengeInt);
    }

    public POPResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public void addChallengeInt(BigInteger challengeInt) {
        this.challengeInts.addElement(challengeInt);
        this.update();
    }

    public Vector getChallengeInts() {
        return this.challengeInts;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { challengeInts = " + Utils.toString((Vector)this.challengeInts) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.challengeInts.removeAllElements();
        while (sis.hasMoreData()) {
            this.challengeInts.addElement(ASN1Integer.inputValue((InputStream)sis));
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            int n = this.challengeInts.size();
            for (int i = 0; i < n; ++i) {
                s.addElement((ASN1Object)new ASN1Integer((BigInteger)this.challengeInts.elementAt(i)));
            }
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

