/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.CertRequest;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PBMacAlgID;
import oracle.security.crypto.core.PasswordBasedMAC;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

class POPOSigningKey
implements ASN1Object {
    private ASN1Sequence poposkInput;
    private AlgorithmIdentifier sigAlgID;
    private byte[] signature;
    private transient ASN1Object contents;
    private transient boolean decodedPoposkInput = false;
    private transient GeneralName sender;
    private transient ASN1Sequence pkMac;
    private transient AlgorithmIdentifier macAlgID;
    private transient byte[] macBytes;
    private transient ASN1Sequence spki;
    private transient PublicKey pubKey;
    private transient oracle.security.crypto.core.PublicKey oraPubKey;

    public POPOSigningKey(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
    }

    public POPOSigningKey(AlgorithmIdentifier sigAlgID, PublicKey pubKey, GeneralName sender) throws InvalidKeyException {
        this.poposkInput = new ASN1Sequence();
        this.sender = sender;
        this.poposkInput.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)sender, 0));
        this.pubKey = pubKey;
        this.spki = CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)CMPUtils.toPhaosPublicKey(pubKey));
        this.poposkInput.addElement((ASN1Object)this.spki);
        this.sigAlgID = sigAlgID;
        this.oraPubKey = CMPUtils.toPhaosPublicKey(pubKey);
    }

    public POPOSigningKey(AlgorithmIdentifier sigAlgID, PublicKey pubKey, byte[] password, SecureRandom sr) throws AlgorithmIdentifierException {
        int saltLen = 8;
        int moreSalt = 20 - (password.length + saltLen);
        if (moreSalt > 0) {
            saltLen += moreSalt;
        }
        byte[] salt = new byte[saltLen];
        byte[] seed = SecureRandom.getSeed(20);
        sr.setSeed(seed);
        sr.nextBytes(salt);
        PasswordBasedMAC pbmac = new PasswordBasedMAC((AlgorithmIdentifier)new PBMacAlgID(salt, AlgID.sha1, BigInteger.valueOf(1024L), AlgID.hmacSHA), password);
        try {
            this.pubKey = pubKey;
            this.oraPubKey = CMPUtils.toPhaosPublicKey(pubKey);
            this.spki = CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)this.oraPubKey);
            this.macBytes = pbmac.computeDigest(Utils.toBytes((Streamable)this.spki));
        }
        catch (InvalidKeyException ed) {
            throw new AlgorithmIdentifierException(ed.toString());
        }
        this.pkMac = new ASN1Sequence();
        this.macAlgID = pbmac.getAlgID();
        this.pkMac.addElement((ASN1Object)this.macAlgID);
        this.pkMac.addElement((ASN1Object)new ASN1BitString(this.macBytes));
        this.poposkInput = new ASN1Sequence();
        this.poposkInput.addElement((ASN1Object)this.pkMac);
        this.poposkInput.addElement((ASN1Object)this.spki);
        this.sigAlgID = sigAlgID;
    }

    public POPOSigningKey(InputStream is) throws IOException {
        this.input(is);
    }

    public void sign(PrivateKey privKey, SecureRandom sr) throws SignatureException {
        this.sign((ASN1Object)this.poposkInput, privKey, sr);
    }

    public void sign(ASN1Object tbs, PrivateKey privKey, SecureRandom sr) throws SignatureException {
        try {
            Signature sig = Signature.getInstance(CMPUtils.getAlgoName(this.sigAlgID));
            sig.initSign(privKey, sr);
            sig.update(Utils.toBytes((Streamable)tbs));
            this.signature = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
    }

    public boolean verifySignature(PublicKey pubKey, CertRequest certReq) throws SignatureException {
        return this.verifySignature(pubKey, Utils.toBytes((Streamable)certReq));
    }

    public boolean verifySignature(PublicKey pubKey) throws SignatureException {
        return this.verifySignature(pubKey, Utils.toBytes((Streamable)this.poposkInput));
    }

    private boolean verifySignature(PublicKey pubKey, byte[] tbs) throws SignatureException {
        try {
            Signature sig = Signature.getInstance(CMPUtils.getAlgoName(this.sigAlgID));
            sig.initVerify(pubKey);
            sig.update(tbs);
            return sig.verify(this.signature);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
    }

    public AlgorithmIdentifier getSignatureAlgID() {
        return this.sigAlgID;
    }

    public byte[] getSignatureBytes() {
        return this.signature;
    }

    public GeneralName getSenderName() {
        this.decodePoposkInput();
        return this.sender;
    }

    public ASN1Sequence getPKMac() {
        this.decodePoposkInput();
        return this.pkMac;
    }

    public AlgorithmIdentifier getMacAlgID() {
        this.decodePoposkInput();
        return this.macAlgID;
    }

    public byte[] getMacBytes() {
        this.decodePoposkInput();
        return this.macBytes;
    }

    public ASN1Sequence getSPKI() {
        this.decodePoposkInput();
        return this.spki;
    }

    public PublicKey getPublicKey() {
        this.decodePoposkInput();
        return this.pubKey;
    }

    public String toString() {
        this.decodePoposkInput();
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.poposkInput != null) {
            buf.append(" poposkInput = {");
            buf.append(" authInfo = {");
            if (this.sender != null) {
                buf.append(" sender = ");
                buf.append(this.sender);
            }
            if (this.pkMac != null) {
                buf.append(" publicKeyMAC = {");
                buf.append(" algId = ");
                buf.append(this.macAlgID);
                buf.append(", value = ");
                buf.append(this.macBytes != null ? Utils.toHexString((byte[])this.macBytes) : "null");
                buf.append(" }");
            }
            buf.append(" }");
            buf.append(", publicKey = {");
            buf.append(" algorithm = ");
            buf.append(this.pubKey != null ? this.pubKey.getAlgorithm() : "null");
            buf.append(", subjectPublicKey = ");
            buf.append(this.pubKey);
            buf.append(" }");
            buf.append(" }");
        }
        buf.append(", algorithmIdentifier = ");
        buf.append(this.sigAlgID);
        buf.append(", signature = ");
        buf.append(this.signature != null ? Utils.toHexString((byte[])this.signature) : "null");
        buf.append(" }");
        return buf.toString();
    }

    private void decodePoposkInput() {
        if (!this.decodedPoposkInput) {
            this.clearPoposkInputCache();
            if (this.poposkInput != null) {
                try {
                    ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.poposkInput));
                    if (sis.getCurrentTag() == 0) {
                        ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
                        this.sender = new GeneralName((InputStream)cis);
                        cis.terminate();
                        this.pkMac = null;
                        this.macAlgID = null;
                        this.macBytes = null;
                    } else if (sis.getCurrentTag() == 16) {
                        this.pkMac = new ASN1Sequence((InputStream)sis);
                        this.macAlgID = new PBMacAlgID(Utils.toStream((Streamable)this.pkMac.elementAt(0)));
                        this.macBytes = ((ASN1BitString)this.pkMac.elementAt(1)).getValue();
                        this.sender = null;
                    } else {
                        throw new ASN1FormatException("Unexpected tag " + sis.getCurrentTag());
                    }
                    this.spki = new ASN1Sequence((InputStream)sis);
                    this.oraPubKey = CryptoUtils.inputSPKI((ASN1Sequence)this.spki);
                    this.pubKey = CMPUtils.toJCEPublicKey(this.oraPubKey);
                    sis.terminate();
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(ex.toString());
                }
                catch (NoSuchAlgorithmException ed) {
                    throw new IllegalArgumentException(ed.toString());
                }
            }
            this.decodedPoposkInput = true;
        }
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        if (sis.getCurrentTag() == 0) {
            sis.setCurrentTag(16);
            this.poposkInput = new ASN1Sequence((InputStream)sis);
        } else {
            this.poposkInput = null;
        }
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.signature = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.poposkInput != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.poposkInput, (int)0));
            }
            s.addElement((ASN1Object)this.sigAlgID);
            if (this.signature == null) {
                throw new StreamableOutputException("Structure invalid without signature");
            }
            s.addElement((ASN1Object)new ASN1BitString(this.signature));
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
        this.clearPoposkInputCache();
    }

    private void clearPoposkInputCache() {
        this.decodedPoposkInput = false;
        this.sender = null;
        this.pkMac = null;
        this.macAlgID = null;
        this.macBytes = null;
        this.spki = null;
        this.pubKey = null;
    }
}

