/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.EncryptedValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

class POPOPrivKey
implements ASN1Object {
    private EncryptedValue thisMessage;
    private BigInteger subsequentMsg;
    private byte[] dhMAC;
    private transient ASN1Object contents = null;

    public POPOPrivKey(EncryptedValue thisMessage) {
        this.thisMessage = thisMessage;
    }

    public POPOPrivKey(BigInteger subsequentMsg) {
        this.subsequentMsg = subsequentMsg;
    }

    public POPOPrivKey(byte[] dhMAC) {
        this.dhMAC = dhMAC;
    }

    public POPOPrivKey(InputStream is) throws IOException {
        this.input(is);
    }

    public EncryptedValue getThisMessage() {
        return this.thisMessage;
    }

    public BigInteger getSubsequentMsg() {
        return this.subsequentMsg;
    }

    public byte[] getDHMac() {
        return this.dhMAC;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.thisMessage != null) {
            buf.append(" thisMessage = ");
            buf.append(this.thisMessage);
            buf.append(',');
        } else if (this.subsequentMsg != null) {
            buf.append(" subsequentMessage = ");
            buf.append(this.subsequentMsg);
            buf.append(',');
        } else if (this.dhMAC != null) {
            buf.append(" dhMAC = ");
            buf.append(Utils.toHexString((byte[])this.dhMAC));
            buf.append(',');
        } else {
            buf.append(" null");
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        buf.append(" }");
        return buf.toString();
    }

    public void input(InputStream is) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is);
        this.thisMessage = null;
        this.subsequentMsg = null;
        this.dhMAC = null;
        int ch = pis.read();
        int tag = ch & 0x1F;
        switch (tag) {
            case 0: {
                pis.unread((ch & 0) + 3);
                byte[] b = ASN1BitString.inputValue((InputStream)pis);
                this.thisMessage = new EncryptedValue((InputStream)new UnsyncByteArrayInputStream(b));
                break;
            }
            case 1: {
                pis.unread((ch & 0) + 2);
                int i = ASN1Integer.inputValue((InputStream)pis).intValue();
                if (i == 0 || i == 1) {
                    this.subsequentMsg = BigInteger.valueOf(i);
                    break;
                }
                throw new ASN1FormatException("Unkown subsequentMessage value: " + i);
            }
            case 2: {
                pis.unread((ch & 0) + 3);
                this.dhMAC = ASN1BitString.inputValue((InputStream)pis);
                break;
            }
            default: {
                throw new ASN1FormatException("Unexpected tag in choice: " + tag);
            }
        }
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            if (this.thisMessage != null) {
                this.contents = ASN1Utils.addImplicitTag((ASN1Object)new ASN1BitString(Utils.toBytes((Streamable)this.thisMessage)), (int)0);
            } else if (this.subsequentMsg != null) {
                this.contents = ASN1Utils.addImplicitTag((ASN1Object)new ASN1Integer(this.subsequentMsg), (int)1);
            } else if (this.dhMAC != null) {
                this.contents = ASN1Utils.addImplicitTag((ASN1Object)new ASN1BitString(this.dhMAC), (int)2);
            } else {
                throw new IllegalStateException("POPOPrivKey has no contents");
            }
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

