/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cmp.CAKeyUpdateAnn;
import oracle.security.crypto.cmp.CRLAnnouncement;
import oracle.security.crypto.cmp.CertAnnouncement;
import oracle.security.crypto.cmp.CertConfirm;
import oracle.security.crypto.cmp.CertificationRequest;
import oracle.security.crypto.cmp.CertificationResponse;
import oracle.security.crypto.cmp.Confirmation;
import oracle.security.crypto.cmp.CrossCertRequest;
import oracle.security.crypto.cmp.CrossCertResponse;
import oracle.security.crypto.cmp.ErrorMessage;
import oracle.security.crypto.cmp.GeneralMessage;
import oracle.security.crypto.cmp.GeneralResponse;
import oracle.security.crypto.cmp.InitializationRequest;
import oracle.security.crypto.cmp.InitializationResponse;
import oracle.security.crypto.cmp.KeyRecoveryRequest;
import oracle.security.crypto.cmp.KeyRecoveryResponse;
import oracle.security.crypto.cmp.KeyUpdateRequest;
import oracle.security.crypto.cmp.KeyUpdateResponse;
import oracle.security.crypto.cmp.NestedMessage;
import oracle.security.crypto.cmp.PKCS10CertReq;
import oracle.security.crypto.cmp.POPChallenge;
import oracle.security.crypto.cmp.POPResponse;
import oracle.security.crypto.cmp.RevAnnouncement;
import oracle.security.crypto.cmp.RevocationRequest;
import oracle.security.crypto.cmp.RevocationResponse;

public abstract class PKIMessageBody
implements ASN1Object {
    private transient ASN1Object contents;

    public abstract Type getType();

    public static PKIMessageBody inputInstance(InputStream is) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is);
        int tag = pis.read();
        pis.unread(tag);
        ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)pis, tag &= 0x1F);
        switch (tag) {
            case 0: {
                return new InitializationRequest((InputStream)cis);
            }
            case 1: {
                return new InitializationResponse((InputStream)cis);
            }
            case 2: {
                return new CertificationRequest((InputStream)cis);
            }
            case 3: {
                return new CertificationResponse((InputStream)cis);
            }
            case 4: {
                return new PKCS10CertReq((InputStream)cis);
            }
            case 5: {
                return new POPChallenge((InputStream)cis);
            }
            case 6: {
                return new POPResponse((InputStream)cis);
            }
            case 7: {
                return new KeyUpdateRequest((InputStream)cis);
            }
            case 8: {
                return new KeyUpdateResponse((InputStream)cis);
            }
            case 9: {
                return new KeyRecoveryRequest((InputStream)cis);
            }
            case 10: {
                return new KeyRecoveryResponse((InputStream)cis);
            }
            case 11: {
                return new RevocationRequest((InputStream)cis);
            }
            case 12: {
                return new RevocationResponse((InputStream)cis);
            }
            case 13: {
                return new CrossCertRequest((InputStream)cis);
            }
            case 14: {
                return new CrossCertResponse((InputStream)cis);
            }
            case 15: {
                return new CAKeyUpdateAnn((InputStream)cis);
            }
            case 16: {
                return new CertAnnouncement((InputStream)cis);
            }
            case 17: {
                return new RevAnnouncement((InputStream)cis);
            }
            case 18: {
                return new CRLAnnouncement((InputStream)cis);
            }
            case 19: {
                return new Confirmation((InputStream)cis);
            }
            case 20: {
                return new NestedMessage((InputStream)cis);
            }
            case 21: {
                return new GeneralMessage((InputStream)cis);
            }
            case 22: {
                return new GeneralResponse((InputStream)cis);
            }
            case 23: {
                return new ErrorMessage((InputStream)cis);
            }
            case 24: {
                return new CertConfirm((InputStream)cis);
            }
        }
        throw new ASN1FormatException("Unrecognized message body tag " + tag);
    }

    abstract ASN1Object toASN1Object();

    abstract void clearCache();

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    void update() {
        this.contents = null;
        this.clearCache();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            this.contents = new ASN1GenericConstructed(this.toASN1Object(), this.getType().getValue());
        }
        return this.contents;
    }

    public static class Type {
        public static final Type INITIALIZATION_REQUEST = new Type(0);
        public static final Type INITIALIZATION_RESPONSE = new Type(1);
        public static final Type CERTIFICATION_REQUEST = new Type(2);
        public static final Type CERTIFICATION_RESPONSE = new Type(3);
        public static final Type PKCS10_CERT_REQUEST = new Type(4);
        public static final Type POP_CHALLENGE = new Type(5);
        public static final Type POP_RESPONSE = new Type(6);
        public static final Type KEY_UPDATE_REQUEST = new Type(7);
        public static final Type KEY_UPDATE_RESPONSE = new Type(8);
        public static final Type KEY_RECOVERY_REQUEST = new Type(9);
        public static final Type KEY_RECOVERY_RESPONSE = new Type(10);
        public static final Type REVOCATION_REQUEST = new Type(11);
        public static final Type REVOCATION_RESPONSE = new Type(12);
        public static final Type CROSS_CERT_REQUEST = new Type(13);
        public static final Type CROSS_CERT_RESPONSE = new Type(14);
        public static final Type CA_KEY_UPDATE_ANNOUNCEMENT = new Type(15);
        public static final Type CERTIFICATE_ANNOUNCEMENT = new Type(16);
        public static final Type REVOCATION_ANNOUNCEMENT = new Type(17);
        public static final Type CRL_ANNOUNCEMENT = new Type(18);
        public static final Type CONFIRMATION = new Type(19);
        public static final Type NESTED_MESSAGE = new Type(20);
        public static final Type GENERAL_MESSAGE = new Type(21);
        public static final Type GENERAL_RESPONSE = new Type(22);
        public static final Type ERROR_MESSAGE = new Type(23);
        public static final Type CERTIFICATE_CONFIRM = new Type(24);
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "ir";
                }
                case 1: {
                    return "ip";
                }
                case 2: {
                    return "cr";
                }
                case 3: {
                    return "cp";
                }
                case 4: {
                    return "p10cr";
                }
                case 5: {
                    return "popdecc";
                }
                case 6: {
                    return "popdecr";
                }
                case 7: {
                    return "kur";
                }
                case 8: {
                    return "kup";
                }
                case 9: {
                    return "krr";
                }
                case 10: {
                    return "krp";
                }
                case 11: {
                    return "rr";
                }
                case 12: {
                    return "rp";
                }
                case 13: {
                    return "ccr";
                }
                case 14: {
                    return "ccp";
                }
                case 15: {
                    return "ckuann";
                }
                case 16: {
                    return "cann";
                }
                case 17: {
                    return "rann";
                }
                case 18: {
                    return "crlann";
                }
                case 19: {
                    return "pkiconf";
                }
                case 20: {
                    return "nested";
                }
                case 21: {
                    return "genm";
                }
                case 22: {
                    return "genp";
                }
                case 23: {
                    return "error";
                }
                case 24: {
                    return "certConf";
                }
            }
            return "tag" + this.value;
        }
    }
}

