/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.CertResponse;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public abstract class PKICertRepMessage
extends PKIMessageBody {
    private Vector caPubs;
    private Vector X509caPubs;
    private Vector response = new Vector();
    private transient ASN1Object contents;

    protected PKICertRepMessage() {
    }

    protected PKICertRepMessage(CertResponse cr) {
        this.response.addElement(cr);
    }

    protected PKICertRepMessage(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCertificate(X509Certificate c) throws CertificateEncodingException {
        if (this.caPubs == null) {
            this.caPubs = new Vector();
            this.X509caPubs = new Vector();
        }
        this.caPubs.addElement(c);
        this.X509caPubs.addElement(CMPUtils.convertX509(c));
        this.update();
    }

    public void addCertResponse(CertResponse cr) {
        this.response.addElement(cr);
        this.update();
    }

    public Vector getCertificates() {
        return this.caPubs;
    }

    public Vector getCertResponses() {
        return this.response;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getType() + " { ");
        if (this.caPubs != null) {
            s.append("caPubs = " + Utils.toString((Vector)this.caPubs) + ", ");
        }
        s.append("response = " + Utils.toString((Vector)this.response));
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        if (sis.getCurrentTag() == 1) {
            ASN1SequenceInputStream cis = new ASN1SequenceInputStream((InputStream)sis);
            if (this.caPubs == null) {
                this.caPubs = new Vector();
                this.X509caPubs = new Vector();
            } else {
                this.caPubs.removeAllElements();
                this.X509caPubs.removeAllElements();
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (cis.hasMoreData()) {
                    this.caPubs.addElement(cf.generateCertificate(new ByteArrayInputStream(new X509((InputStream)cis).getEncoded())));
                }
            }
            catch (CertificateException ex) {
                throw new IOException(ex.toString());
            }
            cis.terminate();
        } else {
            this.caPubs = null;
            this.X509caPubs = null;
        }
        ASN1SequenceInputStream ris = new ASN1SequenceInputStream((InputStream)sis);
        while (ris.hasMoreData()) {
            this.response.addElement(new CertResponse((InputStream)ris));
        }
        ris.terminate();
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            int i;
            int n;
            ASN1Sequence s = new ASN1Sequence();
            if (this.caPubs != null && this.caPubs.size() > 0) {
                ASN1Sequence c = new ASN1Sequence();
                n = this.caPubs.size();
                for (i = 0; i < n; ++i) {
                    c.addElement((ASN1Object)((X509)this.X509caPubs.elementAt(i)));
                }
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)c, 1));
            }
            ASN1Sequence r = new ASN1Sequence();
            n = this.response.size();
            for (i = 0; i < n; ++i) {
                r.addElement((ASN1Object)((CertResponse)this.response.elementAt(i)));
            }
            s.addElement((ASN1Object)r);
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

