/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cmp.PKIMessageBody;

public class Confirmation
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.CONFIRMATION;
    private transient ASN1Object contents;

    public Confirmation() {
    }

    public Confirmation(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return "{ type = " + TYPE + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Null(is);
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Null();
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

