/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CertConfirm
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.CERTIFICATE_CONFIRM;
    private static final PKIStatusInfo DEFAULT_GRANTED = new PKIStatusInfo(PKIStatusInfo.Status.GRANTED);
    private Hashtable hashTab = new Hashtable();
    private Hashtable reqIDTab = new Hashtable();
    private Vector statusList = new Vector();
    private transient ASN1Object contents;

    public CertConfirm() {
    }

    public CertConfirm(X509Certificate cert, BigInteger certReqID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this(cert, certReqID, null);
    }

    public CertConfirm(X509Certificate cert, BigInteger certReqID, PKIStatusInfo status) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.addCertificate(cert, certReqID, status);
    }

    public CertConfirm(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCertificate(X509Certificate cert, BigInteger certReqID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.addCertificate(cert, certReqID, null);
    }

    public void addCertificate(X509Certificate cert, BigInteger certReqID, PKIStatusInfo status) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] hash = this.computeHash(cert);
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1OctetString(hash));
        s.addElement((ASN1Object)new ASN1Integer(certReqID));
        if (status != null) {
            s.addElement((ASN1Object)status);
        }
        if (this.hashTab.put(new KeyHash(hash), s) != null) {
            throw new IllegalArgumentException("Duplicate certificate status");
        }
        if (this.reqIDTab.put(certReqID, s) != null) {
            throw new IllegalArgumentException("Duplicate certificate status");
        }
        this.statusList.addElement(s);
        this.update();
    }

    private byte[] computeHash(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        ASN1ObjectID oid = new ASN1ObjectID(cert.getSigAlgOID());
        MessageDigest md = null;
        if (oid.equals((Object)AlgID.md5WithRSAEncryption.getOID())) {
            md = MessageDigest.getInstance("MD5");
        } else if (oid.equals((Object)AlgID.md2WithRSAEncryption.getOID())) {
            md = MessageDigest.getInstance("MD2");
        } else if (oid.equals((Object)AlgID.sha_1WithRSAEncryption.getOID()) || oid.equals((Object)AlgID.dsaWithSHA.getOID()) || oid.equals((Object)AlgID.dsaWithSHA1.getOID()) || oid.equals((Object)AlgID.dsaWithSHA1Old.getOID())) {
            md = MessageDigest.getInstance("SHA-1");
        } else {
            throw new NoSuchAlgorithmException("Unknown cert signature hash algorithm: " + oid);
        }
        return md.digest(cert.getEncoded());
    }

    public Enumeration certHashes() {
        Vector<byte[]> v = new Vector<byte[]>();
        Enumeration e = this.hashTab.keys();
        while (e.hasMoreElements()) {
            v.addElement(((KeyHash)e.nextElement()).getValue());
        }
        return v.elements();
    }

    public Enumeration certReqIDs() {
        return this.reqIDTab.keys();
    }

    public PKIStatusInfo getStatusInfo(byte[] hash) {
        ASN1Sequence s = (ASN1Sequence)this.hashTab.get(new KeyHash(hash));
        if (s == null) {
            return null;
        }
        if (s.size() >= 3 && s.elementAt(2) != null) {
            return (PKIStatusInfo)s.elementAt(2);
        }
        return DEFAULT_GRANTED;
    }

    public PKIStatusInfo getStatusInfo(BigInteger certReqID) {
        ASN1Sequence s = (ASN1Sequence)this.reqIDTab.get(certReqID);
        if (s == null) {
            return null;
        }
        if (s.size() >= 3 && s.elementAt(2) != null) {
            return (PKIStatusInfo)s.elementAt(2);
        }
        return DEFAULT_GRANTED;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { statusList = " + Utils.toString((Vector)this.statusList) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.hashTab.clear();
        this.reqIDTab.clear();
        this.statusList.removeAllElements();
        while (sis.hasMoreData()) {
            ASN1SequenceInputStream cis = new ASN1SequenceInputStream((InputStream)sis);
            byte[] hash = ASN1OctetString.inputValue((InputStream)cis);
            BigInteger certReqID = ASN1Integer.inputValue((InputStream)cis);
            PKIStatusInfo status = cis.hasMoreData() ? new PKIStatusInfo((InputStream)cis) : null;
            cis.terminate();
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1OctetString(hash));
            s.addElement((ASN1Object)new ASN1Integer(certReqID));
            if (status != null) {
                s.addElement((ASN1Object)status);
            }
            if (this.hashTab.put(new KeyHash(hash), s) != null) {
                throw new ASN1FormatException("Duplicate certificate status on input");
            }
            if (this.reqIDTab.put(certReqID, s) != null) {
                throw new ASN1FormatException("Duplicate certificate status on input");
            }
            this.statusList.addElement(s);
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.statusList);
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    private class KeyHash {
        byte[] value;

        KeyHash(byte[] value) {
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return Utils.areEqual((byte[])this.value, (byte[])((KeyHash)o).value);
        }

        public int hashCode() {
            return new BigInteger(this.value).hashCode();
        }
    }
}

