/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CRLAnnouncement
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.CRL_ANNOUNCEMENT;
    private Vector crls = new Vector();
    private transient ASN1Object contents;

    public CRLAnnouncement() {
    }

    public CRLAnnouncement(CRL crl) {
        this.crls.addElement(crl);
    }

    public CRLAnnouncement(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCRL(CRL crl) {
        this.crls.addElement(crl);
        this.update();
    }

    public Vector getCRLs() {
        return this.crls;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { crls = " + Utils.toString((Vector)this.crls) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.crls.removeAllElements();
        while (sis.hasMoreData()) {
            this.crls.addElement(new CRL((InputStream)sis));
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.crls);
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

