/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CAKeyUpdateAnn
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.CA_KEY_UPDATE_ANNOUNCEMENT;
    private X509Certificate oldWithNew;
    private X509Certificate newWithOld;
    private X509Certificate newWithNew;
    private X509 X509OldWithNew;
    private X509 X509NewWithOld;
    private X509 X509NewWithNew;
    private transient ASN1Object contents;

    public CAKeyUpdateAnn() {
    }

    public CAKeyUpdateAnn(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) throws CertificateEncodingException {
        this.oldWithNew = oldWithNew;
        this.newWithOld = newWithOld;
        this.newWithNew = newWithNew;
        this.X509OldWithNew = CMPUtils.convertX509(oldWithNew);
        this.X509NewWithOld = CMPUtils.convertX509(newWithOld);
        this.X509NewWithNew = CMPUtils.convertX509(newWithNew);
    }

    public CAKeyUpdateAnn(InputStream is) throws IOException {
        this.input(is);
    }

    public X509Certificate getOldWithNew() {
        return this.oldWithNew;
    }

    public X509Certificate getNewWithOld() {
        return this.newWithOld;
    }

    public X509Certificate getNewWithNew() {
        return this.newWithNew;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(TYPE);
        s.append(" { oldWithNew = ");
        s.append(this.oldWithNew.toString());
        s.append(", newWithOld = ");
        s.append(this.newWithOld.toString());
        s.append(", newWithNew = ");
        s.append(this.newWithNew.toString());
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        try {
            this.X509OldWithNew = new X509((InputStream)sis);
            this.X509NewWithOld = new X509((InputStream)sis);
            this.X509NewWithNew = new X509((InputStream)sis);
            this.oldWithNew = CMPUtils.toJCECertificate(this.X509OldWithNew);
            this.newWithOld = CMPUtils.toJCECertificate(this.X509NewWithOld);
            this.newWithNew = CMPUtils.toJCECertificate(this.X509NewWithNew);
        }
        catch (CertificateException ex) {
            throw new IOException(ex.toString());
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.X509OldWithNew);
            s.addElement((ASN1Object)this.X509NewWithOld);
            s.addElement((ASN1Object)this.X509NewWithNew);
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

