/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import oracle.dbtools.raptor.schemabrowser.model.SBListModel;
import oracle.ide.model.Displayable;

public class SBComboBoxModel<T extends Displayable>
extends AbstractListModel
implements SBListModel<T>,
MutableComboBoxModel,
Iterable<T> {
    private List<T> m_objects = new ArrayList<T>();
    private T m_currItem;
    private boolean m_allowsNullSelection;

    public SBComboBoxModel() {
    }

    public SBComboBoxModel(boolean bl) {
        this.m_allowsNullSelection = bl;
    }

    @Override
    public Object getSelectedItem() {
        return this.m_currItem;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.isValidSelection(object) || this.m_objects.size() == 0) {
            this.setSelectedItemImpl((Displayable)object);
        }
    }

    private boolean isValidSelection(Object object) {
        boolean bl = false;
        if (object == null) {
            bl = this.m_allowsNullSelection;
        } else if (object != null) {
            bl = true;
        }
        return bl;
    }

    private void setSelectedItemImpl(T t) {
        this.m_currItem = t;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int n) {
        return this.m_objects.get(n);
    }

    @Override
    public int getSize() {
        return this.m_objects.size();
    }

    public void addElement(Object object) {
        int n = this.m_objects.size();
        this.m_objects.add((Displayable)object);
        this.fireIntervalAdded(this, n, n);
        if (this.m_currItem == null) {
            this.setSelectedItemImpl((Displayable)object);
        }
    }

    public void insertElementAt(Object object, int n) {
        this.m_objects.add(n, (Displayable)object);
        this.fireIntervalAdded(this, n, n);
        if (this.m_currItem == null) {
            this.setSelectedItemImpl((Displayable)object);
        }
    }

    @Override
    public void removeElement(Object object) {
        int n = this.m_objects.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
        }
    }

    @Override
    public void removeElementAt(int n) {
        Displayable displayable = (Displayable)this.m_objects.remove(n);
        if (displayable == this.m_currItem) {
            if (n == 0) {
                this.setSelectedItemImpl(this.m_objects.size() == 0 ? null : (Displayable)this.m_objects.get(0));
            } else {
                this.setSelectedItemImpl((Displayable)this.m_objects.get(n - 1));
            }
        }
        this.fireIntervalRemoved(this, n, n);
    }

    @Override
    public void addElements(Collection<T> collection) {
        if (collection.size() > 0) {
            int n = this.m_objects.size();
            int n2 = n + collection.size() - 1;
            this.m_objects.addAll(collection);
            this.fireIntervalAdded(this, n, n2);
        }
    }

    @Override
    public void clear() {
        int n = this.m_objects.size() - 1;
        this.m_objects.clear();
        if (n >= 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_objects.iterator();
    }
}

