/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.SecureRandom;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.RandomBitsSource;

public final class SRRandomBitsSource
extends RandomBitsSource {
    public static int DEFAULT_SEED_SIZE = 20;
    private SecureRandom random;

    public SRRandomBitsSource(SecureRandom random) {
        this.random = random;
    }

    public synchronized void seed(byte[] seed) {
        if (this.random != null) {
            this.random.setSeed(seed);
        }
    }

    public synchronized void seed(EntropySource es) {
        this.random.setSeed(es.generateBytes(new byte[DEFAULT_SEED_SIZE]));
    }

    public int next(int bits) {
        int numBytes = (bits + 7) / 8;
        byte[] b = new byte[numBytes];
        int next = 0;
        this.random.nextBytes(b);
        for (int i = 0; i < numBytes; ++i) {
            next = (next << 8) + (b[i] & 0xFF);
        }
        return next >>> numBytes * 8 - bits;
    }

    public synchronized byte randomByte() {
        return (byte)this.next(8);
    }

    public synchronized byte[] randomBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
        return bytes;
    }

    public void clear() {
    }
}

