/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.jce.cert.CRLImpl;
import oracle.security.crypto.jce.cert.X509Impl;
import oracle.security.crypto.jce.certpath.X509CertPathImpl;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class PhaosX509CertificateFactorySpi
extends CertificateFactorySpi {
    private static final ASN1ObjectID signedDataOID = new ASN1ObjectID(ASN1Utils.pkcsID, 7, 2);

    @Override
    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        try {
            return new X509Impl(PhaosX509CertificateFactorySpi.checkAndDecodeStream(inStream));
        }
        catch (IOException ex) {
            throw new CertificateException(ex.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        try {
            Vector<X509Impl> collection = null;
            InputStream in = PhaosX509CertificateFactorySpi.checkAndDecodeStream(inStream);
            ASN1Header header = new ASN1Header(in);
            int tagOctet = Utils.inputByte((InputStream)in) & 0xFF;
            int tag = tagOctet & 0x1F;
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream(header.length() + 1);
            header.output((OutputStream)bos);
            bos.write(tagOctet);
            SequenceInputStream is = new SequenceInputStream(new ByteArrayInputStream(bos.toByteArray()), in);
            if (tag == 16) {
                collection = new Vector<X509Impl>();
                collection.addElement(new X509Impl(is));
                return collection;
            }
            ASN1SequenceInputStream ci = new ASN1SequenceInputStream((InputStream)is);
            ASN1ObjectID thisContentType = new ASN1ObjectID((InputStream)ci);
            if (!thisContentType.equals((Object)signedDataOID)) {
                throw new CertificateException("Invalid content type:" + thisContentType + ". Only SignedData content type supported");
            }
            if (ci.hasMoreData()) {
                ASN1ConstructedInputStream cic = new ASN1ConstructedInputStream((InputStream)ci, 0);
                ASN1SequenceInputStream sd = new ASN1SequenceInputStream((InputStream)cic);
                ASN1Integer version = new ASN1Integer((InputStream)sd);
                if (!version.equals(1) && !version.equals(3)) {
                    throw new IOException("Expected Version 1 or 3 But Got " + version.getValue());
                }
                ASN1SetInputStream da = new ASN1SetInputStream((InputStream)sd);
                da.terminate(true);
                ASN1Sequence encap_info = new ASN1Sequence((InputStream)sd);
                if (sd.getCurrentTag() == 0) {
                    sd.setCurrentTag(17);
                    collection = new Vector();
                    ASN1SetInputStream certs = new ASN1SetInputStream((InputStream)sd);
                    while (certs.hasMoreData()) {
                        collection.addElement(new X509Impl((InputStream)certs));
                    }
                    certs.terminate();
                }
                sd.terminate(true);
                cic.terminate(true);
            }
            ci.terminate(true);
            return collection;
        }
        catch (IOException ex) {
            throw new CertificateException(ex.toString());
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        try {
            return new CRLImpl(inStream);
        }
        catch (IOException ex) {
            throw new CRLException(ex.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        try {
            Vector<X509Extension> collection = null;
            ASN1Header header = new ASN1Header(inStream);
            int tagOctet = Utils.inputByte((InputStream)inStream) & 0xFF;
            int tag = tagOctet & 0x1F;
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream(header.length() + 1);
            header.output((OutputStream)bos);
            bos.write(tagOctet);
            SequenceInputStream is = new SequenceInputStream(new ByteArrayInputStream(bos.toByteArray()), inStream);
            if (tag == 16) {
                collection = new Vector<X509Extension>();
                collection.addElement(new X509Impl(is));
                return collection;
            }
            ASN1SequenceInputStream ci = new ASN1SequenceInputStream((InputStream)is);
            ASN1ObjectID thisContentType = new ASN1ObjectID((InputStream)ci);
            if (!thisContentType.equals((Object)signedDataOID)) {
                throw new CRLException("Invalid content type:" + thisContentType + ". Only SignedData content type supported");
            }
            if (ci.hasMoreData()) {
                ASN1ConstructedInputStream cic = new ASN1ConstructedInputStream((InputStream)ci, 0);
                ASN1SequenceInputStream sd = new ASN1SequenceInputStream((InputStream)cic);
                ASN1Integer version = new ASN1Integer((InputStream)sd);
                if (!version.equals(1) && !version.equals(3)) {
                    throw new IOException("Expected Version 1 or 3 But Got " + version.getValue());
                }
                ASN1SetInputStream da = new ASN1SetInputStream((InputStream)sd);
                da.terminate(true);
                ASN1Sequence encap_info = new ASN1Sequence((InputStream)sd);
                if (sd.getCurrentTag() == 0) {
                    sd.setCurrentTag(17);
                    ASN1SetInputStream certs = new ASN1SetInputStream((InputStream)sd);
                    certs.terminate(true);
                }
                if (sd.getCurrentTag() == 1) {
                    sd.setCurrentTag(17);
                    collection = new Vector();
                    ASN1SetInputStream crls = new ASN1SetInputStream((InputStream)sd);
                    while (crls.hasMoreData()) {
                        collection.addElement(new CRLImpl((InputStream)crls));
                    }
                    crls.terminate();
                }
                sd.terminate(true);
                cic.terminate(true);
            }
            ci.terminate(true);
            return collection;
        }
        catch (IOException ex) {
            throw new CRLException(ex.toString());
        }
    }

    private static InputStream checkAndDecodeStream(InputStream inStream) throws IOException {
        int tagOctet = Utils.inputByte((InputStream)inStream) & 0xFF;
        int tagClass = tagOctet & 0xC0;
        boolean method = (tagOctet & 0x20) != 0;
        int tag = tagOctet & 0x1F;
        byte[] array = new byte[]{(byte)tagOctet};
        InputStream is = new SequenceInputStream(new ByteArrayInputStream(array), inStream);
        if (tag != 16 || tagClass != 0) {
            String line;
            BufferedReader pemIS = new BufferedReader(new InputStreamReader(is));
            StringBuffer pemBuf = new StringBuffer();
            boolean started = false;
            while ((line = pemIS.readLine()) != null) {
                if (started) {
                    int end;
                    if (line.length() == 0) continue;
                    if (line.startsWith("-----")) break;
                    for (end = line.length() - 1; end >= 0 && Character.isWhitespace(line.charAt(end)); --end) {
                    }
                    pemBuf.append(line.substring(0, end + 1));
                    continue;
                }
                if (!line.startsWith("-----") || !line.endsWith("-----") || !line.substring(5, 10).equals("BEGIN")) continue;
                started = true;
            }
            byte[] decoded = Utils.fromBase64((String)pemBuf.toString());
            is = new ByteArrayInputStream(decoded);
        }
        return is;
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputstream) throws CertificateException {
        return new X509CertPathImpl(inputstream);
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputstream, String s) throws CertificateException {
        return new X509CertPathImpl(inputstream, s);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        return new X509CertPathImpl(list);
    }

    public Iterator engineGetCertPathEncodings() {
        return X509CertPathImpl.getEncodingsStatic();
    }
}

