/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.PhaosAlgorithmParametersSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosStreamCipherSpi
extends CipherSpi {
    protected Cipher cipher;
    protected AlgorithmIdentifier algID;
    protected int mode = 0;
    private Padding.ID padding = Padding.NONE;
    private int opMode;
    protected RandomBitsSource random;
    private byte[] buffer;
    private int bufferPos;
    private boolean initialized = false;
    private static final int ENGINE_INIT_KEY_ALG_RND = 1;
    private static final int ENGINE_INIT_KEY_ALGSPEC_RND = 2;
    private static final int ENGINE_INIT_KEY_RND = 3;
    private int engineInitMethod;
    private int engineInitMode;
    private java.security.Key engineInitKey;
    private AlgorithmParameters engineInitParams;
    private SecureRandom engineInitRandom;
    private AlgorithmParameterSpec engineInitParamSpec;

    PhaosStreamCipherSpi(AlgorithmIdentifier algID) {
        this.algID = algID;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException(mode + " not supported");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding not supported: " + padding);
        }
    }

    @Override
    protected void engineInit(int opMode, java.security.Key key, SecureRandom random) throws java.security.InvalidKeyException {
        this.random = random != null ? new SRRandomBitsSource(random) : RandomBitsSource.getDefault();
        this.initialize(opMode, key);
        this.engineInitMethod = 3;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    @Override
    protected void engineInit(int opMode, java.security.Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws java.security.InvalidKeyException, InvalidAlgorithmParameterException {
        this.random = random != null ? new SRRandomBitsSource(random) : null;
        this.initialize(opMode, key);
        this.engineInitMethod = 2;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = paramSpec;
    }

    @Override
    protected void engineInit(int opMode, java.security.Key key, AlgorithmParameters params, SecureRandom random) throws java.security.InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opMode, key, (AlgorithmParameterSpec)((Object)params), random);
        this.engineInitMethod = 1;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = params;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    private void initialize(int opMode, java.security.Key key) throws java.security.InvalidKeyException {
        if (opMode != 2 && opMode != 1 && opMode != 4 && opMode != 3) {
            throw new IllegalStateException("Mode not supported: " + opMode);
        }
        if (key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((AlgorithmIdentifier)this.algID, (Key)PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
                }
                this.cipher.initialize(this.algID, (Key)PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            }
            catch (InvalidKeyException ike) {
                throw new java.security.InvalidKeyException(ike.getMessage());
            }
            catch (AlgorithmIdentifierException aie) {
                throw new java.security.InvalidKeyException(aie.getMessage());
            }
            catch (CipherException ce) {
                throw new java.security.InvalidKeyException(ce.getMessage());
            }
        } else {
            throw new java.security.InvalidKeyException("can't initialize with key format '" + key.getFormat() + "' (supports RAW only)");
        }
        this.opMode = opMode;
        this.initialized = true;
    }

    private void reinitialize() {
        block6: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParams, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParamSpec, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 3) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitRandom);
                    break block6;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IllegalStateException(ex.toString());
            }
            catch (java.security.InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 1;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int offset, int len) {
        byte[] b = null;
        try {
            b = this.doUpdate(input, offset, len);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e.toString());
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e.toString());
        }
        return b;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int len = -1;
        try {
            len = this.doUpdate(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e.toString());
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e.toString());
        }
        return len;
    }

    private byte[] doUpdate(byte[] input, int offset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        byte[] b = null;
        try {
            b = this.cipher.encrypt(input, offset, inputLen);
        }
        catch (CipherException e) {
            throw new RuntimeException(e.toString());
        }
        return b;
    }

    private int doUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length - outputOffset < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("The output buffer is too small");
        }
        byte[] res = this.doUpdate(input, inputOffset, inputLen);
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int offset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] b = this.doUpdate(input, offset, inputLen);
        this.reinitialize();
        return b;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length - outputOffset < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("The output buffer is too small");
        }
        byte[] res = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    @Override
    protected byte[] engineWrap(java.security.Key key) throws IllegalBlockSizeException, java.security.InvalidKeyException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 4) {
            throw new IllegalStateException("Illegal use: cipher initialized for wrapping only");
        }
        if (!(key instanceof java.security.PrivateKey) && !(key instanceof SecretKey)) {
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        try {
            if (key instanceof java.security.PrivateKey) {
                return this.cipher.wrapKey(PhaosJCEKeyTranslator.jcePrivateKeyToPhaos((java.security.PrivateKey)key));
            }
            if (key instanceof SecretKey) {
                return this.cipher.wrapKey(PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            }
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
    }

    @Override
    protected java.security.Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws java.security.InvalidKeyException, NoSuchAlgorithmException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 3) {
            throw new IllegalStateException("Illegal use: cipher initialized for unwrapping only");
        }
        try {
            if (wrappedKeyType == 2) {
                PrivateKey privKey = this.cipher.unwrapPrivateKey(wrappedKey);
                return PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(privKey);
            }
            if (wrappedKeyType == 3) {
                SymmetricKey symKey = this.cipher.unwrapSymmetricKey(wrappedKey, new AlgorithmIdentifier(PhaosAlgorithmParametersSpi.stringToOid(wrappedKeyAlgorithm)));
                return new SecretKeyImpl(symKey, wrappedKeyAlgorithm);
            }
            throw new java.security.InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
    }

    @Override
    protected int engineGetKeySize(java.security.Key key) throws java.security.InvalidKeyException {
        if (key == null || !"RAW".equals(key.getFormat())) {
            throw new java.security.InvalidKeyException("Key is not in a valid format");
        }
        return PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key).keySize() * 8;
    }
}

