/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;

public class PhaosSecretKeyFactorySpi
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        byte[] keyBytes;
        String algName;
        if (spec instanceof DESedeKeySpec) {
            algName = "DESede";
            keyBytes = ((DESedeKeySpec)spec).getKey();
        } else if (spec instanceof DESKeySpec) {
            algName = "DES";
            keyBytes = ((DESKeySpec)spec).getKey();
        } else if (spec instanceof SecretKeySpec) {
            algName = ((SecretKeySpec)spec).getAlgorithm();
            keyBytes = ((SecretKeySpec)spec).getEncoded();
        } else {
            throw new InvalidKeySpecException("Unsupported KeySpec received: " + spec.getClass().getName());
        }
        return new SecretKeyImpl(new SymmetricKey(keyBytes), algName);
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        byte[] keyBytes = key.getEncoded();
        try {
            if (keySpec.isAssignableFrom(DESedeKeySpec.class)) {
                return new DESedeKeySpec(keyBytes);
            }
            if (keySpec.isAssignableFrom(DESKeySpec.class)) {
                return new DESKeySpec(keyBytes);
            }
            if (keySpec.isAssignableFrom(SecretKeySpec.class)) {
                return new SecretKeySpec(keyBytes, key.getAlgorithm());
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + keySpec.getName());
        }
        catch (InvalidKeyException ex) {
            throw new InvalidKeySpecException(ex.toString());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key instanceof SecretKeyImpl) {
            return key;
        }
        return new SecretKeyImpl(new SymmetricKey(key.getEncoded()), key.getAlgorithm());
    }
}

