/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.PBEParameterSpec;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PbeSecretKeyImpl;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosPBESpi
extends CipherSpi {
    private PBE pbe;
    private AlgorithmIdentifier cipherAlgID;
    private PbeSecretKeyImpl key;
    private int opMode;
    private RandomBitsSource random;
    private boolean initialized = false;
    protected String mode;
    protected String padding;
    private static final int ENGINE_INIT_KEY_ALG_RND = 1;
    private static final int ENGINE_INIT_KEY_ALGSPEC_RND = 2;
    private static final int ENGINE_INIT_KEY_RND = 3;
    private int engineInitMethod;
    private int engineInitMode;
    private Key engineInitKey;
    private AlgorithmParameters engineInitParams;
    private SecureRandom engineInitRandom;
    private AlgorithmParameterSpec engineInitParamSpec;

    PhaosPBESpi(AlgorithmIdentifier cipherAlgID) {
        this.cipherAlgID = cipherAlgID;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("CBC only supported");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("PKCS5Padding") && !padding.equalsIgnoreCase("PKCS5")) {
            throw new NoSuchPaddingException("PKCS5Padding only supported");
        }
    }

    @Override
    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        this.random = random != null ? new SRRandomBitsSource(random) : RandomBitsSource.getDefault();
        this.initialize(opMode, key);
        this.engineInitMethod = 3;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    @Override
    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        RandomBitsSource randomBitsSource = this.random = random != null ? new SRRandomBitsSource(random) : RandomBitsSource.getDefault();
        if (paramSpec instanceof PBEParameterSpec) {
            if (!(key instanceof PbeSecretKeyImpl)) {
                throw new InvalidKeyException("PBEParameterSpec must be used with a PBE key created with Phaos PBE Secret Key factory");
            }
            byte[] salt = ((PBEParameterSpec)paramSpec).getSalt();
            int iterationCount = ((PBEParameterSpec)paramSpec).getIterationCount();
            ((PbeSecretKeyImpl)key).setParameters(salt, iterationCount);
        }
        this.initialize(opMode, key);
        this.engineInitMethod = 2;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = paramSpec;
    }

    @Override
    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        String alg = params.getAlgorithm();
        PBEParameterSpec paramsSpec = null;
        try {
            if (key instanceof PbeSecretKeyImpl) {
                paramsSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            this.engineInit(opMode, key, paramsSpec, random);
        }
        catch (InvalidParameterSpecException ex) {
            throw new InvalidAlgorithmParameterException("The given algorithm parameters are inappropriate");
        }
        this.engineInitMethod = 1;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = params;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    private void initialize(int opMode, Key key) throws InvalidKeyException {
        if (opMode != 2 && opMode != 1 && opMode != 4 && opMode != 3) {
            throw new IllegalStateException("Mode not supported: " + opMode);
        }
        if (key instanceof PbeSecretKeyImpl) {
            try {
                if (this.pbe == null) {
                    this.pbe = PBE.getInstance((AlgorithmIdentifier)((PbeSecretKeyImpl)key).getAlgID());
                }
                this.pbe.initialize((AlgorithmIdentifier)((PbeSecretKeyImpl)key).getAlgID());
            }
            catch (AlgorithmIdentifierException aie) {
                throw new InvalidKeyException(aie.getMessage());
            }
        } else {
            throw new InvalidKeyException("Can't initialize without a PbeSecretKeyImpl key. Use the Phaos PBE Secret Key Factory to generate the PBE Key.");
        }
        this.opMode = opMode;
        this.key = (PbeSecretKeyImpl)key;
        this.initialized = true;
    }

    private void reinitialize() {
        block6: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParams, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParamSpec, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 3) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitRandom);
                    break block6;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IllegalStateException(ex.toString());
            }
            catch (InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.initialized && (this.opMode == 1 || this.opMode == 3) || !this.initialized) {
            return inputLen - inputLen % this.engineGetBlockSize() + this.engineGetBlockSize();
        }
        if (this.initialized && (this.opMode == 2 || this.opMode == 4)) {
            return inputLen;
        }
        throw new IllegalStateException("Invalid mode: DECRYPT, ENCRYPT, WRAP and UNWRAP modes only supported");
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int offset, int len) {
        throw new IllegalStateException("Method not supported");
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new IllegalStateException("Method not supported");
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int offset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] res;
        byte[] data;
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (offset == 0) {
            data = input;
        } else {
            data = new byte[inputLen];
            System.arraycopy(input, offset, data, 0, inputLen);
        }
        if (this.opMode == 1) {
            try {
                res = this.pbe.encrypt(this.key.getPassword(), data);
            }
            catch (CipherException e) {
                throw new IllegalBlockSizeException(e.toString());
            }
        } else if (this.opMode == 2) {
            try {
                res = this.pbe.decrypt(this.key.getPassword(), data);
            }
            catch (CipherException e) {
                throw new IllegalBlockSizeException(e.toString());
            }
        } else {
            throw new IllegalStateException("Cipher not initialized for encryption/decryption operations");
        }
        this.reinitialize();
        return res;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] res = this.engineDoFinal(input, inputOffset, inputLen);
        if (output.length - outputOffset < res.length) {
            throw new ShortBufferException("The output buffer is too small");
        }
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 4) {
            throw new IllegalStateException("Illegal use: cipher initialized for wrapping only");
        }
        if (!(key instanceof java.security.PrivateKey) && !(key instanceof SecretKey)) {
            throw new InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        try {
            if (key instanceof java.security.PrivateKey) {
                return this.pbe.encryptPrivateKey(this.key.getPassword(), PhaosJCEKeyTranslator.jcePrivateKeyToPhaos((java.security.PrivateKey)key));
            }
            if (key instanceof SecretKey) {
                return this.pbe.encryptSymmetricKey(this.key.getPassword(), PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            }
            throw new InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 3) {
            throw new IllegalStateException("Illegal use: cipher initialized for unwrapping only");
        }
        try {
            if (wrappedKeyType == 2) {
                PrivateKey privKey = null;
                try {
                    privKey = this.pbe.decryptPrivateKey(this.key.getPassword(), wrappedKey);
                }
                catch (IOException e) {
                    throw new InvalidKeyException(e.toString());
                }
                return PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(privKey);
            }
            if (wrappedKeyType == 3) {
                SymmetricKey symKey = this.pbe.decryptSymmetricKey(this.key.getPassword(), wrappedKey);
                return new SecretKeyImpl(symKey, wrappedKeyAlgorithm);
            }
            throw new InvalidKeyException("The key to be wrapped is not a private key nor a secret key");
        }
        catch (CipherException ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key == null || !"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("Key is not in a valid format");
        }
        if (key instanceof PbeSecretKeyImpl) {
            return ((PbeSecretKeyImpl)key).keysize();
        }
        return PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key).keySize() * 8;
    }
}

