/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.crypto;

import javax.crypto.SecretKey;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public final class SecretKeyImpl
implements SecretKey {
    private SymmetricKey symKey;
    private String algName;
    private String format;
    private boolean keyIsExportable;

    public SecretKeyImpl(SymmetricKey key) {
        this(key, key.getAlgorithm(), "RAW");
    }

    public SecretKeyImpl(SymmetricKey key, String alg) {
        this(key, alg, "RAW");
    }

    public SecretKeyImpl(SymmetricKey key, String alg, String format) {
        this.symKey = key;
        this.algName = alg;
        this.format = format;
    }

    @Override
    public String getAlgorithm() {
        return this.algName;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public byte[] getEncoded() {
        return this.symKey.getBytes();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SecretKey)) {
            return false;
        }
        SecretKey k = (SecretKey)o;
        if (!k.getAlgorithm().equalsIgnoreCase(this.getAlgorithm()) || !k.getFormat().equalsIgnoreCase(this.getFormat())) {
            return false;
        }
        boolean bl = this.keyIsExportable = FIPS_140_2.getAllowKeyExport() && this.symKey.getAllowExport();
        if (!this.keyIsExportable && k instanceof SecretKeyImpl && this.symKey.equals((Object)((SecretKeyImpl)k).symKey)) {
            return true;
        }
        if (!this.keyIsExportable && !(k instanceof SecretKeyImpl)) {
            SymmetricKey tmpSK = new SymmetricKey(k.getEncoded());
            return this.symKey.equals((Object)tmpSK);
        }
        return this.keyIsExportable && Utils.areEqual((byte[])k.getEncoded(), (byte[])this.getEncoded());
    }

    public int hashCode() {
        if (this.keyIsExportable) {
            return new String(this.getEncoded()).hashCode();
        }
        return (this.algName + this.format).hashCode();
    }

    SymmetricKey getPhaosKey() {
        return this.symKey;
    }
}

