/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.io.Console;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SqlLikeConditionToRegex {
    private Pattern pattern = Pattern.compile("[\\^\\$\\.\\?\\|\\(\\)\\*\\+\\[\\{\\]\\}]");

    public String parse(String string) {
        StringBuilder stringBuilder = new StringBuilder("(?i)");
        State state = State.START_STATE;
        string = string.trim();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (state) {
                case START_STATE: {
                    if (this.isSpecialChar(c)) {
                        stringBuilder.append("\\");
                        stringBuilder.append(c);
                        continue block5;
                    }
                    if (this.isWhiteSpaceChar(c)) {
                        stringBuilder.append("\\s");
                        state = State.WHITE_SPACE;
                        continue block5;
                    }
                    if (c == '%') {
                        stringBuilder.append(".*");
                        continue block5;
                    }
                    if (c == '_') {
                        stringBuilder.append(".");
                        continue block5;
                    }
                    if (c == '\\') {
                        state = State.ESCAPED;
                        continue block5;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case ESCAPED: {
                    if (this.isWhiteSpaceChar(c)) {
                        stringBuilder.append("\\\\\\s");
                        state = State.WHITE_SPACE;
                        continue block5;
                    }
                    if (c == '%' || c == '_') {
                        stringBuilder.append(c);
                        state = State.START_STATE;
                        continue block5;
                    }
                    if (c == '\\') {
                        stringBuilder.append("\\\\");
                        state = State.START_STATE;
                        continue block5;
                    }
                    stringBuilder.append("\\\\");
                    stringBuilder.append(c);
                    state = State.START_STATE;
                    continue block5;
                }
                case WHITE_SPACE: {
                    if (this.isWhiteSpaceChar(c)) continue block5;
                    stringBuilder.append("+");
                    state = State.START_STATE;
                    if (this.isSpecialChar(c)) {
                        stringBuilder.append("\\");
                        stringBuilder.append(c);
                        continue block5;
                    }
                    if (c == '%') {
                        stringBuilder.append(".*");
                        continue block5;
                    }
                    if (c == '_') {
                        stringBuilder.append(".");
                        continue block5;
                    }
                    if (c == '\\') {
                        state = State.ESCAPED;
                        continue block5;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        if (state == State.ESCAPED) {
            stringBuilder.append("\\");
        }
        return stringBuilder.toString();
    }

    private boolean isSpecialChar(char c) {
        return this.pattern.matcher(String.valueOf(c)).matches();
    }

    private boolean isWhiteSpaceChar(char c) {
        return Character.isWhitespace(c);
    }

    public List<String> getEntryList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SYS");
        arrayList.add("EM");
        arrayList.add("URRODRIG");
        arrayList.add("select u.user#, u.password, u.identification, u.astatus from sys.user$ u where u.name = :name and u.type# = 1");
        arrayList.add("select 1 from sys.sysauth$ s where (s.grantee# = :userid or s.grantee# = 1) and (s.privilege# = :priv or s.privilege# = 67)");
        arrayList.add("call ttlogholds");
        arrayList.add("select replication_owner, replication_name from ttrep.replications");
        arrayList.add("select rep_schema_version from ttrep.ttstores where is_local_store = 0x01");
        arrayList.add("select ts.tt_store_id, ts.tt_store_name, ts.host_name, ts.rep_port_number, rs.replication_owner, rs.replication_name from ttrep.repstores rs, ttrep.ttstores ts where ts.tt_store_id = rs.tt_store_id and rs.replication_name = 'REPLICATION_41_001' and rs.replication_owner = 'TTREP' and ts.is_local_store = 0x00");
        arrayList.add("select subscriber, track_id, value, rtrim(name) from v$repstats");
        arrayList.add("select o.owner#,o.obj#,u.name,o.name,o.namespace from sys.user$ u, sys.obj$ o where u.user#=o.owner# and o.type#=:1 and not exists (select p_obj# from sys.dependency$ where p_obj# = o.obj#) order by o.obj# for update");
        arrayList.add("select owner#,name,namespace,obj#,type#,ctime,mtime,stime,status,flags from sys.obj$ where owner#=:1 and name=:2 and namespace=:3");
        arrayList.add("grant all privileges to em");
        arrayList.add("create user em identified by em");
        arrayList.add("select null from sys.obj$ where obj#=:1 and type#=:2 and obj# not in (select p_obj# from dependency$ where p_obj# = sys.obj$.obj#)");
        arrayList.add("call ttconfiguration");
        arrayList.add("call ttckpthistory");
        arrayList.add("call ttsqlcmdcacheinfo()");
        arrayList.add("select time_of_1st_connect,ds_connects,ds_disconnects,ds_checkpoints,ds_checkpoints_fuzzy,ds_compacts,perm_allocated_size,perm_in_use_size,perm_in_use_high_water,temp_allocated_size,temp_in_use_size,temp_in_use_high_water,xact_begins,xact_commits,xact_d_commits,xact_rollbacks,log_forces,lock_grants_immed,lock_grants_wait,cmd_prepares,cmd_reprepares,cmd_temp_indexes,last_log_file,rephold_log_file,rephold_log_off,rep_xact_count,rep_conflict_count,rep_peer_connections,rep_peer_retries,first_log_file,log_bytes_to_log_buffer,checkpoint_bytes_written,required_recovery,cursor_opens,cursor_closes,tpl_fetches,tpl_execs,cache_hits,passthrough_count,type_mode from sys.monitor");
        arrayList.add("call ttplsqlmemorystats");
        arrayList.add("select * from sys.systemstats");
        arrayList.add("select -count(*) from sys.cache_group union all select count(*) from ttrep.repelements");
        arrayList.add("call ttSqlCmdCacheInfo2");
        return arrayList;
    }

    public String getMatches(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (!string2.matches(string)) continue;
            stringBuilder.append(string2 + "\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("\nSQL LIKE clause to Java Regex Parser\n");
        SqlLikeConditionToRegex sqlLikeConditionToRegex = new SqlLikeConditionToRegex();
        List<String> list = sqlLikeConditionToRegex.getEntryList();
        Console console = System.console();
        if (console == null) {
            System.out.println("Unable to fetch console");
            return;
        }
        String string = "";
        while (!string.equalsIgnoreCase("exit")) {
            System.out.print("Input string: ");
            string = console.readLine();
            String string2 = sqlLikeConditionToRegex.parse(string);
            System.out.println("Output string: " + string2);
            System.out.println("Matches: " + sqlLikeConditionToRegex.getMatches(list, string2));
        }
    }

    public static enum State {
        START_STATE,
        ESCAPED,
        WHITE_SPACE;

    }
}

