/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.metrics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.DateAxis;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricPane;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricTreeNode;
import oracle.dbtools.raptor.timesten.utils.JavaFxWorker;

public class SplitGridPane
extends SplitPane {
    private HashMap<Label, Tab> labelTabMap = new HashMap();
    private int gridSize;
    private TabPane[][] gridPanes;
    private Connection connection;
    private DateFormat df = DateFormat.getDateTimeInstance(1, 2, Locale.getDefault());
    private DecimalFormat format = new DecimalFormat("###,###.00");
    private final String TIME = Messages.getString("TimestenGrid.time");
    private final String VALUE = Messages.getString("TimestenGrid.value");
    private MetricPane parent;
    private static final String _2_HOURS = "(1/12)";
    private HashMap<MetricInfo, Tab> metricTabs = new HashMap();
    private HashMap<Tab, MetricInfo> tabMetrics = new HashMap();
    ChangeListener<Number> sizeChange = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
        }
    };
    EventHandler<DragEvent> dragOver = new EventHandler<DragEvent>(){

        public void handle(DragEvent dragEvent) {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasString()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            dragEvent.consume();
        }
    };
    EventHandler<DragEvent> dragDropped = new EventHandler<DragEvent>(){

        public void handle(DragEvent dragEvent) {
            TreeCell treeCell;
            MetricTreeNode metricTreeNode;
            if (dragEvent.getGestureSource() instanceof TreeCell && (metricTreeNode = (MetricTreeNode)(treeCell = (TreeCell)dragEvent.getGestureSource()).getItem()) instanceof MetricInfo) {
                if (SplitGridPane.this.metricTabs.containsKey((MetricInfo)metricTreeNode)) {
                    Tab tab = SplitGridPane.this.metricTabs.get((MetricInfo)metricTreeNode);
                    tab.getTabPane().getSelectionModel().select((Object)tab);
                } else {
                    Tab tab = SplitGridPane.this.createTab((MetricInfo)metricTreeNode);
                    if (dragEvent.getGestureTarget() instanceof TabPane) {
                        TabPane tabPane = (TabPane)dragEvent.getGestureTarget();
                        tabPane.getTabs().add((Object)tab);
                        LineChart lineChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
                        SplitGridPane.this.fillChartWithInfoHelper((LineChart<Date, Number>)lineChart, ((MetricInfo)metricTreeNode).getName());
                        tab.setContent((Node)lineChart);
                        tabPane.getSelectionModel().select((Object)tab);
                    }
                }
            }
            if (dragEvent.getGestureSource() instanceof Label) {
                treeCell = SplitGridPane.this.labelTabMap.get((Label)dragEvent.getGestureSource());
                treeCell.getTabPane().getTabs().remove((Object)treeCell);
                metricTreeNode = (TabPane)dragEvent.getGestureTarget();
                metricTreeNode.getTabs().add((Object)treeCell);
                metricTreeNode.getSelectionModel().select((Object)treeCell);
            }
            dragEvent.consume();
        }
    };

    public SplitGridPane(int n, Connection connection, MetricPane metricPane) {
        this.parent = metricPane;
        this.connection = connection;
        this.gridSize = n;
        this.setOrientation(Orientation.VERTICAL);
        this.doGridResize();
        this.widthProperty().addListener(this.sizeChange);
        this.heightProperty().addListener(this.sizeChange);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int n) {
        if (n != 2 && n != 3) {
            return;
        }
        if (this.gridSize != n) {
            this.gridSize = n;
            this.doGridResize();
            this.doGridLayout();
            this.metricTabs.clear();
            this.tabMetrics.clear();
        }
    }

    private void doGridResize() {
        this.gridPanes = new TabPane[this.gridSize][this.gridSize];
        this.getItems().clear();
        for (int i = 0; i < this.gridSize; ++i) {
            SplitPane splitPane = new SplitPane();
            splitPane.setOrientation(Orientation.HORIZONTAL);
            for (int j = 0; j < this.gridSize; ++j) {
                this.gridPanes[i][j] = new TabPane();
                this.gridPanes[i][j].setOnDragOver(this.dragOver);
                this.gridPanes[i][j].setOnDragDropped(this.dragDropped);
                splitPane.getItems().add((Object)this.gridPanes[i][j]);
            }
            this.getItems().add((Object)splitPane);
        }
    }

    public void doGridLayout() {
        double d;
        double d2 = d = 1.0 / (double)this.gridSize;
        for (int i = 0; i < this.gridSize; ++i) {
            this.setDividerPosition(i, d2);
            d2 += d;
            double d3 = d;
            for (int j = 0; j < this.gridSize; ++j) {
                ((SplitPane)this.getItems().get(i)).setDividerPosition(j, d3);
                d3 += d;
            }
        }
    }

    private Tab createTab(final MetricInfo metricInfo) {
        Label label = new Label(metricInfo.getVisibleName());
        Tab tab = new Tab();
        tab.setGraphic((Node)label);
        this.labelTabMap.put(label, tab);
        label.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Dragboard dragboard = ((Label)mouseEvent.getSource()).startDragAndDrop(TransferMode.COPY_OR_MOVE);
                dragboard.setDragView((Image)((Label)mouseEvent.getSource()).getParent().getParent().getParent().snapshot(null, null));
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString("TRA");
                dragboard.setContent((Map)clipboardContent);
            }
        });
        tab.setOnClosed((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                Tab tab = SplitGridPane.this.metricTabs.remove(metricInfo);
                SplitGridPane.this.tabMetrics.remove(tab);
            }
        });
        this.metricTabs.put(metricInfo, tab);
        this.tabMetrics.put(tab, metricInfo);
        return tab;
    }

    public void insertMetricChart(int n, int n2, MetricInfo metricInfo) {
        if (this.metricTabs.containsKey(metricInfo)) {
            Tab tab = this.metricTabs.get(metricInfo);
            tab.getTabPane().getSelectionModel().select((Object)tab);
        } else {
            Tab tab = this.createTab(metricInfo);
            TabPane tabPane = this.gridPanes[n][n2];
            tabPane.getTabs().add((Object)tab);
            LineChart lineChart = new LineChart((Axis)new DateAxis(), (Axis)new NumberAxis());
            this.fillChartWithInfoHelper((LineChart<Date, Number>)lineChart, metricInfo.getName());
            tab.setContent((Node)lineChart);
            tabPane.getSelectionModel().select((Object)tab);
        }
    }

    public void insertMetricChart(int n, MetricInfo metricInfo) {
        int n2 = n % this.gridSize;
        int n3 = n / this.gridSize;
        this.insertMetricChart(n3, n2, metricInfo);
    }

    private void refreshChart(MetricInfo metricInfo, Tab tab) {
        if (tab.getContent() instanceof LineChart) {
            LineChart lineChart = (LineChart)tab.getContent();
            this.fillChartWithInfoHelper((LineChart<Date, Number>)lineChart, metricInfo.getName());
        }
    }

    public void refreshAllCharts() {
        for (MetricInfo metricInfo : this.metricTabs.keySet()) {
            this.refreshChart(metricInfo, this.metricTabs.get(metricInfo));
        }
    }

    public String getMetricNamesAt(int n) {
        int n2 = n % this.gridSize;
        int n3 = n / this.gridSize;
        return this.getMetricNamesAt(n2, n3);
    }

    public String getMetricNamesAt(int n, int n2) {
        TabPane tabPane = this.gridPanes[n][n2];
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Tab tab : tabPane.getTabs()) {
            if (bl) {
                bl = false;
                stringBuffer.append(this.tabMetrics.get(tab).getName());
                continue;
            }
            stringBuffer.append("|" + this.tabMetrics.get(tab).getName());
        }
        return stringBuffer.toString();
    }

    private void fillChartWithInfoHelper(final LineChart<Date, Number> lineChart, final String string) {
        final String string2 = "SELECT /* !!!!! SQL Developer Performance Monitor Query !!!!! */ elementid ,metric_value, collected_at from SYS.GV$TTSTATS_ELEMENT_METRICS   where ElementId in (:ELEMENTS:) AND  trim(METRIC_NAME) =  ':METRIC_NAME:' AND  COLLECTED_AT  > SYSDATE - :TIME:  ORDER BY ELEMENTID , COLLECTED_AT";
        final String string3 = this.parent.getElementsIdAsStringList();
        if (string3 == null || string3.isEmpty()) {
            lineChart.getData().clear();
            return;
        }
        JavaFxWorker javaFxWorker = new JavaFxWorker(){
            LinkedHashMap<Integer, XYChart.Series<Date, Number>> allSeries = new LinkedHashMap();

            @Override
            public void doInBackground() {
                try (Statement statement = SplitGridPane.this.connection.createStatement();){
                    String string4 = string2.replace(":ELEMENTS:", string3).replace(":TIME:", SplitGridPane._2_HOURS).replace(":METRIC_NAME:", string);
                    ResultSet resultSet = statement.executeQuery(string4);
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        double d = resultSet.getDouble(2);
                        Timestamp timestamp = resultSet.getTimestamp(3);
                        XYChart.Series series = this.allSeries.get(n);
                        if (series == null) {
                            series = new XYChart.Series();
                            series.setName(Integer.toString(n));
                            this.allSeries.put(n, (XYChart.Series<Date, Number>)series);
                        }
                        XYChart.Data data = new XYChart.Data((Object)timestamp, (Object)d);
                        series.getData().add((Object)data);
                        Circle circle = new Circle(5.0);
                        circle.setFill((Paint)Color.TRANSPARENT);
                        data.setNode((Node)circle);
                        Tooltip.install((Node)circle, (Tooltip)new Tooltip(SplitGridPane.this.TIME + " " + SplitGridPane.this.df.format((Date)data.getXValue()) + "\n" + SplitGridPane.this.VALUE + " " + SplitGridPane.this.format.format(((Number)data.getYValue()).doubleValue())));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }

            @Override
            public void done() {
                lineChart.getData().clear();
                lineChart.getData().addAll(this.allSeries.values());
                this.allSeries.clear();
                this.allSeries = null;
            }
        };
        javaFxWorker.execute();
    }
}

