/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DatabaseElementInfo;

public class DatabaseElementInfoFactory {
    private static DatabaseElementInfoFactory theInstance;
    private static final Logger LOGGER;
    private static final String DISTRIBUTION_MAP_SQL = "select MAPPEDELEMENTID,HOSTNAME,INSTANCENAME from v$distribution_current order by mappedelementid asc";

    private DatabaseElementInfoFactory() {
    }

    public static synchronized DatabaseElementInfoFactory getTheInstance() {
        if (theInstance == null) {
            theInstance = new DatabaseElementInfoFactory();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, DatabaseElementInfo> getDatabaseElementInfo(Connection connection) {
        HashMap<Integer, DatabaseElementInfo> hashMap = new HashMap<Integer, DatabaseElementInfo>();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(DISTRIBUTION_MAP_SQL);
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                DatabaseElementInfo databaseElementInfo = new DatabaseElementInfo(n);
                databaseElementInfo.setTheHostName(resultSet.getString(2));
                databaseElementInfo.setTheInstanceName(resultSet.getString(3));
                hashMap.put(n, databaseElementInfo);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.warning("Cannot get database element information: " + sQLException.getLocalizedMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
    }

    static {
        LOGGER = Logger.getLogger(DatabaseElementInfoFactory.class.getName());
    }
}

