/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.performancemonitor.GenericPerformanceMonitorNode;
import oracle.dbtools.raptor.timesten.performancemonitor.GridSummaryPane;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceDataEditor;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;

public class TopSQLTile
extends BorderPane {
    private Text text;
    private Label sql;
    private String title;
    private ObservableList<TopSQLCmdBean> allTop;
    private Connection conn;

    public TopSQLTile(String string, Connection connection) {
        this.title = string;
        this.conn = connection;
        this.text = new Text(string);
        this.text.setFont(GridSummaryPane.TITLE_FONT);
        this.setTop((Node)this.text);
        this.sql = new Label();
        this.sql.setWrapText(true);
        this.sql.setPadding(new Insets(5.0));
        this.setCenter((Node)this.sql);
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                GenericPerformanceMonitorNode genericPerformanceMonitorNode = null;
                                genericPerformanceMonitorNode = new GenericPerformanceMonitorNode(TopSQLTile.this.title, GenericPerformanceMonitorNode.TOP_SQL);
                                genericPerformanceMonitorNode.setTopSQL(TopSQLTile.this.allTop);
                                genericPerformanceMonitorNode.setConn(TopSQLTile.this.conn);
                                Context context = Context.newIdeContext((oracle.ide.model.Node)genericPerformanceMonitorNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, PerformanceDataEditor.class);
                                List list = EditorManager.getEditorManager().getAllEditors();
                                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                                for (Editor editor : list) {
                                    if (!(editor instanceof PerformanceDataEditor)) continue;
                                    arrayList.add(editor);
                                }
                                EditorManager.getEditorManager().closeEditors(arrayList);
                                Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
    }

    public void setSQL(ObservableList<TopSQLCmdBean> observableList) {
        this.allTop = observableList;
        if (!observableList.isEmpty()) {
            this.sql.setText(((TopSQLCmdBean)observableList.get(0)).getQuery());
        }
    }
}

