/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceDataPane;
import oracle.dbtools.raptor.timesten.performancemonitor.TopSQLPane;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;

public class JFXPerformanceDataPane
extends JFXPanel {
    private static final long serialVersionUID = 1L;
    private Region pane;
    private Connection conn;
    private ObservableList<TopSQLCmdBean> topSQL;
    private ShutdownHook fxShutdownHook;
    private DashboardSummaryInfo info;

    public JFXPerformanceDataPane(DashboardSummaryInfo dashboardSummaryInfo) {
        this.info = dashboardSummaryInfo;
        this.setUpPane();
    }

    public JFXPerformanceDataPane(ObservableList<TopSQLCmdBean> observableList, Connection connection) {
        this.topSQL = observableList;
        this.conn = connection;
        this.setUpPane();
    }

    private void setUpPane() {
        this.init();
        Platform.setImplicitExit((boolean)false);
        this.fxShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)this.fxShutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)this.fxShutdownHook);
    }

    private void init() {
        if (Platform.isFxApplicationThread()) {
            this.setUpFx();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFXPerformanceDataPane.this.setUpFx();
                }
            });
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(final ComponentEvent componentEvent) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JFXPerformanceDataPane.this.pane.setMinSize((double)componentEvent.getComponent().getWidth(), (double)componentEvent.getComponent().getHeight());
                        JFXPerformanceDataPane.this.pane.setMaxSize((double)componentEvent.getComponent().getWidth(), (double)componentEvent.getComponent().getHeight());
                        JFXPerformanceDataPane.this.pane.setPrefSize((double)componentEvent.getComponent().getWidth(), (double)componentEvent.getComponent().getHeight());
                    }
                });
            }
        });
    }

    private void setUpFx() {
        Scene scene = new Scene((Parent)new Group());
        String string = ((Object)((Object)this)).getClass().getResource("ottPerformanceStyle.css").toExternalForm();
        scene.getStylesheets().add((Object)string);
        if (this.info != null) {
            this.pane = new PerformanceDataPane(this.info);
        } else if (this.topSQL != null) {
            this.pane = new TopSQLPane(this.topSQL, this.conn);
        }
        ((Group)scene.getRoot()).getChildren().add((Object)this.pane);
        this.setScene(scene);
    }
}

