/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.topology;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;

public class Topology {
    protected Set<TopologyElement> inTopology = new HashSet<TopologyElement>();
    protected Set<TopologyElement> notInTopology = new HashSet<TopologyElement>();
    protected Map<Integer, Set<TopologyElement>> topology;
    protected Map<Integer, Set<TopologyElement>> notTopology;
    protected Set<TopologyElement> toAdd;
    protected Map<TopologyElement, Integer> toAddDSG;
    protected Set<TopologyElement> toRemove = new HashSet<TopologyElement>();
    protected int kSafety;
    static final String DSG_STR = Messages.getString("TimesTenGrid.dsg");

    public Topology(int n) {
        this.topology = new HashMap<Integer, Set<TopologyElement>>();
        this.notTopology = new HashMap<Integer, Set<TopologyElement>>();
        this.toAdd = new HashSet<TopologyElement>();
        this.toAddDSG = new HashMap<TopologyElement, Integer>();
        for (int i = 0; i < n; ++i) {
            this.topology.put(i + 1, new HashSet());
            this.notTopology.put(i + 1, new HashSet());
        }
        this.kSafety = n;
    }

    public int getKSafety() {
        return this.kSafety;
    }

    public void save(TopologyElement topologyElement) {
        if (topologyElement.isAppliedInTopology()) {
            this.inTopology.add(topologyElement);
            this.topology.get(topologyElement.getDataSpaceGroup()).add(topologyElement);
        } else {
            this.notInTopology.add(topologyElement);
            if (topologyElement.hasDSG()) {
                this.notTopology.get(topologyElement.getDataSpaceGroup()).add(topologyElement);
            }
        }
    }

    public void markToRemove(TopologyElement topologyElement) {
        if (this.toAdd.contains(topologyElement) || this.toAddDSG.containsKey(topologyElement)) {
            this.toAdd.remove(topologyElement);
            this.toAddDSG.remove(topologyElement);
        } else if (!this.toRemove.contains(topologyElement)) {
            this.toRemove.add(topologyElement);
        }
    }

    public void markToAdd(TopologyElement topologyElement) {
        if (this.toRemove.contains(topologyElement)) {
            this.toRemove.remove(topologyElement);
        } else {
            this.toAdd.add(topologyElement);
            this.toAddDSG.put(topologyElement, 0);
        }
    }

    public void markToAdd(TopologyElement topologyElement, int n) {
        if (this.toRemove.contains(topologyElement)) {
            this.toRemove.remove(topologyElement);
        } else {
            this.toAddDSG.put(topologyElement, n);
            this.toAdd.add(topologyElement);
        }
    }

    public boolean isMarkedToAdd(TopologyElement topologyElement) {
        return this.toAdd.contains(topologyElement) || this.toAddDSG.containsKey(topologyElement) || topologyElement.isMarkedToBeAdded();
    }

    public boolean isLocallyMarkedToAdd(TopologyElement topologyElement) {
        return this.toAdd.contains(topologyElement) || this.toAddDSG.containsKey(topologyElement);
    }

    public boolean isMarkedToRemove(TopologyElement topologyElement) {
        return this.toRemove.contains(topologyElement) || topologyElement.isMarkedToBeRemoved();
    }

    public Set<TopologyElement> getNotInTopology() {
        return this.notInTopology;
    }

    public Set<TopologyElement> getElementsInTopology() {
        return this.inTopology;
    }

    public Set<TopologyElement> getElementsInTopology(int n) {
        return this.topology.get(n);
    }

    public Set<TopologyElement> getElementsInTopologyHideRemoved(int n) {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll((Collection)this.topology.get(n));
        for (TopologyElement topologyElement : this.toAddDSG.keySet()) {
            if (this.toAddDSG.containsKey(topologyElement) && this.toAddDSG.get(topologyElement) != n) {
                hashSet.remove(topologyElement);
            }
            if (this.toAddDSG.get(topologyElement) != n) continue;
            hashSet.add(topologyElement);
        }
        hashSet.removeAll(this.toRemove);
        return hashSet;
    }

    public int getElementLocalDataspaceGroup(TopologyElement topologyElement) {
        if (this.toAddDSG.containsKey(topologyElement)) {
            return this.toAddDSG.get(topologyElement);
        }
        if (this.toRemove.contains(topologyElement)) {
            return -1;
        }
        for (Integer n : this.topology.keySet()) {
            if (!this.topology.get(n).contains(topologyElement)) continue;
            return n;
        }
        return -1;
    }

    public Set<TopologyElement> getToAdd() {
        return this.toAdd;
    }

    public Map<TopologyElement, Integer> getToAddDSG() {
        return this.toAddDSG;
    }

    public Set<TopologyElement> getElementsMarkedToAdd(int n) {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll(this.toAdd);
        hashSet.addAll((Collection)this.notTopology.get(n));
        hashSet.removeIf(topologyElement -> topologyElement.getDataSpaceGroup() != n);
        hashSet.removeIf(topologyElement -> !this.isMarkedToAdd((TopologyElement)topologyElement));
        return hashSet;
    }

    public Set<TopologyElement> getElementsMarkedToAddInDSG(int n) {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        for (TopologyElement topologyElement : this.toAddDSG.keySet()) {
            if (this.toAddDSG.get(topologyElement) != n) continue;
            hashSet.add(topologyElement);
        }
        return hashSet;
    }

    public Set<TopologyElement> getToRemove() {
        return this.toRemove;
    }

    public Set<TopologyElement> getElementsNotAddMarked() {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll(this.notInTopology);
        hashSet.removeIf(topologyElement -> this.isMarkedToAdd((TopologyElement)topologyElement));
        return hashSet;
    }

    public Set<TopologyElement> getElementsNotIncludedShowRemoved() {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll(this.notInTopology);
        hashSet.removeIf(topologyElement -> this.isMarkedToAdd((TopologyElement)topologyElement));
        hashSet.addAll(this.toRemove);
        return hashSet;
    }

    public Set<TopologyElement> getAddableElements(int n) {
        if (n <= 0 || n > this.kSafety) {
            return new HashSet<TopologyElement>();
        }
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll((Collection)this.notTopology.get(n));
        hashSet.removeIf(topologyElement -> this.isMarkedToAdd((TopologyElement)topologyElement));
        hashSet.removeIf(topologyElement -> !topologyElement.isAddableToTopology());
        return hashSet;
    }

    public Set<TopologyElement> getRemovableElements(int n) {
        if (n <= 0 || n > this.kSafety) {
            return new HashSet<TopologyElement>();
        }
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        hashSet.addAll((Collection)this.topology.get(n));
        hashSet.removeIf(topologyElement -> this.isMarkedToRemove((TopologyElement)topologyElement));
        return hashSet;
    }

    public void clear() {
        this.inTopology.clear();
        this.notInTopology.clear();
        this.toAdd.clear();
        this.toAddDSG.clear();
        this.toRemove.clear();
        this.topology.clear();
        this.notTopology.clear();
        for (int i = 0; i < this.kSafety; ++i) {
            this.topology.put(i + 1, new HashSet());
            this.notTopology.put(i + 1, new HashSet());
        }
    }

    public String[] getDataSpaceGroups() {
        String[] stringArray = new String[this.kSafety];
        for (int i = 0; i < this.kSafety; ++i) {
            stringArray[i] = MessageFormat.format(DSG_STR, i + 1);
        }
        return stringArray;
    }

    public TopologyElement getElementByName(String string) {
        for (TopologyElement topologyElement : this.getElementsInTopology()) {
            if (!topologyElement.isSameElement(string)) continue;
            return topologyElement;
        }
        for (TopologyElement topologyElement : this.notInTopology) {
            if (!topologyElement.isSameElement(string)) continue;
            return topologyElement;
        }
        return null;
    }

    public void clearChanges() {
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        for (TopologyElement topologyElement : this.toAdd) {
            if (topologyElement.isMarkedToBeAdded()) continue;
            hashSet.add(topologyElement);
        }
        this.toAdd.removeAll(hashSet);
        this.toAddDSG.clear();
        hashSet.clear();
        for (TopologyElement topologyElement : this.toRemove) {
            if (topologyElement.isMarkedToBeRemoved()) continue;
            hashSet.add(topologyElement);
        }
        this.toRemove.removeAll(hashSet);
    }

    public boolean changesPending() {
        return !this.toAdd.isEmpty() || !this.toAddDSG.isEmpty() || !this.toRemove.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public Set<TopologyElement> getMaxAddableElements() {
        void var5_12;
        HashSet<TopologyElement> hashSet = new HashSet<TopologyElement>();
        int[] nArray = new int[this.kSafety];
        int[] nArray2 = new int[this.kSafety];
        for (Integer object : this.topology.keySet()) {
            nArray2[object.intValue() - 1] = 0;
            nArray[object.intValue() - 1] = 0;
            for (TopologyElement topologyElement : this.topology.get(object)) {
                if (this.isMarkedToRemove(topologyElement)) continue;
                int n = object - 1;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (TopologyElement topologyElement : this.notInTopology) {
            if (!this.isMarkedToAdd(topologyElement)) continue;
            int n = topologyElement.getDataSpaceGroup() - 1;
            nArray[n] = nArray[n] + 1;
        }
        for (TopologyElement topologyElement : this.notInTopology) {
            if (this.isMarkedToAdd(topologyElement) || !topologyElement.isAddableToTopology()) continue;
            int n = topologyElement.getDataSpaceGroup() - 1;
            nArray2[n] = nArray2[n] + 1;
        }
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        while (var5_12 < this.kSafety) {
            if (nArray2[var5_12] + nArray[var5_12] < n) {
                n = nArray2[var5_12] + nArray[var5_12];
            }
            ++var5_12;
        }
        for (TopologyElement topologyElement : this.notInTopology) {
            if (nArray[topologyElement.getDataSpaceGroup() - 1] >= n) continue;
            hashSet.add(topologyElement);
            int n2 = topologyElement.getDataSpaceGroup() - 1;
            nArray[n2] = nArray[n2] + 1;
        }
        return hashSet;
    }
}

