/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.start;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.start.DataInstTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.start.DatabaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.start.MgmtInstTraversablePanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class StartGridWizardMain {
    static final String MGMT_STATE = "MgmtInstancesState";
    static final String INST_STATE = "InstancesState";
    static final String DB_STATE = "DatabasesState";
    static final String MGMT_TRANSITION = "Management";
    static final String INST_TRANSITION = "Instances";
    static final String DB_TRANSITION = "Database";
    private static StartGridWizardMain INSTANCE;
    private static WizardDialog _currentDialog;
    private static Logger logger;

    public static synchronized StartGridWizardMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StartGridWizardMain();
        }
        return INSTANCE;
    }

    public void launchWizard() {
        this.launchWizard(StartGridWizardMain.getFSM());
    }

    private static FSM getFSM() {
        Step step = new Step(Messages.getString("TimesTenGrid.mgmtInstStatus"), MgmtInstTraversablePanel.class, TimesTenHelpID.GRID_START_MGMT_INSTS.toString());
        Step step2 = new Step(Messages.getString("TimesTenGrid.dataInstStatus"), DataInstTraversablePanel.class, TimesTenHelpID.GRID_START_DATA_INSTS.toString());
        Step step3 = new Step(Messages.getString("TimesTenGrid.databaseLoadStatus"), DatabaseTraversablePanel.class, TimesTenHelpID.GRID_START_DB_LOAD_STATUS.toString());
        FSMBuilder fSMBuilder = new FSMBuilder();
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)INST_TRANSITION, (Object)INST_STATE);
        fSMBuilder.newState((Object)INST_STATE, step2, (Object)DB_STATE);
        fSMBuilder.newFinalState((Object)DB_STATE, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            logger.log(Level.SEVERE, "Could not fire start grid wizard\n" + fSMInvalidException.getMessage());
            return null;
        }
    }

    private void launchWizard(FSM fSM) {
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        _currentDialog = bigWizardDialog;
        bigWizardDialog.setPreferredSize(new Dimension(850, 600));
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        fSMWizard.setWizardTitle(Messages.getString("TimesTenGrid.gridStartWizard"));
        fSMWizard.addWizardListener(new WizardListener(){

            public void wizardSelectionChanged(WizardEvent wizardEvent) {
            }

            public void wizardFinished(WizardEvent wizardEvent) {
            }

            public void wizardApplyState(WizardEvent wizardEvent) {
            }

            public void wizardCanceled(WizardEvent wizardEvent) {
                DefaultTraversablePanel defaultTraversablePanel = (DefaultTraversablePanel)wizardEvent.getPage().getContent();
                BaseTraversablePanel baseTraversablePanel = (BaseTraversablePanel)defaultTraversablePanel;
                baseTraversablePanel.shutdownAutoRefresh();
            }
        });
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public synchronized WizardDialog getCurrentWizardDialog() {
        return _currentDialog;
    }

    static {
        logger = Logger.getLogger(StartGridWizardMain.class.getName());
    }
}

