/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.grid.shell.SSHShellChannel;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.CurrentScreenBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.PreviousLinesBuffer;

public class TimesTenShellComponent
extends JComponent
implements Scrollable {
    public static final int MAX_NUM_OF_BUFFERED_LINES = 100;
    private Font font;
    public static final int MIN_WIDTH = 500;
    public static final int MIN_HEIGHT = 400;
    private int columns = 0;
    private int rows = 0;
    private int theight;
    private int twidth;
    private BufferedImage img;
    private int charWidth;
    private int charHeight;
    private Color defaultBgColor = Color.WHITE;
    private Color defaultFgColor = Color.BLACK;
    private Color highlightColor = Color.DARK_GRAY;
    private int x;
    private int y = 0;
    private int maxImageHeight;
    private int maxImageWidth;
    private int currentNumberOfLines = -1;
    private OutputStream outputStream;
    private InputStream inputStream;
    private Graphics2D graphics;
    private Graphics2D selectionGraphics;
    private SSHShellChannel channel;
    private int descent;
    private int ascend;
    private Graphics2D cursor_graphics;
    private FontMetrics metrics;
    private boolean underlined;
    private boolean reversed;
    private final Object[] colors = new Object[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
    private Color foregroundColor = this.defaultFgColor;
    private Color backgroundColor = this.defaultBgColor;
    private BufferedImage background;
    private BufferedImage bufferImage;
    private boolean bold;
    private JPopupMenu menu;
    private JMenuItem paste;
    private Graphics2D highlightGraphics;
    private Graphics2D bufferGraphics;
    private ShellSelectionAdapter shellMouseListener;
    private CurrentScreenBuffer screenBuffer;
    private JMenuItem copy;
    private PreviousLinesBuffer previousLinesBuffer;
    private static HashMap<Integer, Color> foregroundColors = new HashMap();
    private static HashMap<Integer, Color> backgroundColors;

    public TimesTenShellComponent(SSHShellChannel sSHShellChannel, int n, int n2) {
        this.theight = n2;
        this.twidth = n;
        this.channel = sSHShellChannel;
        this.outputStream = this.channel.getOutputStream();
        this.shellMouseListener = new ShellSelectionAdapter();
        this.setConfigs();
        this.prepareMenu();
        super.setSize(n, n2);
        this.channel.changeTerminalSize(this.getColumns(), this.getRows(), this.getColumns() * this.getCharWidth(), this.getRows() * this.getCharHeight());
        this.cleanArea(0, 0, this.twidth, this.theight);
        this.enableEvents(8L);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseListener(this.shellMouseListener);
        this.addMouseMotionListener(this.shellMouseListener);
        this.enableInputMethods(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.resetCursorGraphics();
        this.drawCursor();
        this.prepareKeys();
        this.prepareClicks();
        this.prepareBufferImage();
    }

    private void prepareBufferImage() {
        int n = 100 * this.charHeight;
        this.bufferImage = new BufferedImage(this.twidth, n, 1);
        this.bufferGraphics = (Graphics2D)this.bufferImage.getGraphics();
        this.bufferGraphics.fillRect(0, 0, this.twidth, n);
    }

    public void prepareMenu() {
        this.menu = new JPopupMenu();
        this.copy = new JMenuItem("Copy");
        this.paste = new JMenuItem("Paste");
        this.menu.add(this.copy);
        this.menu.add(this.paste);
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimesTenShellComponent.this.pasteText();
            }
        });
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimesTenShellComponent.this.copyText();
            }
        });
    }

    private void prepareClicks() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    TimesTenShellComponent.this.requestFocusInWindow();
                }
                if (mouseEvent.getButton() == 2) {
                    TimesTenShellComponent.this.pasteText();
                }
                if (mouseEvent.getButton() == 3 && !mouseEvent.isPopupTrigger()) {
                    TimesTenShellComponent.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                super.mouseClicked(mouseEvent);
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private void copyText() {
        String string = this.shellMouseListener.getSelectedString();
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    private void pasteText() {
        try {
            String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            if (string != null && string.length() > 0) {
                this.outputStream.write(string.getBytes());
                this.outputStream.flush();
            }
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setConfigs() {
        this.prepareFont();
        this.setPreferredSize(new Dimension(this.getTerminalWidth(), this.getTerminalHeight()));
        this.maxImageHeight = 100 * this.charHeight;
        this.currentNumberOfLines = 0;
    }

    public void prepareFont() {
        this.font = Font.decode("Monospaced-14");
        this.img = new BufferedImage(this.twidth, this.theight, 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setFont(this.font);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.metrics = this.graphics.getFontMetrics();
        this.charWidth = this.metrics.charWidth('@');
        this.charHeight = this.metrics.getHeight() + 3;
        this.columns = this.twidth / this.charWidth;
        this.rows = this.theight / this.charHeight;
        this.descent = this.graphics.getFontMetrics().getDescent();
        this.descent += 2;
        this.ascend = this.graphics.getFontMetrics().getAscent();
        this.background = new BufferedImage(this.charWidth, this.charHeight, 1);
        Graphics2D graphics2D = (Graphics2D)this.background.getGraphics();
        graphics2D.setColor(this.getBackGroundColor());
        graphics2D.fillRect(0, 0, this.charWidth, this.charHeight);
        graphics2D.dispose();
    }

    public void setTerminalSize(int n, int n2) {
        this.twidth = n;
        this.theight = n2;
        this.resizeTerminal();
        this.resizeBufferImage();
        final Dimension dimension = new Dimension(n, n2 + this.charHeight * this.currentNumberOfLines);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setPreferredSize(dimension);
            this.setSize(dimension);
            this.revalidate();
            this.repaint();
            this.scrollDown();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TimesTenShellComponent.this.setPreferredSize(dimension);
                        TimesTenShellComponent.this.setSize(dimension);
                        TimesTenShellComponent.this.revalidate();
                        TimesTenShellComponent.this.repaint();
                        TimesTenShellComponent.this.scrollDown();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void resizeBufferImage() {
        BufferedImage bufferedImage = this.bufferImage;
        this.bufferImage = new BufferedImage(this.twidth, this.bufferImage.getHeight(), 1);
        if (this.bufferGraphics != null) {
            this.bufferGraphics.dispose();
        }
        this.bufferGraphics = (Graphics2D)this.bufferImage.getGraphics();
        this.bufferGraphics.fillRect(0, 0, this.twidth, this.bufferImage.getHeight());
        this.bufferGraphics.drawImage((Image)bufferedImage, 0, 0, this);
    }

    public void resizeTerminal() {
        BufferedImage bufferedImage = this.img;
        this.img = new BufferedImage(this.twidth, this.theight, 1);
        if (this.graphics != null) {
            this.graphics.dispose();
        }
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.prepareFont();
        this.cleanArea(0, 0, this.twidth, this.theight);
        this.graphics.drawImage((Image)bufferedImage, 0, 0, this);
        bufferedImage.flush();
        this.resetCursorGraphics();
        this.prepareSelectionGraphics();
        this.channel.changeTerminalSize(this.getColumns(), this.getRows(), this.getColumns() * this.getCharWidth(), this.getRows() * this.getCharHeight());
        this.repaint();
    }

    public void prepareSelectionGraphics() {
        if (this.selectionGraphics != null) {
            this.selectionGraphics.dispose();
        }
        this.selectionGraphics = (Graphics2D)this.img.getGraphics();
        this.selectionGraphics.setColor(this.foregroundColor);
        this.selectionGraphics.setXORMode(this.backgroundColor);
    }

    public void prepareKeys() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                byte[] byArray = null;
                switch (keyEvent.getKeyCode()) {
                    case 67: {
                        if (!keyEvent.isControlDown()) break;
                        TimesTenShellComponent.this.channel.sendControlC();
                        break;
                    }
                    case 90: {
                        if (!keyEvent.isControlDown()) break;
                        TimesTenShellComponent.this.channel.sendControlZ();
                        break;
                    }
                    case 68: {
                        if (!keyEvent.isControlDown()) break;
                        TimesTenShellComponent.this.channel.sendControlD();
                        break;
                    }
                    case 112: {
                        byArray = SSHShellChannel.F1;
                        break;
                    }
                    case 113: {
                        byArray = SSHShellChannel.F2;
                        break;
                    }
                    case 114: {
                        byArray = SSHShellChannel.F3;
                        break;
                    }
                    case 115: {
                        byArray = SSHShellChannel.F4;
                        break;
                    }
                    case 116: {
                        byArray = SSHShellChannel.F5;
                        break;
                    }
                    case 117: {
                        byArray = SSHShellChannel.F6;
                        break;
                    }
                    case 118: {
                        byArray = SSHShellChannel.F8;
                        break;
                    }
                    case 119: {
                        byArray = SSHShellChannel.F8;
                        break;
                    }
                    case 120: {
                        byArray = SSHShellChannel.F9;
                        break;
                    }
                    case 121: {
                        byArray = SSHShellChannel.F10;
                        break;
                    }
                    case 10: {
                        byArray = SSHShellChannel.ENTER;
                        break;
                    }
                    case 9: {
                        byArray = SSHShellChannel.tab;
                        break;
                    }
                    case 40: {
                        byArray = SSHShellChannel.DOWN;
                        break;
                    }
                    case 38: {
                        byArray = SSHShellChannel.UP;
                        break;
                    }
                    case 37: {
                        byArray = SSHShellChannel.LEFT;
                        break;
                    }
                    case 39: {
                        byArray = SSHShellChannel.RIGHT;
                    }
                }
                try {
                    if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 20) {
                        return;
                    }
                    if (byArray == null) {
                        byArray = new byte[]{(byte)keyEvent.getKeyChar()};
                        if ((keyEvent.getKeyChar() & 0xFF00) == 0) {
                            TimesTenShellComponent.this.outputStream.write(byArray);
                            TimesTenShellComponent.this.outputStream.flush();
                        }
                    } else {
                        TimesTenShellComponent.this.outputStream.write(byArray);
                        TimesTenShellComponent.this.outputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                keyEvent.consume();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        };
        this.addKeyListener(keyAdapter);
    }

    public TimesTenShellComponent(SSHShellChannel sSHShellChannel) {
        this(sSHShellChannel, 500, 400);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getCharHeight() {
        return this.charHeight;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public int getTerminalHeight() {
        return this.theight;
    }

    public int getTerminalWidth() {
        return this.twidth;
    }

    public void drawText(String string, int n, int n2) {
        this.graphics.setColor(this.getForeGroundColor());
        this.graphics.drawString(string, n, n2 - this.descent);
        if (this.bold) {
            this.graphics.drawString(string, n + 1, n2 - this.descent);
        }
        if (this.underlined) {
            this.graphics.drawLine(n, n2 - 1, n + string.length() * this.charWidth, n2 - 1);
        }
        this.graphics.setColor(this.getBackGroundColor());
    }

    public void cleanArea(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.getBackGroundColor());
        this.graphics.fillRect(n, n2, n3, n4);
        this.graphics.setColor(this.getForeGroundColor());
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.getForeGroundColor());
        this.graphics.drawBytes(byArray, n, n2, n3, n4 - this.descent);
        if (this.bold) {
            this.graphics.drawBytes(byArray, n, n2, n3 + 1, n4 - this.descent);
        }
        if (this.underlined) {
            this.graphics.drawLine(n3, n4 - 1, n3 + n2 * this.charWidth, n4 - 1);
        }
        this.graphics.setColor(this.getBackGroundColor());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
        int n = 0;
        if (this.bufferImage != null && this.currentNumberOfLines > 0) {
            graphics.drawImage(this.bufferImage, 0, 0, this.twidth, this.currentNumberOfLines * this.charHeight, 0, 0, this.twidth, this.currentNumberOfLines * this.charHeight, this);
            n = this.currentNumberOfLines * this.charHeight - this.charHeight;
        }
        if (this.img != null) {
            graphics.drawImage(this.img, 0, n, this);
            this.drawSelection((Graphics2D)graphics);
        }
    }

    public void redraw(int n, int n2, int n3, int n4) {
        if (this.currentNumberOfLines > 0) {
            this.repaint(n, n2 + this.currentNumberOfLines * this.charHeight - this.charHeight, n3, n4);
        } else {
            this.repaint(n, n2, n3, n4);
        }
    }

    public void setCursor(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void drawCursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.charHeight, this.charWidth, this.charHeight);
        this.repaint(this.x, this.currentNumberOfLines * this.charHeight + this.y - 2 * this.charHeight, this.charWidth, this.charHeight);
    }

    private void resetCursorGraphics() {
        if (this.cursor_graphics != null) {
            this.cursor_graphics.dispose();
        }
        this.cursor_graphics = (Graphics2D)this.img.getGraphics();
        this.cursor_graphics.setFont(this.font);
        this.cursor_graphics.setColor(this.foregroundColor);
        this.cursor_graphics.setXORMode(this.backgroundColor);
    }

    public void scrollArea(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs(n6 / this.charHeight);
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
        if (this.currentNumberOfLines + n7 >= 100) {
            this.bufferGraphics.copyArea(0, 0, this.getTerminalWidth(), this.bufferImage.getHeight(), n5, n6);
        }
        int n8 = this.charHeight * this.currentNumberOfLines;
        this.bufferGraphics.drawImage(this.img, 0, n8, this.getTerminalWidth(), n8 + n7 * this.charHeight, 0, 0, this.getTerminalWidth(), n7 * this.charHeight, this);
        if (this.currentNumberOfLines + n7 < 100) {
            this.currentNumberOfLines += n7;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doScroll();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TimesTenShellComponent.this.doScroll();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void doScroll() {
        Dimension dimension = new Dimension(this.getTerminalWidth(), this.getTerminalHeight() + this.charHeight * this.currentNumberOfLines - this.charHeight);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.revalidate();
        this.getParent().invalidate();
        this.repaint();
        this.scrollDown();
    }

    private void scrollDown() {
        Rectangle rectangle = new Rectangle(0, this.charHeight * this.currentNumberOfLines, this.getTerminalWidth(), this.getTerminalHeight());
        this.scrollRectToVisible(rectangle);
    }

    public void clear() {
        this.graphics.setColor(this.getBackGroundColor());
        this.graphics.fillRect(0, 0, this.getTerminalWidth(), this.getTerminalHeight());
        this.graphics.setColor(this.getForeGroundColor());
    }

    public Object getColor(int n) {
        if (this.colors == null || n < 0 || this.colors.length <= n) {
            return null;
        }
        return this.colors[n];
    }

    public void setUnderline(boolean bl) {
        this.underlined = bl;
    }

    public void setReverse(boolean bl) {
        this.reversed = true;
    }

    public void resetAllAttributes() {
        this.bold = false;
        this.underlined = false;
        this.reversed = false;
        this.backgroundColor = this.defaultBgColor;
        this.foregroundColor = this.defaultFgColor;
        if (this.graphics != null) {
            this.graphics.setColor(this.getForeGroundColor());
        }
    }

    public void setBold() {
        this.bold = true;
    }

    private Color getForeGroundColor() {
        if (this.reversed) {
            return this.backgroundColor;
        }
        return this.foregroundColor;
    }

    private Color getBackGroundColor() {
        if (this.reversed) {
            return this.foregroundColor;
        }
        return this.backgroundColor;
    }

    public void setTerminalColor(int n) {
        if (foregroundColors.get(n) != null) {
            this.foregroundColor = foregroundColors.get(n);
        } else if (backgroundColors.get(n) != null) {
            this.backgroundColor = backgroundColors.get(n);
        }
    }

    public void highlightRegion(int n, int n2, int n3, int n4) {
        for (int i = n2; i <= n4; ++i) {
            int n5 = n * this.charWidth;
            int n6 = i * this.charHeight;
            this.highlightGraphics.fillRect(n5, n6 - this.charHeight, this.twidth - n5, this.charHeight);
            this.repaint(n5, n6 - this.charHeight, this.twidth - n5, this.charHeight);
        }
    }

    public Point convertXYtoRowAndCols(Point point) {
        if (point.y > 0) {
            return this.convertXYtoRowAndCols(point.x, point.y + this.charHeight);
        }
        return this.convertXYtoRowAndCols(point.x, point.y);
    }

    public Point convertXYtoRowAndCols(int n, int n2) {
        int n3 = n / this.getCharWidth();
        int n4 = (n2 - this.getCharHeight()) / this.getCharHeight();
        return new Point(n3, n4);
    }

    public Point convertRowAndColstoXY(int n, int n2) {
        int n3 = n * this.getCharWidth();
        int n4 = n2 * this.getCharHeight();
        return new Point(n3, n4);
    }

    public void setBuffers(CurrentScreenBuffer currentScreenBuffer, PreviousLinesBuffer previousLinesBuffer) {
        this.screenBuffer = currentScreenBuffer;
        this.previousLinesBuffer = previousLinesBuffer;
    }

    public void drawSelection(Graphics2D graphics2D) {
        graphics2D.setColor(this.getForeGroundColor());
        graphics2D.setXORMode(this.getBackGroundColor());
        int n = this.shellMouseListener.getRealStartPoint();
        int n2 = this.shellMouseListener.getRealEndPoint();
        if (n != n2) {
            for (int i = n; i < n2; ++i) {
                Point point = this.screenBuffer.getMatrixPosition(i);
                this.drawOneSquare(graphics2D, point.x, point.y);
            }
        }
    }

    private Dimension getDimensionHelper() {
        return new Dimension(this.getTerminalWidth(), this.getTerminalHeight() - this.charHeight);
    }

    private void drawOneSquare(Graphics2D graphics2D, int n, int n2) {
        Point point = this.convertRowAndColstoXY(n, n2);
        graphics2D.fillRect(point.x, point.y, this.getCharWidth(), this.getCharHeight());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getDimensionHelper();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.charHeight;
        }
        return rectangle.width;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.charHeight;
        }
        return this.charWidth;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static {
        foregroundColors.put(30, Color.BLACK);
        foregroundColors.put(31, Color.RED);
        foregroundColors.put(32, Color.GREEN);
        foregroundColors.put(33, Color.YELLOW);
        foregroundColors.put(34, Color.BLUE);
        foregroundColors.put(35, Color.MAGENTA);
        foregroundColors.put(36, Color.CYAN);
        foregroundColors.put(37, Color.WHITE);
        backgroundColors = new HashMap();
        backgroundColors.put(40, Color.BLACK);
        backgroundColors.put(41, Color.RED);
        backgroundColors.put(42, Color.GREEN);
        backgroundColors.put(43, Color.YELLOW);
        backgroundColors.put(44, Color.BLUE);
        backgroundColors.put(45, Color.MAGENTA);
        backgroundColors.put(46, Color.CYAN);
        backgroundColors.put(47, Color.WHITE);
    }

    private class ShellSelectionAdapter
    extends MouseAdapter {
        private boolean dragging;
        private Point startPoint;
        private Point endPoint;
        private String lastSelectedString = null;
        private boolean endBigger;
        private int startPosition;
        private int endPosition;

        private ShellSelectionAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.dragging && mouseEvent.getButton() == 1) {
                this.startPoint = TimesTenShellComponent.this.convertXYtoRowAndCols(mouseEvent.getPoint());
                this.endPoint = TimesTenShellComponent.this.convertXYtoRowAndCols(mouseEvent.getPoint());
                this.dragging = true;
                this.lastSelectedString = null;
                this.startPosition = 0;
                this.endPosition = 0;
                TimesTenShellComponent.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.endPoint = TimesTenShellComponent.this.convertXYtoRowAndCols(mouseEvent.getPoint());
                this.startPosition = TimesTenShellComponent.this.screenBuffer.getLinearPosition(this.startPoint.y, this.startPoint.x);
                this.endPosition = TimesTenShellComponent.this.screenBuffer.getLinearPosition(this.endPoint.y, this.endPoint.x);
                this.endBigger = this.endPosition < this.startPosition;
                TimesTenShellComponent.this.repaint();
            }
        }

        public int getRealStartPoint() {
            if (this.endBigger) {
                return this.endPosition;
            }
            return this.startPosition;
        }

        public int getRealEndPoint() {
            if (this.endBigger) {
                return this.startPosition;
            }
            return this.endPosition;
        }

        public String getSelectedString() {
            if (this.startPoint != null && this.endPoint != null && !this.startPoint.equals(this.endPoint)) {
                String string = TimesTenShellComponent.this.previousLinesBuffer.getSelectedText(TimesTenShellComponent.this.getColumns(), this.startPoint, this.endPoint);
                Point point = new Point(this.startPoint);
                Point point2 = new Point(this.endPoint);
                if (this.startPoint.y - TimesTenShellComponent.this.currentNumberOfLines < 0) {
                    point.y = 0;
                    point.x = 0;
                } else if (TimesTenShellComponent.this.currentNumberOfLines > 0) {
                    point.y = this.startPoint.y - TimesTenShellComponent.this.currentNumberOfLines + 1;
                }
                if (this.endPoint.y - TimesTenShellComponent.this.currentNumberOfLines < 0) {
                    point2.x = 0;
                } else {
                    point2.y = TimesTenShellComponent.this.currentNumberOfLines > 0 ? this.endPoint.y - TimesTenShellComponent.this.currentNumberOfLines + 1 : this.endPoint.y + 1;
                }
                String string2 = TimesTenShellComponent.this.screenBuffer.getString(point, point2);
                if (!string.isEmpty() && !string2.isEmpty()) {
                    return string + string2;
                }
                if (!string.isEmpty() && string2.isEmpty()) {
                    return string;
                }
                if (string.isEmpty() && !string2.isEmpty()) {
                    return string2;
                }
            }
            return "";
        }
    }
}

