/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell.buffer;

import java.awt.Point;
import java.util.LinkedList;

public class PreviousLinesBuffer {
    private int maxNumberOfLines;
    private LinkedList<String> lines;

    public PreviousLinesBuffer(int n) {
        this.maxNumberOfLines = n;
        this.lines = new LinkedList();
    }

    public void appendLine(String string) {
        if (this.lines.size() >= this.maxNumberOfLines) {
            this.lines.removeFirst();
        }
        this.lines.add(string);
    }

    public String getSelectedText(int n, Point point, Point point2) {
        Point point3 = point;
        Point point4 = point2;
        if (point.y > point2.y) {
            point3 = point2;
            point4 = point;
        }
        if (point.y == point2.y && point.x > point2.x) {
            point3 = point2;
            point4 = point;
        }
        if (point3.y > this.maxNumberOfLines) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = point3.y; i <= point4.y && i < this.lines.size() - 1; ++i) {
            String string = this.lines.get(i);
            if (i == point3.y) {
                if (point3.x == point4.x) {
                    stringBuffer.append(string.substring(point3.x, point4.x));
                    continue;
                }
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void removeLines(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.lines.isEmpty()) continue;
            this.lines.removeLast();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.lines) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

