/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.ExportImportPanel;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttributesUtil;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.GridNodeManager;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConfigObject;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.DataSpaceGroupObject;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.grid.object.SiteObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.dbtools.raptor.timesten.grid.topology.Topology;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.data.HashStructure;

public class GridObject
extends TTGridObject {
    public static final String GRIDNAME_KEY = "gridname";
    public static final String HOST_KEY = "host";
    public static final String INSTANCEHOME_KEY = "instancehome";
    public static final String OS_KEY = "os";
    public static final String TTENV_KEY = "ttenv";
    public static final String TMPDIR_KEY = "tmpdir";
    public static final String FILESEPARATOR_KEY = "fileseparator";
    public static final String INSTANCEADMIN_KEY = "instanceadmin";
    public static final String SAVEPWD_KEY = "savepwd";
    public static final String PWD_KEY = "pwd";
    public static final String KEYFILE_KEY = "keyfile";
    private ModelVersion showingVersion;
    private List<DatabaseObject> databases;
    private List<DBDefObject> dbdefList;
    private List<HostObject> hosts;
    private List<SiteObject> sites;
    private List<PhysicalGroupObject> physicalGroups;
    private List<DataSpaceGroupObject> dataSpaceGroups;
    private List<RepositoryObject> repositories;
    private ConfigObject membershipConfig;
    private ConfigObject instanceConfig;
    private ConfigObject sqlNet;
    private ConfigObject tnsNames;
    private GridObject gridCurrentModel;
    private GridNodeManager gridNodeMgr;
    private GridProperties gridProperties;
    private GridCommandExecutor executor;
    private DBDefAttributesUtil attributesUtil;
    private String shortName;
    private boolean savePassword;
    private boolean populated;
    private boolean populating;
    private boolean hasDBStatus;
    private static final Logger logger = Logger.getLogger(GridObject.class.getName());

    public GridCommandExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(GridCommandExecutor gridCommandExecutor) {
        this.executor = gridCommandExecutor;
    }

    public GridObject(String string, GridCommandExecutor gridCommandExecutor) {
        this(string, gridCommandExecutor, true);
    }

    public GridObject(String string, GridCommandExecutor gridCommandExecutor, boolean bl) {
        this.executor = gridCommandExecutor;
        this.showingVersion = ModelVersion.LATEST;
        this.initialize();
        if (bl) {
            this.setName(string);
        } else {
            this.name = string;
            this.shortName = string.substring(string.indexOf("@") + 1);
            this.gridNodeMgr.setGridName(string);
        }
    }

    public void setCurrentModel(JsonObject jsonObject) {
        if (this.gridCurrentModel == null) {
            this.gridCurrentModel = new GridObject(this.getName() + "_current", this.executor);
        }
        this.gridCurrentModel.setGridComponents(jsonObject, false);
    }

    public GridObject getGridCurrentModel() {
        return this.gridCurrentModel;
    }

    private void initialize() {
        this.gridProperties = new GridProperties();
        this.databases = new ArrayList<DatabaseObject>();
        this.hosts = new ArrayList<HostObject>();
        this.sites = new ArrayList<SiteObject>();
        this.physicalGroups = new ArrayList<PhysicalGroupObject>();
        this.repositories = new ArrayList<RepositoryObject>();
        this.dataSpaceGroups = new ArrayList<DataSpaceGroupObject>();
        this.attributesUtil = new DBDefAttributesUtil();
        this.membershipConfig = new ConfigObject(ExportImportPanel.ExportImportObject.MEMBERSHIP_CONFIGURATION, "");
        this.instanceConfig = new ConfigObject(ExportImportPanel.ExportImportObject.INSTANCE_CONFIGURATION, "");
        this.sqlNet = new ConfigObject(ExportImportPanel.ExportImportObject.SQLNET, null);
        this.tnsNames = new ConfigObject(ExportImportPanel.ExportImportObject.TNS_NAMES, null);
        this.dbdefList = new ArrayList<DBDefObject>();
        this.populated = false;
        this.hasDBStatus = false;
        this.savePassword = false;
        this.gridNodeMgr = new GridNodeManager(this.name);
    }

    public boolean isPopulating() {
        return this.populating;
    }

    public void setPopulating(boolean bl) {
        this.populating = bl;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public boolean hasDBStatus() {
        return this.hasDBStatus;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean bl) {
        this.savePassword = bl;
    }

    public String getShortName() {
        return this.shortName;
    }

    public GridProperties getProperties() {
        return this.gridProperties;
    }

    public List<DatabaseObject> getDatabases() {
        return this.databases;
    }

    public List<DatabaseObject> getCreatedDatabases() {
        ArrayList<DatabaseObject> arrayList = new ArrayList<DatabaseObject>();
        for (DatabaseObject databaseObject : this.databases) {
            if (!databaseObject.isStatusAvailable()) continue;
            arrayList.add(databaseObject);
        }
        return arrayList;
    }

    public List<DBDefObject> getDBDefs() {
        return this.dbdefList;
    }

    public List<HostObject> getHosts() {
        return this.hosts;
    }

    public int getNumberOfDataInstances() {
        int n = 0;
        for (HostObject hostObject : this.hosts) {
            n += hostObject.getDataInstances().size();
        }
        return n;
    }

    public int getNumberOfMgmtInstances() {
        int n = 0;
        for (HostObject hostObject : this.hosts) {
            n += hostObject.getInstances().size() - hostObject.getDataInstances().size();
        }
        return n;
    }

    public List<SiteObject> getSites() {
        return this.sites;
    }

    public List<PhysicalGroupObject> getPhysicalGroups() {
        return this.physicalGroups;
    }

    public List<RepositoryObject> getRrepositories() {
        return this.repositories;
    }

    public List<DataSpaceGroupObject> getDataSpaceGroups() {
        return this.dataSpaceGroups;
    }

    public ConfigObject getMembershipConfiguration() {
        return this.membershipConfig;
    }

    public ConfigObject getInstanceConfiguration() {
        return this.instanceConfig;
    }

    public ConfigObject getSQLNet() {
        return this.sqlNet;
    }

    public ConfigObject getTNSNames() {
        return this.tnsNames;
    }

    public GridNodeManager getGridNode() {
        return this.gridNodeMgr;
    }

    public PhysicalGroupObject getPhysicalGroup(String string) {
        for (PhysicalGroupObject physicalGroupObject : this.physicalGroups) {
            if (!physicalGroupObject.getName().equalsIgnoreCase(string)) continue;
            return physicalGroupObject;
        }
        return null;
    }

    public RepositoryObject getRepository(String string) {
        for (RepositoryObject repositoryObject : this.repositories) {
            if (!repositoryObject.getName().equalsIgnoreCase(string)) continue;
            return repositoryObject;
        }
        return null;
    }

    public SiteObject getSite(String string) {
        for (SiteObject siteObject : this.sites) {
            if (!siteObject.getName().equalsIgnoreCase(string)) continue;
            return siteObject;
        }
        return null;
    }

    public DataSpaceGroupObject getDSG(String string) {
        for (DataSpaceGroupObject dataSpaceGroupObject : this.dataSpaceGroups) {
            if (!dataSpaceGroupObject.getName().equalsIgnoreCase(string)) continue;
            return dataSpaceGroupObject;
        }
        return null;
    }

    public void addSite(SiteObject siteObject) {
        this.sites.add(siteObject);
    }

    public void addDataSpaceGroup(DataSpaceGroupObject dataSpaceGroupObject) {
        this.dataSpaceGroups.add(dataSpaceGroupObject);
    }

    public boolean existHost(String string) {
        for (HostObject hostObject : this.hosts) {
            if (!hostObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public HostObject getHost(String string) {
        for (HostObject hostObject : this.hosts) {
            if (!hostObject.getName().equals(string)) continue;
            return hostObject;
        }
        return null;
    }

    public List<InstanceObject> getAllDataInstances() {
        ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        for (HostObject hostObject : this.getHosts()) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (!instanceObject.isAppliedToCurrent() || instanceObject.isMgmtInstance()) continue;
                arrayList.add(instanceObject);
            }
        }
        return arrayList;
    }

    public List<InstanceObject> getAllMgmtInstances() {
        ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        for (HostObject hostObject : this.getHosts()) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (!instanceObject.isAppliedToCurrent() || !instanceObject.isMgmtInstance()) continue;
                arrayList.add(instanceObject);
            }
        }
        return arrayList;
    }

    public List<InstanceObject> getAllMgmtInstancesInLatest() {
        ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        for (HostObject hostObject : this.getHosts()) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (!instanceObject.isMgmtInstance()) continue;
                arrayList.add(instanceObject);
            }
        }
        return arrayList;
    }

    public InstanceObject getInstance(HostObject hostObject, String string) {
        for (InstanceObject instanceObject : hostObject.getInstances()) {
            if (!instanceObject.getName().equals(string)) continue;
            return instanceObject;
        }
        return null;
    }

    public InstanceObject getInstance(String string, String string2) {
        for (InstanceObject instanceObject : this.getHost(string).getInstances()) {
            if (!instanceObject.getName().equals(string2)) continue;
            return instanceObject;
        }
        return null;
    }

    public InstanceObject getInstance(String string) {
        String string2 = string.substring(0, string.lastIndexOf("."));
        String string3 = string.substring(string.lastIndexOf(".") + 1);
        for (InstanceObject instanceObject : this.getHost(string2).getInstances()) {
            if (!instanceObject.getName().equals(string3)) continue;
            return instanceObject;
        }
        return null;
    }

    public DatabaseObject getDatabase(String string) {
        for (DatabaseObject databaseObject : this.databases) {
            if (!databaseObject.getName().equalsIgnoreCase(string)) continue;
            return databaseObject;
        }
        return null;
    }

    public DBDefObject getDBDef(String string) {
        for (DBDefObject dBDefObject : this.dbdefList) {
            if (!string.equalsIgnoreCase(dBDefObject.getName())) continue;
            return dBDefObject;
        }
        return null;
    }

    public String getAvailableHostName() {
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = "";
        for (HostObject hostObject : this.hosts) {
            arrayList.add(hostObject.getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.contains(object = HOST_KEY + n++)) continue;
            return object;
        }
        return HOST_KEY + n;
    }

    @Override
    public void setName(String string) {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(string);
        this.name = gridObject != null && gridObject != this ? string + "@" + this.executor.getWorkingHost().getHostName() + "." + this.executor.getWorkingHost().getInstanceName() : string;
        this.gridNodeMgr.setGridName(this.name + " " + MessageFormat.format(Messages.getString("TimesTenGrid.modelVer"), this.showingVersion == ModelVersion.LATEST ? Messages.getString("TimesTenGrid.latest") : Messages.getString("TimestenTable.current")));
        this.shortName = string;
        this.gridNodeMgr.getShellNode().setLongLabel(string);
        this.gridNodeMgr.getShellNode().setShortLabel(string);
    }

    public ModelVersion getShowingVersion() {
        return this.showingVersion;
    }

    public void setShowingVersion(ModelVersion modelVersion) {
        this.showingVersion = modelVersion;
    }

    public void setGridComponents(JsonObject jsonObject, boolean bl) throws JsonException {
        try {
            Object object;
            Iterator iterator2;
            Object object22;
            this.gridProperties.setGridProperties(jsonObject);
            this.GUID = this.gridProperties.getGuid();
            int n = this.getProperties().getK();
            this.attributesUtil.loadAttributes(n);
            this.gridNodeMgr.clear();
            JsonArray jsonArray = jsonObject.getJsonArray("physicalGroups");
            this.physicalGroups.clear();
            for (Object object22 : jsonArray.getValuesAs(JsonObject.class)) {
                iterator2 = new PhysicalGroupObject(object22.getString("name"));
                this.physicalGroups.add((PhysicalGroupObject)((Object)iterator2));
                this.gridNodeMgr.addPhysicalGroupNode((PhysicalGroupObject)((Object)iterator2));
            }
            jsonArray = jsonObject.getJsonArray("sites");
            this.sites.clear();
            for (Object object22 : jsonArray.getValuesAs(JsonObject.class)) {
                iterator2 = new SiteObject(object22.getString("name"));
                this.addSite((SiteObject)((Object)iterator2));
            }
            try {
                jsonArray = jsonObject.getJsonArray("membershipConfig");
                this.membershipConfig.setContent(jsonArray != null && jsonArray.size() > 0 ? this.getStringFromJsonArray(jsonArray) : "");
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "No membership configuration found: " + exception.getMessage());
                this.membershipConfig.setContent("");
            }
            try {
                jsonArray = jsonObject.getJsonArray("instanceConfig");
                this.instanceConfig.setContent(jsonArray != null && jsonArray.size() > 0 ? this.getStringFromJsonArray(jsonArray) : "");
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "No instance configuration found: " + exception.getMessage());
                this.instanceConfig.setContent("");
            }
            try {
                jsonArray = jsonObject.getJsonArray("SQLNet");
                this.sqlNet.setContent(jsonArray != null && jsonArray.size() > 0 ? this.getStringFromJsonArray(jsonArray) : "");
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "No SQLNet found: " + exception.getMessage());
                this.sqlNet.setContent("");
            }
            try {
                jsonArray = jsonObject.getJsonArray("TNSNames");
                this.tnsNames.setContent(jsonArray != null && jsonArray.size() > 0 ? this.getStringFromJsonArray(jsonArray) : "");
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "No TNSNames found: " + exception.getMessage());
                this.tnsNames.setContent("");
            }
            this.gridNodeMgr.addConfigNodes(this);
            jsonArray = jsonObject.getJsonArray("dataSpaceGroups");
            this.dataSpaceGroups.clear();
            for (Object object22 : jsonArray.getValuesAs(JsonObject.class)) {
                iterator2 = new DataSpaceGroupObject(object22.getString("name"));
                this.addDataSpaceGroup((DataSpaceGroupObject)((Object)iterator2));
            }
            jsonArray = jsonObject.getJsonArray("hosts");
            this.hosts.clear();
            String string = this.executor.getWorkingHost().getIPaddress();
            for (Iterator iterator2 : jsonArray.getValuesAs(JsonObject.class)) {
                HostObject hostObject = new HostObject();
                hostObject.setHostModel((JsonObject)iterator2, this.getPhysicalGroups());
                this.hosts.add(hostObject);
                this.gridNodeMgr.addHostNode(hostObject);
            }
            object22 = null;
            try {
                object22 = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                logger.log(Level.INFO, unknownHostException.getMessage());
            }
            for (HostObject hostObject : this.hosts) {
                try {
                    object = InetAddress.getByName(hostObject.getExternalAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    logger.log(Level.INFO, unknownHostException.getMessage());
                    continue;
                }
                if (!((InetAddress)object22).getHostAddress().equalsIgnoreCase(((InetAddress)object).getHostAddress())) continue;
                this.executor.getWorkingHost().setHostName(hostObject.getName());
            }
            this.setName(jsonObject.getString("gridName"));
            jsonArray = jsonObject.getJsonArray("dbdefs");
            this.databases.clear();
            this.dbdefList.clear();
            for (HostObject hostObject : jsonArray.getValuesAs(JsonObject.class)) {
                object = hostObject.getString("name");
                if (object == null || ((String)object).equalsIgnoreCase("TTGRIDADMIN")) continue;
                DBDefObject dBDefObject = new DBDefObject(this, null);
                dBDefObject.setName((String)object);
                dBDefObject.setDBDefModel((JsonObject)hostObject);
                this.dbdefList.add(dBDefObject);
                DatabaseObject databaseObject = new DatabaseObject(this, dBDefObject, (String)object);
                this.databases.add(databaseObject);
                this.gridNodeMgr.addDatabaseNode(dBDefObject);
            }
            if (bl) {
                TTGridRootNode.getStorage().saveGrid(this);
            }
            this.updateSuggestions();
            this.populated = true;
            this.populating = false;
            this.getRepositoryData();
        }
        catch (Exception exception) {
            if (exception instanceof JsonException) {
                throw (JsonException)((Object)exception);
            }
            throw new JsonException(exception.getMessage());
        }
    }

    public void setRepositoriesInfo(JsonObject jsonObject) {
        this.repositories.clear();
        JsonArray jsonArray = jsonObject.getJsonArray("repositories");
        for (JsonValue jsonValue : jsonArray) {
            JsonObject jsonObject2 = (JsonObject)jsonValue;
            RepositoryObject repositoryObject = new RepositoryObject(jsonObject2);
            this.repositories.add(repositoryObject);
            this.gridNodeMgr.addRepositoryNode(repositoryObject);
        }
    }

    private void updateSuggestions() {
        for (PhysicalGroupObject tTGridObject : this.getPhysicalGroups()) {
            tTGridObject.updateSuggestions();
        }
        for (HostObject hostObject : this.getHosts()) {
            hostObject.updateSuggestions();
            for (InstallationObject installationObject : hostObject.getInstallations()) {
                installationObject.updateSuggestions();
            }
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                instanceObject.updateSuggestions();
            }
        }
        for (RepositoryObject repositoryObject : this.getRrepositories()) {
            repositoryObject.updateSuggestions();
        }
        TTGridRootNode.getStorage().saveSuggestion("adminGroup", this.getProperties().getAdminGroup());
    }

    public static List<String> getAdminGroupSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("adminGroup");
    }

    private String getStringFromJsonArray(JsonArray jsonArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            stringBuilder.append(jsonArray.getString(i));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean updateHostModel(JsonObject jsonObject, String string) {
        boolean bl = false;
        JsonArray jsonArray = jsonObject.getJsonArray("hosts");
        for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
            HostObject hostObject = this.getHost(jsonObject2.getString("name"));
            if (hostObject == null || !hostObject.getName().equalsIgnoreCase(string)) continue;
            hostObject.setHostModel(jsonObject2, this.getPhysicalGroups());
            bl = true;
            break;
        }
        return bl;
    }

    public boolean updateMgmInstancesModel(JsonObject jsonObject) {
        boolean bl = false;
        JsonArray jsonArray = jsonObject.getJsonArray("instances");
        JsonObject jsonObject2 = jsonObject.getJsonObject("STANDBY".toLowerCase());
        for (JsonObject jsonObject3 : jsonArray.getValuesAs(JsonObject.class)) {
            InstanceObject instanceObject = this.getInstance(jsonObject3.getString(HOST_KEY), jsonObject3.getString("instance"));
            String string = "";
            try {
                string = jsonObject3.getString("ttRepStateGet");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (instanceObject == null) {
                logger.warning("Management instance from ttGridAdmin mgmtExamine not found in SQLDeveloper grid model" + jsonObject3.getString(HOST_KEY) + "." + jsonObject3.getString("instance"));
                continue;
            }
            if (string.equals("ACTIVE")) {
                instanceObject.setType(InstanceObject.ManagementInstanceRole.ACTIVE);
            } else if (string.equals("STANDBY")) {
                instanceObject.setType(InstanceObject.ManagementInstanceRole.STANDBY);
            } else if (string.equals("IDLE") && jsonArray.size() == 1) {
                instanceObject.setType(InstanceObject.ManagementInstanceRole.ACTIVE);
            } else if (jsonObject2 != null) {
                String string2;
                String string3 = jsonObject3.getString(HOST_KEY) + "." + jsonObject3.getString("instance");
                if (string3.equals(string2 = jsonObject2.getString(HOST_KEY) + "." + jsonObject2.getString("instance"))) {
                    instanceObject.setType(InstanceObject.ManagementInstanceRole.DOWN);
                }
            } else {
                instanceObject.setType(InstanceObject.ManagementInstanceRole.UNKNOWN);
            }
            if (jsonArray.size() > 1) {
                if (jsonObject3.containsKey((Object)"repStarted")) {
                    instanceObject.setRepAgentStatus(jsonObject3.getBoolean("repStarted") ? Common.RepAgentStatus.UP : Common.RepAgentStatus.DOWN);
                } else {
                    instanceObject.setRepAgentStatus(Common.RepAgentStatus.DOWN);
                }
            }
            bl = true;
        }
        return bl;
    }

    public boolean updateDatabase(JsonObject jsonObject, String string) {
        boolean bl = false;
        try {
            JsonArray jsonArray = jsonObject.getJsonArray("dbdefs");
            for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
                String string2 = jsonObject2.getString("name");
                if (string2 != null && (string2.equalsIgnoreCase("TTGRIDADMIN") || !string2.equalsIgnoreCase(string))) continue;
                bl = true;
                DatabaseObject databaseObject = this.findDB(string);
                databaseObject.getDBDef().setDBDefModel(jsonObject2);
                break;
            }
        }
        catch (Exception exception) {
            logger.severe("There was an error while updating the database" + string + ":model[" + jsonObject.toString() + "]");
        }
        return bl;
    }

    private DatabaseObject findDB(String string) {
        for (DatabaseObject databaseObject : this.databases) {
            if (!string.equalsIgnoreCase(databaseObject.getName())) continue;
            return databaseObject;
        }
        return null;
    }

    public DBDefAttributesUtil getAttributesUtil() {
        return this.attributesUtil;
    }

    public List<String> getAllDataInstanceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HostObject hostObject : this.hosts) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (instanceObject.isMgmtInstance()) continue;
                arrayList.add(instanceObject.getFullName());
            }
        }
        return arrayList;
    }

    public void updateDatabasesConnectionCountOnRaptorTask(final DatabaseObject databaseObject, final Runnable runnable) {
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Boolean doWork() throws TaskException {
                block3: {
                    try {
                        GridCommand gridCommand = GridCommand.DB_STATUS;
                        gridCommand.prepareCommand(databaseObject.getName());
                        JsonObject jsonObject = GridObject.this.executor.executeCommandGetJson(gridCommand, true);
                        databaseObject.updateDBStatus(jsonObject);
                        GridObject.this.updateDatabasesConnections(true);
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    catch (GridCommandException gridCommandException) {
                        if (GridObject.this.isDBNotExistError(gridCommandException.getMessage(), databaseObject.getName())) break block3;
                        logger.log(Level.INFO, gridCommandException.getMessage());
                    }
                }
                return true;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateDBInfoTask"), databaseObject.getName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void updateDatabasesConnections(boolean bl) throws GridCommandException {
        boolean bl2 = Common.gridVersionGreaterThanOrEqual(this, "18.1.1.3.0");
        if (bl2) {
            if (!this.getCreatedDatabases().isEmpty()) {
                this.updateDatabasesConnectionsWithDbStatus();
            }
        } else {
            this.updateDatabasesConnectionsWithQuery(bl);
        }
    }

    private void updateDatabasesConnectionsWithQuery(boolean bl) throws GridCommandException {
        DatabaseObject databaseObject = this.getOneLoadedDB();
        if (databaseObject == null) {
            databaseObject = this.getOnePartiallyLoadedDB();
        }
        if (databaseObject == null) {
            logger.warning("There are no databases that can be used for fetching connection data");
            for (DatabaseObject databaseObject2 : this.getDatabases()) {
                databaseObject2.resetConnectionDetails();
            }
        } else {
            List<InstanceObject> list = this.getDistributedInstances();
            if (list.isEmpty()) {
                logger.warning("There are no instances distributed on all databases.");
                this.updateConnectionDataPerDBWithQuery(bl);
                return;
            }
            GridCommandExecutor.ExecOutput execOutput = null;
            for (InstanceObject object : list) {
                GridCommandExecutor.ExecOutput execOutput2 = this.getExecutor().getConnectionInfo(object.getFullName(), Common.UPDATE_CONN_TIMEOUT, databaseObject.getName(), "SQLDEV_SEL_GVDATASTORE", bl);
                if (execOutput2.getExitCode() != 0) continue;
                execOutput = execOutput2;
                break;
            }
            if (execOutput == null) {
                logger.warning("No instance completed datastore_status query successfuly.");
                return;
            }
            if (bl) {
                Iterator<DatabaseObject> iterator = GridObject.getConnectionCountMap(execOutput.getOutput());
                for (DatabaseObject databaseObject2 : this.getDatabases()) {
                    int[] nArray = (int[])iterator.get(databaseObject2.getName());
                    if (databaseObject2.getName().equalsIgnoreCase(databaseObject.getName())) {
                        if (nArray != null) {
                            if (nArray[1] > 0) {
                                nArray[1] = nArray[1] - 1;
                            } else {
                                logger.warning("Application connection count <" + nArray[1] + "> is less than the minum expected count of 1");
                            }
                        } else {
                            logger.warning("Cannot get connection count from database " + databaseObject2.getName());
                        }
                    }
                    databaseObject2.updateConnectionCount(nArray);
                }
            } else {
                for (DatabaseObject databaseObject3 : this.getDatabases()) {
                    databaseObject3.updateConnectionDetailsWithQuery(execOutput.getOutput());
                }
            }
        }
    }

    private void updateDatabasesConnectionsWithDbStatus() throws GridCommandException {
        String string = this.getExecutor().executeCommandGetString(GridCommand.DB_STATUS_CONNECTIONS, false);
        String string2 = this.getExecutor().executeCommandGetString(GridCommand.DB_STATUS_CONNECTIONS_PROXY, false);
        for (DatabaseObject databaseObject : this.getDatabases()) {
            databaseObject.updateConnectionDetailsWithDBStatus(string, string2);
        }
    }

    private void updateConnectionDataPerDBWithQuery(boolean bl) throws GridCommandException {
        for (DatabaseObject databaseObject : this.databases) {
            if (!databaseObject.isStatusAvailable() || !databaseObject.getDBStatus().isLoaded() && !databaseObject.getDBStatus().isPartiallyLoaded()) continue;
            GridCommandExecutor.ExecOutput execOutput = null;
            for (Element element : databaseObject.getElementInDistMap()) {
                try {
                    GridCommandExecutor.ExecOutput execOutput2 = this.getExecutor().getConnectionInfo(element.getInstance().getFullName(), Common.UPDATE_CONN_TIMEOUT, databaseObject.getName(), "SQLDEV_SEL_GVDATASTORE", bl);
                    if (execOutput2.getExitCode() != 0) continue;
                    execOutput = execOutput2;
                    break;
                }
                catch (GridCommandException gridCommandException) {
                    logger.warning(gridCommandException.getMessage());
                }
            }
            if (execOutput == null) {
                logger.severe("No instance completed 'datastore_status' query successfuly for database " + databaseObject.getName());
                continue;
            }
            if (bl) {
                Map<String, int[]> map = GridObject.getConnectionCountMap(execOutput.getOutput());
                int[] nArray = (int[])map.get(databaseObject.getName());
                if (nArray != null) {
                    if (nArray[1] > 0) {
                        nArray[1] = nArray[1] - 1;
                    } else {
                        logger.warning("Application connection count <" + nArray[1] + "> is less than the minum expected count of 1");
                    }
                } else {
                    logger.warning("Cannot get connection count from database " + databaseObject.getName());
                }
                databaseObject.updateConnectionCount(nArray);
                continue;
            }
            databaseObject.updateConnectionDetailsWithQuery(execOutput.getOutput());
        }
    }

    private List<InstanceObject> getDistributedInstances() {
        List<InstanceObject> list = this.getAllDataInstances();
        int[] nArray = new int[list.size()];
        ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        for (DatabaseObject databaseObject : this.databases) {
            for (Element element : databaseObject.getElementInDistMap()) {
                int n = list.indexOf(element.getInstance());
                if (n < 0) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            if (nArray[i] != this.databases.size()) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    private DatabaseObject getOneLoadedDB() {
        for (DatabaseObject databaseObject : this.getDatabases()) {
            if (!databaseObject.isStatusAvailable() || !databaseObject.getDBStatus().isLoaded()) continue;
            return databaseObject;
        }
        return null;
    }

    private DatabaseObject getOnePartiallyLoadedDB() {
        for (DatabaseObject databaseObject : this.getDatabases()) {
            if (!databaseObject.isStatusAvailable() || !databaseObject.getDBStatus().isPartiallyLoaded()) continue;
            return databaseObject;
        }
        return null;
    }

    public static Map<String, int[]> getConnectionCountMap(String string) {
        if (string == null) {
            logger.severe("Cannot parse GV$datastore output");
            return null;
        }
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        String string2 = "<(.*),.*[\\/\\\\](.*),([0-9\\s]+)>";
        Matcher matcher = Pattern.compile(string2).matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1).trim();
            String string4 = matcher.group(2).trim();
            int n = Integer.parseInt(matcher.group(3).trim());
            int[] nArray3 = new int[2];
            if (DatabaseObject.ElementConnection.isAppConnection(string3)) {
                nArray3[1] = n;
            }
            nArray3[0] = n;
            hashMap.merge(string4, nArray3, (nArray, nArray2) -> new int[]{nArray[0] + nArray2[0], nArray[1] + nArray2[1]});
        }
        return hashMap;
    }

    public void updateDatabasesStatus() throws GridCommandException, JsonException {
        this.updateDatabasesStatus(null);
    }

    public void updateDatabasesStatus(DatabaseObject databaseObject) throws GridCommandException, JsonException {
        GridCommand gridCommand;
        if (this.databases.isEmpty()) {
            return;
        }
        HashSet<DatabaseObject> hashSet = new HashSet<DatabaseObject>();
        if (databaseObject == null) {
            gridCommand = GridCommand.DBS_STATUS;
        } else {
            gridCommand = GridCommand.DB_STATUS;
            gridCommand.prepareCommand(databaseObject.getName());
        }
        JsonObject jsonObject = this.executor.executeCommandGetJson(gridCommand, true);
        JsonArray jsonArray = jsonObject.getJsonArray("databases");
        for (JsonObject object : jsonArray.getValuesAs(JsonObject.class)) {
            DatabaseObject databaseObject2 = this.findDB(object.getString("name"));
            if (databaseObject2 == null) continue;
            databaseObject2.updateDBStatus(object);
            hashSet.add(databaseObject2);
        }
        if (databaseObject == null) {
            for (DatabaseObject databaseObject3 : this.getDatabases()) {
                if (hashSet.contains(databaseObject3)) continue;
                databaseObject3.getDBStatus().setNonExistent(true);
            }
        }
        this.hasDBStatus = true;
    }

    public HashStructure toHashStructure() {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString(GRIDNAME_KEY, this.name);
        hashStructure.putString(HOST_KEY, this.executor.getWorkingHost().getIPaddress());
        hashStructure.putString(INSTANCEHOME_KEY, this.executor.getWorkingHost().getInstanceHome());
        hashStructure.putString(TTENV_KEY, this.executor.getWorkingHost().getSystemInfo().getTTEnvPath());
        hashStructure.putString(OS_KEY, this.executor.getWorkingHost().getSystemInfo().getOSName());
        hashStructure.putString(TMPDIR_KEY, this.executor.getWorkingHost().getSystemInfo().getTmpDir());
        hashStructure.putString(FILESEPARATOR_KEY, this.executor.getWorkingHost().getSystemInfo().getFileSeparator());
        hashStructure.putString(INSTANCEADMIN_KEY, this.executor.getWorkingHost().getInstanceAdmin());
        hashStructure.putBoolean(SAVEPWD_KEY, this.savePassword);
        if (!this.savePassword) {
            hashStructure.putString(PWD_KEY, null);
        } else {
            hashStructure.putString(PWD_KEY, new String(this.executor.getWorkingHost().getPwd()));
        }
        hashStructure.putString(KEYFILE_KEY, this.executor.getWorkingHost().getKeyFile());
        return hashStructure;
    }

    public JsonObject getSynchronizedWithModel(Boolean bl) throws GridCommandException {
        GridCommand gridCommand = this.showingVersion == ModelVersion.LATEST ? GridCommand.EXPORT_MODEL : GridCommand.EXPORT_CURRENTMODEL;
        return this.executor.executeCommandGetJson(gridCommand, bl, null);
    }

    public void executeCommandOnRaptorTask(String string, final GridCommand gridCommand, final Runnable runnable, final boolean bl) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    GridObject.this.getExecutor().executeCommandGetString(gridCommand, true);
                    if (runnable != null) {
                        if (!SwingUtilities.isEventDispatchThread() && bl) {
                            try {
                                SwingUtilities.invokeAndWait(runnable);
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                logger.log(Level.INFO, exception.getMessage());
                            }
                        } else {
                            runnable.run();
                        }
                    }
                }
                catch (GridCommandException gridCommandException) {
                    if (GridCommand.CREATE_DATABASE == gridCommand) {
                        Common.displayErrorMsg(null, gridCommandException.getMessage());
                        logger.severe(gridCommandException.getMessage());
                    }
                    Common.displayErrorMsg(null, gridCommandException.getMessage());
                    logger.severe(gridCommandException.getMessage());
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void executeSimpleCommandOnRaptorTask(String string, final GridCommand gridCommand, final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    GridObject.this.getExecutor().executeSimpleCommand(gridCommand);
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                catch (GridCommandException gridCommandException) {
                    Common.displayErrorMsg(null, gridCommandException.getMessage());
                    logger.severe(gridCommandException.getMessage());
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void executePerlCommandOnRaptorTask(String string, final GridCommand gridCommand, final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    GridObject.this.getExecutor().executePerlScriptCommand(gridCommand, null);
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                catch (GridCommandException gridCommandException) {
                    if (GridCommand.PERL_CREATE_DATABASE_FROM_DBDEF == gridCommand) {
                        Common.displayErrorMsg(null, Messages.getString("TimesTenGrid.DBCreateError"));
                        logger.severe(gridCommandException.getMessage());
                    }
                    Common.displayErrorMsg(null, gridCommandException.getMessage());
                    logger.severe(gridCommandException.getMessage());
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void executePerlOnSwingWorker(String string, String string2, final GridCommand gridCommand, final String string3, final String string4) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), string, string2, null);
        customProgressMonitor.setCancellable(false);
        customProgressMonitor.setCloseOnFinish(false);
        customProgressMonitor.setGridCommandExecutor(this.getExecutor());
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                customProgressMonitor.start();
                try {
                    GridObject.this.getExecutor().executePerlScriptCommand(gridCommand, new OutputStream(){
                        private StringBuffer perlOutput = new StringBuffer();

                        @Override
                        public void write(int n) throws IOException {
                            try {
                                SwingUtilities.invokeAndWait(() -> {
                                    if ((char)n == '\n') {
                                        this.firePropertyChange("message", null, this.perlOutput.substring(0, this.perlOutput.length()));
                                        this.perlOutput.setLength(0);
                                    } else {
                                        this.perlOutput.append(Character.toString((char)n));
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                logger.log(Level.SEVERE, exception.getMessage());
                                this.firePropertyChange("message", null, string4);
                            }
                        }
                    });
                    this.firePropertyChange("message", null, string3);
                }
                catch (GridCommandException gridCommandException) {
                    logger.log(Level.SEVERE, gridCommandException.getMessage());
                    this.firePropertyChange("message", null, string4);
                }
                this.firePropertyChange("progress", null, 100);
                return null;
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public void updateDBStatusOnRaptorTask(final DatabaseObject databaseObject, final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                block3: {
                    try {
                        GridObject.this.updateDatabasesStatus(databaseObject);
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    catch (JsonException | GridCommandException throwable) {
                        if (GridObject.this.isDBNotExistError(throwable.getMessage(), databaseObject.getName())) break block3;
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), throwable.getMessage());
                        logger.severe(throwable.getMessage());
                    }
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.updateDBStatus"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void updateDBConnectionsOnSwingWorker(DatabaseObject databaseObject, final Runnable runnable) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.updateDBInfoTask"), databaseObject.getName()), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                customProgressMonitor.start();
                try {
                    GridObject.this.updateDatabasesConnections(false);
                }
                catch (GridCommandException gridCommandException) {
                    this.firePropertyChange("message", null, gridCommandException.getMessage());
                    logger.severe(gridCommandException.getMessage());
                    this.cancel(true);
                    throw gridCommandException;
                }
                this.firePropertyChange("progress", null, 100);
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (customProgressMonitor.isCancelled() || !customProgressMonitor.successfulExecution()) {
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                } else {
                    customProgressMonitor.close();
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public boolean isWorkingInstance(InstanceObject instanceObject) {
        return this.getExecutor().getWorkingHost().getIPaddress().equalsIgnoreCase(instanceObject.getHost().getExternalAddress()) && this.getExecutor().getWorkingHost().getInstanceHome().equalsIgnoreCase(instanceObject.getHome());
    }

    public DifferenceObject diff(GridObject gridObject) {
        return this.diff(gridObject, false);
    }

    public DifferenceObject diff(GridObject gridObject, boolean bl) {
        GridObject gridObject2 = this;
        DifferenceObject differenceObject = new DifferenceObject();
        if (gridObject2.getMembershipConfiguration().getContent().equalsIgnoreCase(gridObject.getMembershipConfiguration().getContent())) {
            gridObject.getMembershipConfiguration().setEditedInLatest(false);
            gridObject2.getMembershipConfiguration().setEditedInLatest(false);
        } else {
            differenceObject.gridObjectEdited(gridObject.getMembershipConfiguration(), gridObject2.getMembershipConfiguration());
        }
        if (gridObject.getProperties().getVersion() == 1 && gridObject2.getProperties().getVersion() == 1) {
            if (gridObject.getInstanceConfiguration().getContent().isEmpty()) {
                gridObject.getInstanceConfiguration().setEditedInLatest(false);
                gridObject2.getInstanceConfiguration().setEditedInLatest(false);
            } else {
                gridObject.getInstanceConfiguration().setEditedInLatest(true);
                gridObject2.getInstanceConfiguration().setEditedInLatest(true);
            }
            if (gridObject.getSQLNet().getContent().isEmpty()) {
                gridObject.getSQLNet().setEditedInLatest(false);
                gridObject2.getSQLNet().setEditedInLatest(false);
            } else {
                gridObject.getSQLNet().setEditedInLatest(true);
                gridObject2.getSQLNet().setEditedInLatest(true);
            }
            if (gridObject.getTNSNames().getContent().isEmpty()) {
                gridObject.getTNSNames().setEditedInLatest(false);
                gridObject2.getTNSNames().setEditedInLatest(false);
            } else {
                gridObject.getTNSNames().setEditedInLatest(true);
                gridObject2.getTNSNames().setEditedInLatest(true);
            }
        } else {
            if (gridObject2.getInstanceConfiguration().getContent().equalsIgnoreCase(gridObject.getInstanceConfiguration().getContent())) {
                gridObject.getInstanceConfiguration().setEditedInLatest(false);
                gridObject2.getInstanceConfiguration().setEditedInLatest(false);
            } else {
                differenceObject.gridObjectEdited(gridObject.getInstanceConfiguration(), gridObject2.getInstanceConfiguration());
            }
            if (this.getSQLNet().getContent().equalsIgnoreCase(gridObject.getSQLNet().getContent())) {
                gridObject.getSQLNet().setEditedInLatest(false);
                gridObject2.getSQLNet().setEditedInLatest(false);
            } else {
                differenceObject.gridObjectEdited(gridObject.getSQLNet(), gridObject2.getSQLNet());
            }
            if (this.getTNSNames().getContent().equalsIgnoreCase(gridObject.getTNSNames().getContent())) {
                gridObject.getTNSNames().setEditedInLatest(false);
                gridObject2.getTNSNames().setEditedInLatest(false);
            } else {
                differenceObject.gridObjectEdited(gridObject.getTNSNames(), gridObject2.getTNSNames());
            }
        }
        if (gridObject.getProperties().getVersion() == 1 && gridObject2.getProperties().getVersion() == 1) {
            this.hostDiffVer1(differenceObject, gridObject);
            this.hostDiffVer1(null, gridObject2);
            this.setDBDefDiffVersion1(differenceObject, gridObject);
            this.setDBDefDiffVersion1(null, gridObject2);
            for (PhysicalGroupObject tTGridObject2 : gridObject2.getPhysicalGroups()) {
                tTGridObject2.setAppliedToCurrent(false);
                tTGridObject2.setEditedInLatest(false);
            }
            for (PhysicalGroupObject physicalGroupObject : gridObject.getPhysicalGroups()) {
                physicalGroupObject.setAppliedToCurrent(false);
                physicalGroupObject.setEditedInLatest(false);
                differenceObject.gridObjectAdded(physicalGroupObject);
            }
        } else {
            boolean bl2;
            TTGridObject tTGridObject;
            for (HostObject hostObject : gridObject2.getHosts()) {
                tTGridObject = gridObject.getHost(hostObject.getName());
                boolean bl3 = bl2 = tTGridObject != null;
                if (bl2) {
                    hostObject.diff(differenceObject, (HostObject)tTGridObject);
                    continue;
                }
                differenceObject.gridObjectRemoved(hostObject);
                for (InstallationObject installationObject : hostObject.getInstallations()) {
                    differenceObject.gridObjectRemoved(installationObject);
                }
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    differenceObject.gridObjectRemoved(instanceObject);
                }
            }
            for (HostObject hostObject : gridObject.getHosts()) {
                tTGridObject = gridObject2.getHost(hostObject.getName());
                bl2 = tTGridObject != null;
                if (bl2) continue;
                differenceObject.gridObjectAdded(hostObject);
                for (InstallationObject installationObject : hostObject.getInstallations()) {
                    differenceObject.gridObjectAdded(installationObject);
                }
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    differenceObject.gridObjectAdded(instanceObject);
                }
            }
            for (DBDefObject dBDefObject : gridObject2.getDBDefs()) {
                tTGridObject = gridObject.getDBDef(dBDefObject.getName());
                boolean bl4 = bl2 = tTGridObject != null;
                if (bl2) {
                    dBDefObject.diff(differenceObject, (DBDefObject)tTGridObject);
                    continue;
                }
                differenceObject.gridObjectRemoved(dBDefObject);
                for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
                    differenceObject.gridObjectRemoved(connectableObject);
                }
            }
            for (DBDefObject dBDefObject : gridObject.getDBDefs()) {
                tTGridObject = gridObject2.getDBDef(dBDefObject.getName());
                bl2 = tTGridObject != null;
                if (bl2) continue;
                differenceObject.gridObjectAdded(dBDefObject);
                for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
                    differenceObject.gridObjectAdded(connectableObject);
                }
            }
            for (PhysicalGroupObject physicalGroupObject : gridObject2.getPhysicalGroups()) {
                tTGridObject = gridObject.getPhysicalGroup(physicalGroupObject.getName());
                boolean bl5 = bl2 = tTGridObject != null;
                if (bl2) {
                    physicalGroupObject.diff(differenceObject, (PhysicalGroupObject)tTGridObject);
                    continue;
                }
                differenceObject.gridObjectRemoved(physicalGroupObject);
            }
            for (PhysicalGroupObject physicalGroupObject : gridObject.getPhysicalGroups()) {
                tTGridObject = gridObject2.getPhysicalGroup(physicalGroupObject.getName());
                bl2 = tTGridObject != null;
                if (bl2) continue;
                differenceObject.gridObjectAdded(physicalGroupObject);
            }
        }
        for (HostObject hostObject : gridObject.getHosts()) {
            gridObject.getGridNode().refreshHostNode(hostObject);
        }
        for (DBDefObject dBDefObject : gridObject.getDBDefs()) {
            gridObject.getGridNode().refreshDBDefNode(dBDefObject);
        }
        for (PhysicalGroupObject physicalGroupObject : gridObject.getPhysicalGroups()) {
            gridObject.getGridNode().refreshPhysicalGroupNode(physicalGroupObject, gridObject.getHosts());
        }
        gridObject.getGridNode().refreshConfigNodes(gridObject);
        if (this.getGridNode() != null) {
            this.getGridNode().updateIcon(!differenceObject.areDifferences());
        }
        if (gridObject.getGridNode() != null) {
            gridObject.getGridNode().updateIcon(!differenceObject.areDifferences());
        }
        return differenceObject;
    }

    public Topology getHostTopology() {
        Topology topology = new Topology(this.getProperties().getK());
        for (HostObject hostObject : this.getHosts()) {
            if (hostObject.isMgmtHostOnly()) continue;
            topology.save(hostObject);
        }
        return topology;
    }

    private void hostDiffVer1(DifferenceObject differenceObject, GridObject gridObject) {
        for (HostObject hostObject : gridObject.getHosts()) {
            if (hostObject.isMgmtHost()) {
                hostObject.setAppliedToCurrent(true);
                hostObject.setEditedInLatest(false);
                Object object = null;
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    if (instanceObject.isMgmtInstance() && instanceObject.getGUID() != null) {
                        instanceObject.setAppliedToCurrent(true);
                        instanceObject.setEditedInLatest(false);
                        object = instanceObject.getInstallation();
                        continue;
                    }
                    instanceObject.setAppliedToCurrent(false);
                    instanceObject.setEditedInLatest(false);
                    if (differenceObject == null) continue;
                    differenceObject.gridObjectAdded(instanceObject);
                }
                for (InstallationObject installationObject : hostObject.getInstallations()) {
                    if (installationObject == object) {
                        installationObject.setAppliedToCurrent(true);
                        installationObject.setEditedInLatest(false);
                        continue;
                    }
                    installationObject.setAppliedToCurrent(false);
                    installationObject.setEditedInLatest(false);
                    if (differenceObject == null) continue;
                    differenceObject.gridObjectAdded(installationObject);
                }
                continue;
            }
            hostObject.setAppliedToCurrent(false);
            hostObject.setEditedInLatest(false);
            if (differenceObject != null) {
                differenceObject.gridObjectAdded(hostObject);
            }
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                instanceObject.setAppliedToCurrent(false);
                instanceObject.setEditedInLatest(false);
                if (differenceObject == null) continue;
                differenceObject.gridObjectAdded(instanceObject);
            }
            for (InstallationObject installationObject : hostObject.getInstallations()) {
                installationObject.setAppliedToCurrent(false);
                installationObject.setEditedInLatest(false);
                if (differenceObject == null) continue;
                differenceObject.gridObjectAdded(installationObject);
            }
        }
    }

    private void setDBDefDiffVersion1(DifferenceObject differenceObject, GridObject gridObject) {
        for (DBDefObject dBDefObject : gridObject.getDBDefs()) {
            if (dBDefObject.getName().equalsIgnoreCase("TTGRIDADMIN")) {
                dBDefObject.setAppliedToCurrent(true);
                dBDefObject.setEditedInLatest(false);
                for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
                    if (connectableObject.getName().equalsIgnoreCase("TTGRIDADMIN")) {
                        connectableObject.setAppliedToCurrent(true);
                        connectableObject.setEditedInLatest(true);
                        continue;
                    }
                    connectableObject.setAppliedToCurrent(false);
                    connectableObject.setEditedInLatest(false);
                    if (differenceObject == null) continue;
                    differenceObject.gridObjectAdded(connectableObject);
                }
                continue;
            }
            dBDefObject.setAppliedToCurrent(false);
            dBDefObject.setEditedInLatest(false);
            if (differenceObject != null) {
                differenceObject.gridObjectAdded(dBDefObject);
            }
            for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
                connectableObject.setAppliedToCurrent(false);
                connectableObject.setEditedInLatest(false);
                if (differenceObject == null) continue;
                differenceObject.gridObjectAdded(connectableObject);
            }
        }
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.GridObjectName");
    }

    public void removeDatabase(DBDefObject dBDefObject) {
        this.databases.remove(dBDefObject);
        this.gridNodeMgr.removeDatabaseNode(dBDefObject);
    }

    public void disconnect() {
        this.getExecutor().disconnectSSHSession();
        if (!this.savePassword) {
            this.getExecutor().getWorkingHost().setPwd(null);
        }
        this.populated = false;
        this.hasDBStatus = false;
        if (SwingUtilities.isEventDispatchThread()) {
            this.gridNodeMgr.getCustomTree().collapsePath(TTGridRootNode.getInstance().getGridPath());
            this.gridNodeMgr.updateIcon(true);
            this.gridNodeMgr.setGridName(this.name);
            this.closeEditors();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.gridNodeMgr.getCustomTree().collapsePath(TTGridRootNode.getInstance().getGridPath());
                this.gridNodeMgr.updateIcon(true);
                this.gridNodeMgr.setGridName(this.name);
                this.closeEditors();
            });
        }
    }

    public void closeEditors() {
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof TTBaseEditor) || !editor.getContext().getProperty("gridName").equals(this.getName())) continue;
            List<TTBaseEditor> list = Arrays.asList((TTBaseEditor)editor);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(list));
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    Logger.getLogger(GridObject.class.getName()).log(Level.SEVERE, exception.getMessage());
                }
                continue;
            }
            EditorManager.getEditorManager().closeEditors(list);
        }
    }

    public InstanceObject getMgmtStandby() {
        for (InstanceObject instanceObject : this.getAllMgmtInstances()) {
            if (instanceObject.getType() != InstanceObject.ManagementInstanceRole.STANDBY) continue;
            return instanceObject;
        }
        return null;
    }

    public InstanceObject getNoActiveMgmt() {
        for (InstanceObject instanceObject : this.getAllMgmtInstances()) {
            if (instanceObject.getType() == InstanceObject.ManagementInstanceRole.ACTIVE) continue;
            return instanceObject;
        }
        return null;
    }

    public void refreshGridModels() throws GridCommandException {
        GridCommand gridCommand = this.showingVersion == ModelVersion.LATEST ? GridCommand.EXPORT_MODEL : GridCommand.EXPORT_CURRENTMODEL;
        GridCommand gridCommand2 = this.showingVersion == ModelVersion.LATEST ? GridCommand.EXPORT_CURRENTMODEL : GridCommand.EXPORT_MODEL;
        this.setGridComponents(this.executor.executeCommandGetJson(gridCommand, true), false);
        this.gridCurrentModel.setGridComponents(this.executor.executeCommandGetJson(gridCommand2, true), false);
    }

    public void getRepositoryData() throws GridCommandException {
        GridCommand gridCommand = GridCommand.REPOSITORY_LIST;
        JsonObject jsonObject = this.executor.executeCommandGetJson(gridCommand, false);
        this.setRepositoriesInfo(jsonObject);
    }

    private boolean isDBNotExistError(String string, String string2) {
        if (string.indexOf(123) >= 0) {
            string = string.substring(string.indexOf(123), string.length());
            try {
                JsonObject jsonObject = Json.createReader((Reader)new StringReader(string)).readObject();
                Integer n = jsonObject.getInt("status");
                if (n != null && n == 2) {
                    Common.displayInfoMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.dbNotCreated"), string2), Messages.getString("TimesTenGrid.dbNotCreatedTitle"));
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static enum ModelVersion {
        LATEST,
        CURRENT;

    }

    public class GridProperties {
        String guid;
        String lastModified;
        String applied;
        String membership;
        int version;
        int k;
        boolean otherProperties;
        String created;
        int adminUID;
        String adminGroup;
        int adminGID;
        int retainDays;
        int retainVersions;
        String majorRelease;
        String createdRelease;

        public boolean hasOtherProperties() {
            return this.otherProperties;
        }

        public void setOtherProperties(JsonObject jsonObject) throws JsonException {
            try {
                this.created = jsonObject.getString("created");
                this.adminUID = jsonObject.getInt("adminUID");
                this.adminGID = jsonObject.getInt("adminGID");
                this.retainDays = jsonObject.getInt("retainDays");
                this.retainVersions = jsonObject.getInt("retainVersions");
                this.adminGroup = jsonObject.getString("adminGroup");
                this.majorRelease = jsonObject.getString("majorRelease");
                this.createdRelease = jsonObject.getString("createdRelease");
                this.otherProperties = true;
            }
            catch (Exception exception) {
                throw new JsonException(exception.getMessage());
            }
        }

        public void setGridProperties(JsonObject jsonObject) throws JsonException {
            try {
                this.guid = jsonObject.getString("gridGuid");
                this.lastModified = jsonObject.getString("whenCreated");
                if (jsonObject.getBoolean("applied")) {
                    this.applied = jsonObject.getString("whenApplied");
                }
                this.version = jsonObject.getInt("version");
                this.k = jsonObject.getInt("k");
                this.membership = jsonObject.getString("membership");
            }
            catch (Exception exception) {
                throw new JsonException(exception.getMessage());
            }
        }

        public String getGuid() {
            return this.guid;
        }

        public String getLastModifiedStr() {
            return this.lastModified;
        }

        public String getCreatedStr() {
            return this.created;
        }

        public String getAppliedStr() {
            return this.applied;
        }

        public int getVersion() {
            return this.version;
        }

        public int getK() {
            return this.k;
        }

        public void setK(int n) {
            this.k = n;
        }

        public String getMembership() {
            return this.membership;
        }

        public int getAdminUID() {
            return this.adminUID;
        }

        public String getAdminGroup() {
            return this.adminGroup;
        }

        public int getAdminGID() {
            return this.adminGID;
        }

        public int getRetainDays() {
            return this.retainDays;
        }

        public int getRetainVersions() {
            return this.retainVersions;
        }

        public String getMajorRelease() {
            return this.majorRelease;
        }

        public String getCreatedRelease() {
            return this.createdRelease;
        }
    }
}

