/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class DifferenceObject {
    private List<TTGridObject> objectsChanged = new ArrayList<TTGridObject>();
    private List<OperationType> operation = new ArrayList<OperationType>();
    private int numDiff = 0;

    public void gridObjectEdited(TTGridObject tTGridObject, TTGridObject tTGridObject2) {
        tTGridObject.setEditedInLatest(true);
        tTGridObject2.setEditedInLatest(true);
        this.objectsChanged.add(tTGridObject);
        this.operation.add(OperationType.EDITED);
        ++this.numDiff;
    }

    public void gridObjectRemoved(TTGridObject tTGridObject) {
        tTGridObject.setEditedInLatest(true);
        this.objectsChanged.add(tTGridObject);
        this.operation.add(OperationType.REMOVED);
        ++this.numDiff;
    }

    public void gridObjectAdded(TTGridObject tTGridObject) {
        tTGridObject.setAppliedToCurrent(false);
        this.objectsChanged.add(tTGridObject);
        this.operation.add(OperationType.ADDED);
        ++this.numDiff;
    }

    public int getDiffNumber() {
        return this.numDiff;
    }

    public boolean areDifferences() {
        return this.numDiff > 0;
    }

    public List<TTGridObject> getObjectsChanged() {
        return this.objectsChanged;
    }

    public List<OperationType> getOperation() {
        return this.operation;
    }

    public static enum OperationType {
        ADDED,
        REMOVED,
        EDITED;


        public String toString() {
            switch (this) {
                case ADDED: {
                    return Messages.getString("TimesTenGrid.ObjDiffAdded");
                }
                case REMOVED: {
                    return Messages.getString("TimesTenGrid.ObjDiffRemoved");
                }
                case EDITED: {
                    return Messages.getString("TimesTenGrid.ObjDiffEdited");
                }
            }
            return null;
        }
    }
}

