/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class ConnectableObject
extends TTGridObject
implements Deletable {
    ArrayList<DBDefAttribute> attributes = new ArrayList();
    private GridObject currentGrid;
    private boolean isCS;
    private String onlyInstance = null;
    private static Logger logger = Logger.getLogger(ConnectableObject.class.getName());
    private DBDefObject db;

    public boolean isCS() {
        return this.isCS;
    }

    public void setCS(boolean bl) {
        this.isCS = bl;
    }

    public String getOnlyInstance() {
        return this.onlyInstance;
    }

    public void setOnlyInstance(String string) {
        this.onlyInstance = string;
    }

    public ConnectableObject(GridObject gridObject, DBDefObject dBDefObject) {
        this.currentGrid = gridObject;
        this.db = dBDefObject;
    }

    @Override
    public String getFullName() {
        if (this.db != null) {
            return this.db.getName() + "." + this.getName();
        }
        return this.getName();
    }

    public void addAttribute(DBDefAttribute dBDefAttribute) {
        this.attributes.add(dBDefAttribute);
    }

    public void addAttribute(String string, String string2) {
        if (this.currentGrid == null) {
            logger.log(Level.SEVERE, "AttributesUtil not available. DbDef attributes can not be loaded.");
            return;
        }
        DBDefAttribute dBDefAttribute = this.currentGrid.getAttributesUtil().getAttribute(string);
        dBDefAttribute.setValueFromString(string2);
        this.attributes.add(dBDefAttribute);
    }

    public ArrayList<DBDefAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.name;
    }

    public void setConnectableModel(JsonObject jsonObject) {
        this.attributes.clear();
        this.setName(jsonObject.getString("name"));
        this.setGUID(jsonObject.getString("guid"));
        this.setCS(jsonObject.getBoolean("clientServer"));
        if (this.isCS) {
            try {
                this.setOnlyInstance(jsonObject.getString("__ONLY0"));
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Value for __ONLY0 not found or key was modified: " + exception.getMessage());
            }
        }
        JsonObject jsonObject2 = jsonObject.getJsonObject("attrs");
        for (String string : jsonObject2.keySet()) {
            this.addAttribute(string, jsonObject2.getString(string));
        }
    }

    public void diff(DifferenceObject differenceObject, ConnectableObject connectableObject) {
        ArrayList<DBDefAttribute> arrayList = new ArrayList<DBDefAttribute>();
        ArrayList<DBDefAttribute> arrayList2 = new ArrayList<DBDefAttribute>();
        ConnectableObject connectableObject2 = this;
        connectableObject2.setAppliedToCurrent(true);
        connectableObject.setAppliedToCurrent(true);
        for (DBDefAttribute dBDefAttribute : connectableObject2.getAttributes()) {
            arrayList.add(dBDefAttribute);
        }
        for (DBDefAttribute dBDefAttribute : connectableObject.getAttributes()) {
            arrayList2.add(dBDefAttribute);
        }
        if (arrayList.size() != arrayList2.size()) {
            differenceObject.gridObjectEdited(connectableObject, connectableObject2);
            return;
        }
        for (DBDefAttribute<Object> dBDefAttribute : arrayList) {
            DBDefAttribute dBDefAttribute2 = null;
            for (DBDefAttribute dBDefAttribute3 : arrayList2) {
                if (!dBDefAttribute3.isSameAttribute(dBDefAttribute)) continue;
                dBDefAttribute2 = dBDefAttribute3;
                if (dBDefAttribute.equals(dBDefAttribute3)) continue;
                differenceObject.gridObjectEdited(connectableObject, connectableObject2);
                return;
            }
            if (dBDefAttribute2 != null) continue;
            differenceObject.gridObjectEdited(connectableObject, connectableObject2);
            return;
        }
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.ConnectableObjectName");
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.DELETE_CONNECTABLE);
        basicDeletable.setCmdArgs(this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.deleteConnTitle"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingConnDBCommand"), this.name));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingConnectable"), this.name));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.deleteConnCancel"));
        basicDeletable.deleteObject(runnable);
    }
}

