/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.utils.FilterData;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class Storage
extends HashStructureAdapter {
    static final String EXT_ID = "oracle.sqldeveloper.timesten";
    public static final String STORE_FILENAME = "ttgrids.xml";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqldeveloper-timesten");
    private static final String ROOT_NAME = "timesten-grids";
    private static final String GRIDS_KEY = "grids";
    private static final String TXTFLD_SUGGESTIONS_KEY = "suggestions";
    private static final String DB_SYSTEM_ID_KEY = "db.system.id";
    private static final String FILTERS_KEY = "filters";
    private static final String HOST_KEY = "host";
    private static final String TEXT_KEY = "text";
    private static final String TYPE_KEY = "type";
    private static Logger logger = Logger.getLogger(Storage.class.getName());
    private final URL storageURL;

    private Storage(HashStructure hashStructure, URL uRL) {
        super(hashStructure);
        this.storageURL = uRL;
        this.setFilePermission();
    }

    static URL getStorageURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        return URLFactory.newURL((URL)uRL, (String)STORE_FILENAME);
    }

    static Storage createStorage(URL uRL) {
        HashStructure hashStructure = HashStructure.newInstance();
        Storage storage = new Storage(hashStructure, uRL);
        return storage;
    }

    void load() throws IOException {
        if (URLFileSystem.exists((URL)this.storageURL)) {
            HashStructureIO hashStructureIO = Storage.getIO();
            hashStructureIO.open(this.storageURL, (Object)this.getHashStructure());
            this.loadGrids();
        }
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_NAME);
    }

    void save() throws IOException {
        HashStructure hashStructure = this.getHashStructure();
        if (hashStructure.isDirty()) {
            HashStructureIO hashStructureIO = Storage.getIO();
            hashStructureIO.save(this.storageURL, (Object)hashStructure);
            this.setFilePermission();
            hashStructure.markDirty(false);
        }
    }

    private void setFilePermission() {
        File file = new File(this.storageURL.getFile());
        file.setWritable(false, false);
        file.setReadable(false, false);
        file.setExecutable(false, false);
        file.setReadable(true);
        file.setWritable(true);
    }

    private void doSave() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            logger.severe("While saving ttgrids file: " + iOException.getMessage());
        }
    }

    private HashStructure getGrids() {
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(GRIDS_KEY);
        return hashStructure2;
    }

    private HashStructure getFilters() {
        HashStructure hashStructure = this.getHashStructure();
        if (!hashStructure.containsKey(FILTERS_KEY)) {
            hashStructure.putHashStructure(FILTERS_KEY, HashStructure.newInstance());
        }
        HashStructure hashStructure2 = hashStructure.getHashStructure(FILTERS_KEY);
        return hashStructure2;
    }

    public Collection<String> listHosts() {
        HashStructure hashStructure = this.getGrids();
        Set set = hashStructure != null ? hashStructure.keySet() : Collections.emptySet();
        return set;
    }

    private void loadGrids() {
        HashStructure hashStructure = this.getGrids();
        boolean bl = Common.validFilePermission(this.storageURL.getFile());
        if (hashStructure != null) {
            for (String string : this.listHosts()) {
                HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                if (hashStructure2 == null) continue;
                try {
                    if (TTGridRootNode.getInstance().getGrid(string) != null) continue;
                    char[] cArray = null;
                    String string2 = hashStructure2.getString("pwd");
                    if (string2 != null && bl) {
                        cArray = Wrapper.getInstance().decrypt(string2);
                    }
                    String string3 = hashStructure2.getString("keyfile");
                    GridObject gridObject = new GridObject(hashStructure2.getString("gridname"), GridCommandExecutor.getNewInstance(hashStructure2.getString(HOST_KEY), hashStructure2.getString("instancehome"), hashStructure2.getString("instanceadmin"), cArray, string3), false);
                    gridObject.getExecutor().getWorkingHost().setSystemInfo(hashStructure2.getString("ttenv"), hashStructure2.getString("os"), hashStructure2.getString("tmpdir"), hashStructure2.getString("fileseparator"));
                    gridObject.setSavePassword(hashStructure2.getBoolean("savepwd"));
                    TTGridRootNode.getInstance().addGrid(gridObject);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveHostFilterData(String string, FilterData filterData) {
        HashStructure hashStructure;
        if (!filterData.isValid()) {
            return;
        }
        HashStructure hashStructure2 = this.getFilters();
        if (!hashStructure2.containsKey(string)) {
            hashStructure2.putHashStructure(string, HashStructure.newInstance());
        }
        if (!(hashStructure = hashStructure2.getHashStructure(string)).containsKey(HOST_KEY)) {
            hashStructure.putHashStructure(HOST_KEY, HashStructure.newInstance());
        }
        HashStructure hashStructure3 = hashStructure.getHashStructure(HOST_KEY);
        hashStructure3.putString(TEXT_KEY, filterData.getText());
        hashStructure3.putString(TYPE_KEY, filterData.getType().name());
        this.doSave();
    }

    public FilterData getHostFilter(String string) {
        HashStructure hashStructure = this.getFilters();
        FilterData filterData = new FilterData();
        if (!hashStructure.containsKey(string)) {
            return filterData;
        }
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (!hashStructure2.containsKey(HOST_KEY)) {
            return filterData;
        }
        HashStructure hashStructure3 = hashStructure2.getHashStructure(HOST_KEY);
        filterData.setText(hashStructure3.getString(TEXT_KEY));
        filterData.setType(hashStructure3.getString(TYPE_KEY));
        return filterData;
    }

    public void clearHostFilterData(String string) {
        HashStructure hashStructure = this.getFilters();
        if (!hashStructure.containsKey(string)) {
            return;
        }
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (!hashStructure2.containsKey(HOST_KEY)) {
            return;
        }
        hashStructure2.remove(HOST_KEY);
        this.doSave();
    }

    public void removeGuidFromFilters(String string) {
        HashStructure hashStructure = this.getFilters();
        if (!hashStructure.containsKey(string)) {
            return;
        }
        hashStructure.remove(string);
        this.doSave();
    }

    public void saveSuggestion(String string, String string2) {
        Object object;
        if (string2 == null) {
            return;
        }
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(TXTFLD_SUGGESTIONS_KEY);
        if (hashStructure2 == null) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(TXTFLD_SUGGESTIONS_KEY, hashStructure2);
        }
        if ((object = hashStructure2.getString(string)) != null) {
            String[] stringArray;
            for (String string3 : stringArray = ((String)object).split("\\|")) {
                if (!string2.equals(string3)) continue;
                return;
            }
            object = (String)object + "|" + string2;
        } else {
            object = string2;
        }
        hashStructure2.putString(string, (String)object);
        this.doSave();
    }

    void saveDBSysID(String string) {
        HashStructure hashStructure = this.getHashStructure();
        hashStructure.putString(DB_SYSTEM_ID_KEY, string);
        this.doSave();
    }

    public List<String> getSuggestion(String string) {
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(TXTFLD_SUGGESTIONS_KEY);
        if (hashStructure2 == null) {
            return Collections.emptyList();
        }
        String string2 = hashStructure2.getString(string);
        if (string2 != null) {
            return Arrays.asList(string2.split("\\|"));
        }
        return Collections.emptyList();
    }

    public void saveGrid(GridObject gridObject) {
        this.saveGridImpl(gridObject);
    }

    private void saveGridImpl(GridObject gridObject) {
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(GRIDS_KEY);
        if (hashStructure2 == null) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(GRIDS_KEY, hashStructure2);
        }
        HashStructure hashStructure3 = gridObject.toHashStructure();
        if (gridObject.getSavePassword()) {
            hashStructure3.putString("pwd", Wrapper.getInstance().encrypt(hashStructure3.getString("pwd").toCharArray()));
        }
        hashStructure2.putHashStructure(gridObject.getName(), hashStructure3);
        this.doSave();
    }

    public void removeGrid(String string) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = this.getGrids();
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            hashStructure2.remove(string);
            this.doSave();
        }
    }

    private static final class Wrapper {
        private static Wrapper INSTANCE;
        private static final int ITERATION_COUNT = 1000;
        private static final String ENCODING = "UTF-8";
        private Cipher m_encoder;
        private Cipher m_decoder;
        private byte[] salt = new byte[]{-47, 9, 121, -17, -84, -116, -98, -1};
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey key;
        private Charset m_charset;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        static synchronized Wrapper getInstance() {
            if (INSTANCE == null) {
                String string = null;
                HashStructure hashStructure = TTGridRootNode.getStorage().getHashStructure();
                string = hashStructure.getString(Storage.DB_SYSTEM_ID_KEY);
                if (string == null) {
                    string = UUID.randomUUID().toString();
                    TTGridRootNode.getStorage().saveDBSysID(string);
                }
                INSTANCE = new Wrapper(string);
            }
            return INSTANCE;
        }

        Wrapper(String string) {
            try {
                PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), this.salt, 1000);
                this.key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
                this.m_paramSpec = new PBEParameterSpec(this.salt, 1000);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            this.m_charset = Charset.forName(ENCODING);
        }

        public String encrypt(char[] cArray) {
            byte[] byArray = null;
            try {
                if (this.m_encoder == null) {
                    this.m_encoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_encoder.init(1, (Key)this.key, this.m_paramSpec);
                }
                if (this.m_charEnc == null) {
                    this.m_charEnc = this.m_charset.newEncoder();
                }
                byte[] byArray2 = this.m_charEnc.encode(CharBuffer.wrap(cArray)).array();
                byArray = this.m_encoder.doFinal(byArray2);
                return DatatypeConverter.printBase64Binary((byte[])byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public char[] decrypt(String string) {
            try {
                if (this.m_decoder == null) {
                    this.m_decoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_decoder.init(2, (Key)this.key, this.m_paramSpec);
                }
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
                byte[] byArray2 = this.m_decoder.doFinal(byArray);
                if (this.m_charDec == null) {
                    this.m_charDec = this.m_charset.newDecoder();
                }
                CharBuffer charBuffer = this.m_charDec.decode(ByteBuffer.wrap(byArray2));
                return charBuffer.array();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

