/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CloneHostPanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CreateRepositoryPanel;
import oracle.dbtools.raptor.timesten.grid.CredentialsPanel;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.DSGAssignmentPanel;
import oracle.dbtools.raptor.timesten.grid.EditHostPanel;
import oracle.dbtools.raptor.timesten.grid.ExportImportPanel;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridMgmtInfoPanel;
import oracle.dbtools.raptor.timesten.grid.LatestModelChangesPanel;
import oracle.dbtools.raptor.timesten.grid.ManageExistingGridPanel;
import oracle.dbtools.raptor.timesten.grid.NewStandaloneHostPanel;
import oracle.dbtools.raptor.timesten.grid.PasswordlessSSHTestPanel;
import oracle.dbtools.raptor.timesten.grid.RegisterClientServerDSN;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.TTGridWizMain;
import oracle.dbtools.raptor.timesten.grid.database.DBDefEditor;
import oracle.dbtools.raptor.timesten.grid.database.DatabaseConnectablesPanel;
import oracle.dbtools.raptor.timesten.grid.database.DatabaseDistributionPanel;
import oracle.dbtools.raptor.timesten.grid.database.DbDestroyDialog;
import oracle.dbtools.raptor.timesten.grid.database.NewConnectablePanel;
import oracle.dbtools.raptor.timesten.grid.database.NewDBDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.WizardMain;
import oracle.dbtools.raptor.timesten.grid.editors.ConnectablesEditor;
import oracle.dbtools.raptor.timesten.grid.editors.HostEditor;
import oracle.dbtools.raptor.timesten.grid.editors.InstallationEditor;
import oracle.dbtools.raptor.timesten.grid.editors.InstanceEditor;
import oracle.dbtools.raptor.timesten.grid.editors.RepositoryEditor;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.installations.InstallationCreatePanel;
import oracle.dbtools.raptor.timesten.grid.instance.EditInstancePanel;
import oracle.dbtools.raptor.timesten.grid.instance.ExecuteCommandPanel;
import oracle.dbtools.raptor.timesten.grid.instance.InstanceActionPanel;
import oracle.dbtools.raptor.timesten.grid.instance.NewInstancePanel;
import oracle.dbtools.raptor.timesten.grid.instance.NewInstanceWizard;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogInspectorMainWindow;
import oracle.dbtools.raptor.timesten.grid.management.ActiveStandbyPairManagement;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConfigObject;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.grid.physicalGroups.PhysicalGroupCreatePanel;
import oracle.dbtools.raptor.timesten.grid.shutdown.StopGridWizardMain;
import oracle.dbtools.raptor.timesten.grid.start.StartGridWizardMain;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;

public class GridNavigatorContextMenu
implements ContextMenuListener,
Controller {
    static final String DELETE_HOST_CONFIRMATION_ID = "DeleteHostConfirmation";
    static final String DELETE_INSTANCE_CONFIRMATION_ID = "DeleteInstanceConfirmation";
    static final String GRID_WIZARD_CMD = "Grid_Nav.GridWizard";
    static final int GRID_WIZARD_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.GridWizard");
    static final IdeAction ACTION_GRID_WIZARD = IdeAction.find((int)GRID_WIZARD_ID);
    static final String NEW_GRID_CMD = "Grid_Nav.NewGrid";
    static final int NEW_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewGrid");
    static final IdeAction ACTION_NEW_GRID = IdeAction.find((int)NEW_GRID_ID);
    static final String MANAGE_GRID_CMD = "Grid_Nav.ManageGrid";
    static final int MANAGE_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ManageGrid");
    static final IdeAction ACTION_MANAGE_GRID = IdeAction.find((int)MANAGE_GRID_ID);
    static final String TEST_GRID_CMD = "Grid_Nav.TestGridReq";
    static final int TEST_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.TestGridReq");
    static final IdeAction ACTION_TEST_GRID = IdeAction.find((int)TEST_GRID_ID);
    static final String START_GRID_CMD = "Grid_Nav.StartGrid";
    static final int START_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StartGrid");
    static final IdeAction ACTION_START_GRID = IdeAction.find((int)START_GRID_ID);
    static final String GRID_CONN_CMD = "Grid_Nav.GridConnect";
    static final int GRID_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.GridConnect");
    static final IdeAction ACTION_GRID_CONN = IdeAction.find((int)GRID_CONN_ID);
    static final String GRID_DISCONN_CMD = "Grid_Nav.GridDisconnect";
    static final int GRID_DISCONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.GridDisconnect");
    static final IdeAction ACTION_GRID_DISCONN = IdeAction.find((int)GRID_DISCONN_ID);
    static final String STOP_GRID_CMD = "Grid_Nav.StopGrid";
    static final int STOP_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StopGrid");
    static final IdeAction ACTION_STOP_GRID = IdeAction.find((int)STOP_GRID_ID);
    static final String INST_STATUS_CMD = "Grid_Nav.InstStatus";
    static final int INST_STATUS_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.InstStatus");
    static final IdeAction ACTION_INST_STATUS = IdeAction.find((int)INST_STATUS_ID);
    static final String CREATE_DB_CMD = "Grid_Nav.CreateDb";
    static final int CREATE_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.CreateDb");
    static final IdeAction ACTION_CREATE_DB = IdeAction.find((int)CREATE_DB_ID);
    static final String EXPORT_DBDEF_CMD = "Grid_Nav.ExportDbDef";
    static final int EXPORT_DBDEF_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ExportDbDef");
    static final IdeAction ACTION_EXPORT_DBDEF = IdeAction.find((int)EXPORT_DBDEF_ID);
    static final String DELETE_DBDEF_CMD = "Grid_Nav.DeleteDbDef";
    static final int DELETE_DBDEF_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeleteDbDef");
    static final IdeAction ACTION_DELETE_DBDEF = IdeAction.find((int)DELETE_DBDEF_ID);
    static final String EXPORT_MODEL_CMD = "Grid_Nav.ExportModel";
    static final int EXPORT_MODEL_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ExportModel");
    static final IdeAction ACTION_EXPORT_MODEL = IdeAction.find((int)EXPORT_MODEL_ID);
    static final String EXPORT_CLIENT_DSN = "Grid_Nav.ExportInstallClientDSN";
    static final int EXPORT_CLIENT_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ExportInstallClientDSN");
    static final IdeAction ACTION_EXPORT_CLIENT = IdeAction.find((int)EXPORT_CLIENT_ID);
    static final String APPLY_GRID_CMD = "Grid_Nav.ApplyGrid";
    static final int APPLY_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ApplyGrid");
    static final IdeAction ACTION_APPLY_GRID = IdeAction.find((int)APPLY_GRID_ID);
    static final String REMOVE_GRID_CMD = "Grid_Nav.RemoveGrid";
    static final int REMOVE_GRID_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.RemoveGrid");
    static final IdeAction ACTION_REMOVE_GRID = IdeAction.find((int)REMOVE_GRID_ID);
    static final String GRID_SHOW_CHANGES_CMD = "Grid_Nav.ShowChanges";
    static final int GRID_SHOW_CHANGES_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ShowChanges");
    static final IdeAction ACTION_GRID_SHOW_CHANGES = IdeAction.find((int)GRID_SHOW_CHANGES_ID);
    static final String GRID_EXE_ALL_CMD = "Grid_Nav.InstanceExecAll";
    static final int GRID_EXEC_ALL_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.InstanceExecAll");
    static final IdeAction ACTION_GRID_EXEC_ALL = IdeAction.find((int)GRID_EXEC_ALL_ID);
    static final String GRID_PROP_CMD = "Grid_Nav.GridProp";
    static final int GRID_PROP_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.GridProp");
    static final IdeAction ACTION_GRID_PROP = IdeAction.find((int)GRID_PROP_ID);
    static final String USE_CURRENT_MODEL_CMD = "Grid_Nav.CurrentModel";
    static final int USE_CURRENT_MODEL_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.CurrentModel");
    static final IdeAction ACTION_USE_CURRENT_MODEL = IdeAction.find((int)USE_CURRENT_MODEL_ID);
    static final String USE_LATEST_MODEL_CMD = "Grid_Nav.LatestModel";
    static final int USE_LATEST_MODEL_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.LatestModel");
    static final IdeAction ACTION_USE_LATEST_MODEL = IdeAction.find((int)USE_LATEST_MODEL_ID);
    static final String GRID_VIEW_MSGLOG_CMD = "Grid_Nav.ViewMsgLogs";
    static final int GRID_VIEW_MSGLOG_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ViewMsgLogs");
    static final IdeAction ACTION_VIEW_MSGLOG = IdeAction.find((int)GRID_VIEW_MSGLOG_ID);
    static final String GRID_VIEW_ERRORLOG_CMD = "Grid_Nav.ViewErrorLogs";
    static final int GRID_VIEW_ERRORLOG_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ViewErrorLogs");
    static final IdeAction ACTION_VIEW_ERRORLOG = IdeAction.find((int)GRID_VIEW_ERRORLOG_ID);
    static final String NEW_DB_CMD = "Grid_Nav.NewDatabase";
    static final int NEW_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewDatabase");
    static final IdeAction ACTION_NEW_DB = IdeAction.find((int)NEW_DB_ID);
    static final String NEW_DBDEF_CMD = "Grid_Nav.NewDBDef";
    static final int NEW_DBDEF_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewDBDef");
    static final IdeAction ACTION_NEW_DBDEF = IdeAction.find((int)NEW_DBDEF_ID);
    static final String EDIT_DBDEF_CMD = "Grid_Nav.EditDBDef";
    static final int EDIT_DBDEF_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.EditDBDef");
    static final IdeAction ACTION_EDIT_DBDEF = IdeAction.find((int)EDIT_DBDEF_ID);
    static final String NEW_HOST_CMD = "Grid_Nav.NewHost";
    static final int NEW_HOST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewHost");
    static final IdeAction ACTION_NEW_HOST = IdeAction.find((int)NEW_HOST_ID);
    static final String ASSIGN_DSGS_CMD = "Grid_Nav.AssignToDSGs";
    static final int ASSIGN_DSGS_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.AssignToDSGs");
    static final IdeAction ACTION_ASSIGN_DSGS = IdeAction.find((int)ASSIGN_DSGS_ID);
    static final String CLONE_HOST_CMD = "Grid_Nav.CloneHost";
    static final int CLONE_HOST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.CloneHost");
    static final IdeAction ACTION_CLONE_HOST = IdeAction.find((int)CLONE_HOST_ID);
    static final String EDIT_HOST_CMD = "Grid_Nav.EditHost";
    static final int EDIT_HOST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.EditHost");
    static final IdeAction ACTION_EDIT_HOST = IdeAction.find((int)EDIT_HOST_ID);
    static final String DELETE_HOST_CMD = "Grid_Nav.DeleteHost";
    static final int DELETE_HOST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeleteHost");
    static final IdeAction ACTION_DELETE_HOST = IdeAction.find((int)DELETE_HOST_ID);
    static final String NEW_INSTALLATION_CMD = "Grid_Nav.NewInstallation";
    static final int NEW_INSTALLATION_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewInstallation");
    static final IdeAction ACTION_NEW_INSTALLATION = IdeAction.find((int)NEW_INSTALLATION_ID);
    static final String DELETE_INSTALLATION_CMD = "Grid_Nav.DeleteInstallation";
    static final int DELETE_INSTALLATION_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeleteInstallation");
    static final IdeAction ACTION_DELETE_INSTALLATION = IdeAction.find((int)DELETE_INSTALLATION_ID);
    static final String NEW_INSTANCE_CMD = "Grid_Nav.NewInstance";
    static final int NEW_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewInstance");
    static final IdeAction ACTION_NEW_INSTANCE = IdeAction.find((int)NEW_INSTANCE_ID);
    static final String NEW_MGMT_INSTANCE_CMD = "Grid_Nav.NewMgmtInst";
    static final int NEW_MGMT_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewMgmtInst");
    static final IdeAction ACTION_NEW_MGMT_INSTANCE = IdeAction.find((int)NEW_MGMT_INSTANCE_ID);
    static final String MGMT_INSTANCE_CMD = "Grid_Nav.MgmtInst";
    static final int MGMT_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.MgmtInst");
    static final IdeAction ACTION_MGMT_INSTANCE = IdeAction.find((int)MGMT_INSTANCE_ID);
    static final String NEW_DATA_INSTANCE_CMD = "Grid_Nav.NewDataInst";
    static final int NEW_DATA_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewDataInst");
    static final IdeAction ACTION_NEW_DATA_INSTANCE = IdeAction.find((int)NEW_DATA_INSTANCE_ID);
    static final String SWITCH_INSTANCE_CMD = "Grid_Nav.Switch";
    static final int SWITCH_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Switch");
    static final IdeAction ACTION_SWITCH_INSTANCE = IdeAction.find((int)SWITCH_INSTANCE_ID);
    static final String STDBY_START_CMD = "Grid_Nav.StdbyStart";
    static final int STDBY_START_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StdbyStart");
    static final IdeAction ACTION_STDBY_START = IdeAction.find((int)STDBY_START_ID);
    static final String STDBY_STOP_CMD = "Grid_Nav.StdbyStop";
    static final int STDBY_STOP_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StdbyStop");
    static final IdeAction ACTION_STDBY_STOP = IdeAction.find((int)STDBY_STOP_ID);
    static final String REPLACE_CMD = "Grid_Nav.Replace";
    static final int REPLACE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Replace");
    static final IdeAction ACTION_REPLACE = IdeAction.find((int)REPLACE_ID);
    static final String HOST_EXEC_CMD = "Grid_Nav.HostExec";
    static final int HOST_EXEC_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.HostExec");
    static final IdeAction ACTION_HOST_EXEC = IdeAction.find((int)HOST_EXEC_ID);
    static final String START_INSTANCE_CMD = "Grid_Nav.StartInstance";
    static final int START_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StartInstance");
    static final IdeAction ACTION_START_INSTANCE = IdeAction.find((int)START_INSTANCE_ID);
    static final String START_SERVER_INST_CMD = "Grid_Nav.StartServerInst";
    static final int START_SERVER_INST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StartServerInst");
    static final IdeAction ACTION_START_SERVER_INST = IdeAction.find((int)START_SERVER_INST_ID);
    static final String STOP_INSTANCE_CMD = "Grid_Nav.StopInstance";
    static final int STOP_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StopInstance");
    static final IdeAction ACTION_STOP_INSTANCE = IdeAction.find((int)STOP_INSTANCE_ID);
    static final String STOP_SERVER_INST_CMD = "Grid_Nav.StopServerInst";
    static final int STOP_SERVER_INST_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StopServerInst");
    static final IdeAction ACTION_STOP_SERVER_INST = IdeAction.find((int)STOP_SERVER_INST_ID);
    static final String INSTANCE_EXEC_CMD = "Grid_Nav.InstanceExec";
    static final int INSTANCE_EXEC_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.InstanceExec");
    static final IdeAction ACTION_INSTANCE_EXEC = IdeAction.find((int)INSTANCE_EXEC_ID);
    static final String EDIT_INSTANCE_CMD = "Grid_Nav.EditInstance";
    static final int EDIT_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.EditInstance");
    static final IdeAction ACTION_EDIT_INSTANCE = IdeAction.find((int)EDIT_INSTANCE_ID);
    static final String DELETE_INSTANCE_CMD = "Grid_Nav.DeleteInstance";
    static final int DELETE_INSTANCE_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeleteInstance");
    static final IdeAction ACTION_DELETE_INSTANCE = IdeAction.find((int)DELETE_INSTANCE_ID);
    static final String START_DB_CMD = "Grid_Nav.StartDB";
    static final int START_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StartDB");
    static final IdeAction ACTION_START_DB = IdeAction.find((int)START_DB_ID);
    static final String STOP_DB_CMD = "Grid_Nav.StopDB";
    static final int STOP_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.StopDB");
    static final IdeAction ACTION_STOP_DB = IdeAction.find((int)STOP_DB_ID);
    static final String LOAD_DB_CMD = "Grid_Nav.LoadDB";
    static final int LOAD_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.LoadDB");
    static final IdeAction ACTION_LOAD_DB = IdeAction.find((int)LOAD_DB_ID);
    static final String OPEN_DB_CMD = "Grid_Nav.OpenDB";
    static final int OPEN_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.OpenDB");
    static final IdeAction ACTION_OPEN_DB = IdeAction.find((int)OPEN_DB_ID);
    static final String CLOSE_DB_CMD = "Grid_Nav.CloseDB";
    static final int CLOSE_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.CloseDB");
    static final IdeAction ACTION_CLOSE_DB = IdeAction.find((int)CLOSE_DB_ID);
    static final String UNLOAD_DB_CMD = "Grid_Nav.UnloadDB";
    static final int UNLOAD_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.UnloadDB");
    static final IdeAction ACTION_UNLOAD_DB = IdeAction.find((int)UNLOAD_DB_ID);
    static final String DESTROY_DB_CMD = "Grid_Nav.DestroyDB";
    static final int DESTROY_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DestroyDB");
    static final IdeAction ACTION_DESTROY_DB = IdeAction.find((int)DESTROY_DB_ID);
    static final String REDISTRIBUTE_DB_CMD = "Grid_Nav.RedistributeDB";
    static final int REDISTRIBUTE_DB_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.RedistributeDB");
    static final IdeAction ACTION_REDISTRIBUTE_DB = IdeAction.find((int)REDISTRIBUTE_DB_ID);
    static final String CONN_CMD = "Grid_Nav.Connectable";
    static final int CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Connectable");
    static final IdeAction ACTION_CONN = IdeAction.find((int)CONN_ID);
    static final String NEW_CS_CONN_CMD = "Grid_Nav.NewCSConn";
    static final int NEW_CS_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewCSConn");
    static final IdeAction ACTION_NEW_CS_CONN = IdeAction.find((int)NEW_CS_CONN_ID);
    static final String NEW_D_CONN_CMD = "Grid_Nav.NewDirConn";
    static final int NEW_D_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewDirConn");
    static final IdeAction ACTION_NEW_D_CONN = IdeAction.find((int)NEW_D_CONN_ID);
    static final String EXPORT_CONN_CMD = "Grid_Nav.ExportConn";
    static final int EXPORT_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ExportConn");
    static final IdeAction ACTION_EXPORT_CONN = IdeAction.find((int)EXPORT_CONN_ID);
    static final String DELETE_CONN_CMD = "Grid_Nav.DeleteConn";
    static final int DELETE_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeleteConn");
    static final IdeAction ACTION_DELETE_CONN = IdeAction.find((int)DELETE_CONN_ID);
    static final String EDIT_CONN_CMD = "Grid_Nav.EditConnectable";
    static final int EDIT_CONN_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.EditConnectable");
    static final IdeAction ACTION_EDIT_CONN = IdeAction.find((int)EDIT_CONN_ID);
    static final String NEW_PG_CMD = "Grid_Nav.NewPG";
    static final int NEW_PG_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.NewPG");
    static final IdeAction ACTION_NEW_PG = IdeAction.find((int)NEW_PG_ID);
    static final String EDIT_PG_CMD = "Grid_Nav.EditPG";
    static final int EDIT_PG_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.EditPG");
    static final IdeAction ACTION_EDIT_PG = IdeAction.find((int)EDIT_PG_ID);
    static final String DELETE_PG_CMD = "Grid_Nav.DeletePG";
    static final int DELETE_PG_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DeletePG");
    static final IdeAction ACTION_DELETE_PG = IdeAction.find((int)DELETE_PG_ID);
    static final String SHELL_PROMPT_CMD = "Grid_Nav.Shell";
    static final int SHELL_PROMPT_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Shell");
    static final IdeAction SHELL_PROMPT_PG = IdeAction.find((int)SHELL_PROMPT_ID);
    static final String EXPORT_CMD = "Grid_Nav.Export";
    static final int EXPORT_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Export");
    static final IdeAction ACTION_EXPORT = IdeAction.find((int)EXPORT_ID);
    static final String IMPORT_CMD = "Grid_Nav.Import";
    static final int IMPORT_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Import");
    static final IdeAction ACTION_IMPORT = IdeAction.find((int)IMPORT_ID);
    static final String FILTER_CMD = "Grid_Nav.FilterHost";
    static final int FILTER_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.FilterHost");
    static final IdeAction ACTION_FILTER = IdeAction.find((int)FILTER_ID);
    static final String CLEAR_FILTER_CMD = "Grid_Nav.ClearFilterHost";
    static final int CLEAR_FILTER_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.ClearFilterHost");
    static final IdeAction ACTION_CLEAR_FILTER = IdeAction.find((int)CLEAR_FILTER_ID);
    static final String CREATE_REPOSITORY_CMD = "Grid_Nav.CreateRepository";
    static final int CREATE_REPOSITORY_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.CreateRepository");
    static final IdeAction ACTION_CREATE_REPOSITORY = IdeAction.find((int)CREATE_REPOSITORY_ID);
    static final String DETACH_REPOSITORY_CMD = "Grid_Nav.DetachRepository";
    static final int DETACH_REPOSITORY_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.DetachRepository");
    static final IdeAction ACTION_DETACH_REPOSITORY = IdeAction.find((int)DETACH_REPOSITORY_ID);
    static final List<Integer> commandIDList = Arrays.asList(GRID_WIZARD_ID, NEW_GRID_ID, MANAGE_GRID_ID, TEST_GRID_ID, START_GRID_ID, GRID_CONN_ID, GRID_DISCONN_ID, STOP_GRID_ID, CREATE_DB_ID, EXPORT_DBDEF_ID, DELETE_DBDEF_ID, EXPORT_MODEL_ID, EXPORT_CLIENT_ID, APPLY_GRID_ID, REMOVE_GRID_ID, GRID_SHOW_CHANGES_ID, GRID_EXEC_ALL_ID, GRID_PROP_ID, INST_STATUS_ID, USE_CURRENT_MODEL_ID, USE_LATEST_MODEL_ID, GRID_VIEW_MSGLOG_ID, GRID_VIEW_ERRORLOG_ID, NEW_DB_ID, NEW_DBDEF_ID, EDIT_DBDEF_ID, NEW_HOST_ID, ASSIGN_DSGS_ID, CLONE_HOST_ID, EDIT_HOST_ID, DELETE_HOST_ID, NEW_INSTALLATION_ID, DELETE_INSTALLATION_ID, NEW_INSTANCE_ID, NEW_MGMT_INSTANCE_ID, MGMT_INSTANCE_ID, NEW_DATA_INSTANCE_ID, SWITCH_INSTANCE_ID, STDBY_START_ID, STDBY_STOP_ID, REPLACE_ID, HOST_EXEC_ID, START_INSTANCE_ID, START_SERVER_INST_ID, STOP_INSTANCE_ID, STOP_SERVER_INST_ID, INSTANCE_EXEC_ID, EDIT_INSTANCE_ID, DELETE_INSTANCE_ID, START_DB_ID, STOP_DB_ID, LOAD_DB_ID, OPEN_DB_ID, CLOSE_DB_ID, UNLOAD_DB_ID, DESTROY_DB_ID, REDISTRIBUTE_DB_ID, CONN_ID, NEW_CS_CONN_ID, NEW_D_CONN_ID, EXPORT_CONN_ID, DELETE_CONN_ID, EDIT_CONN_ID, NEW_PG_ID, EDIT_PG_ID, DELETE_PG_ID, SHELL_PROMPT_ID, EXPORT_ID, IMPORT_ID, FILTER_ID, CLEAR_FILTER_ID, CREATE_REPOSITORY_ID, DETACH_REPOSITORY_ID);
    private static final Logger logger = Logger.getLogger(GridNavigatorContextMenu.class.getName());

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Object object;
        boolean bl;
        boolean bl2 = false;
        int n = ideAction.getCommandId();
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        if (!commandIDList.contains(n)) {
            return false;
        }
        if (n == GRID_WIZARD_ID) {
            TTGridWizMain.getInstance().launchWizard();
            return true;
        }
        if (n == NEW_GRID_ID) {
            this.launchNewGrid();
            return true;
        }
        if (n == MANAGE_GRID_ID) {
            this.launchManageGridUI(null);
            return true;
        }
        if (n == TEST_GRID_ID) {
            this.launchTestGridUI();
            return true;
        }
        if (gridObject == null) {
            return false;
        }
        if (n == GRID_PROP_ID) {
            this.launchManageGridUI(gridObject);
            return true;
        }
        if (n == REMOVE_GRID_ID) {
            if (gridObject != null && Common.displayConfirm((Component)Ide.getMainWindow(), Messages.getString("TimestenGrid.removeGridDialog"), Messages.getString("TimestenGrid.removeGrid"), null, true)) {
                gridObject.getExecutor().disconnectSSHSession();
                TTGridRootNode.getStorage().removeGrid(gridObject.getName());
                TTGridRootNode.getStorage().removeGuidFromFilters(gridObject.getGUID());
                TTGridRootNode.getInstance().removeGrid(gridObject);
                gridObject.closeEditors();
            }
            return true;
        }
        if (gridObject.getExecutor().getWorkingHost().getPwd() == null && gridObject.getExecutor().getWorkingHost().getKeyFile() == null && !(bl = GridNavigatorContextMenu.promptForPasswordKeyFile(gridObject))) {
            return true;
        }
        if (n == GRID_CONN_ID) {
            GridMouseListener.updateGridInfo(gridObject.getGridNode().getCustomTree(), TTGridRootNode.getInstance().getGridPath(), gridObject, false, false);
            bl2 = true;
        } else if (n == GRID_DISCONN_ID) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("TimesTenGrid.discFromGridConfirm"), gridObject.getShortName()), (String)Messages.getString("TimesTenGrid.discFromGridConfirmTitle"), null, (boolean)true)) {
                gridObject.disconnect();
            }
            bl2 = true;
        } else if (n == APPLY_GRID_ID) {
            LatestModelChangesPanel latestModelChangesPanel = new LatestModelChangesPanel(gridObject, true, true);
            object = UIUtils.createPanelDialog((JPanel)latestModelChangesPanel, (String)Messages.getString("TimesTenGrid.MCWarningTitle"), (ActionListener)latestModelChangesPanel);
            latestModelChangesPanel.setDialog((JEWTDialog)object);
            object.setButtonMask(7);
            object.setCancelButtonText(Messages.getString("TimesTen.common.no"));
            object.setOKButtonText(Messages.getString("TimesTen.common.yes"));
            object.setDefaultCloseOperation(2);
            object.setSize(400, 300);
            HelpSystem.getHelpSystem().registerTopic((JComponent)latestModelChangesPanel, TimesTenHelpID.GRID_APPLY_CHANGES.toString());
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)object);
            object.getComponent(object.getCancelButtonMnemonic()).setFocusable(true);
            bl2 = true;
        } else if (n == EXPORT_MODEL_ID || n == EXPORT_ID) {
            ExportImportPanel.ExportImportObject exportImportObject = null;
            if (n == EXPORT_MODEL_ID) {
                exportImportObject = ExportImportPanel.ExportImportObject.GRID_MODEL;
            } else {
                object = (AbstractNode)context.getNode();
                if (object.isMembershipConfigNode()) {
                    exportImportObject = ExportImportPanel.ExportImportObject.MEMBERSHIP_CONFIGURATION;
                } else if (object.isInstanceConfigNode()) {
                    exportImportObject = ExportImportPanel.ExportImportObject.INSTANCE_CONFIGURATION;
                } else if (object.isSQLNetNode()) {
                    exportImportObject = ExportImportPanel.ExportImportObject.SQLNET;
                } else if (object.isTNSNamesNode()) {
                    exportImportObject = ExportImportPanel.ExportImportObject.TNS_NAMES;
                }
            }
            this.launchExportImportUI(gridObject, exportImportObject, true);
            bl2 = true;
        } else if (n == EXPORT_CLIENT_ID) {
            this.launchExportClientDSN();
            bl2 = true;
        } else if (n == IMPORT_ID) {
            ExportImportPanel.ExportImportObject exportImportObject = null;
            object = (AbstractNode)context.getNode();
            if (object.isMembershipConfigNode()) {
                exportImportObject = ExportImportPanel.ExportImportObject.MEMBERSHIP_CONFIGURATION;
            } else if (object.isInstanceConfigNode()) {
                exportImportObject = ExportImportPanel.ExportImportObject.INSTANCE_CONFIGURATION;
            } else if (object.isSQLNetNode()) {
                exportImportObject = ExportImportPanel.ExportImportObject.SQLNET;
            } else if (object.isTNSNamesNode()) {
                exportImportObject = ExportImportPanel.ExportImportObject.TNS_NAMES;
            }
            this.launchExportImportUI(gridObject, exportImportObject, false);
            bl2 = true;
        } else if (n == USE_CURRENT_MODEL_ID) {
            GridMouseListener.updateGridInfo(gridObject.getGridNode().getCustomTree(), null, gridObject, false, false, GridObject.ModelVersion.CURRENT);
            bl2 = true;
        } else if (n == USE_LATEST_MODEL_ID) {
            GridMouseListener.updateGridInfo(gridObject.getGridNode().getCustomTree(), null, gridObject, false, false);
            bl2 = true;
        } else if (n == STOP_GRID_ID) {
            StopGridWizardMain.getInstance().launchWizard();
            bl2 = true;
        } else if (n == START_GRID_ID) {
            StartGridWizardMain.getInstance().launchWizard();
            bl2 = true;
        } else if (n == NEW_DATA_INSTANCE_ID) {
            this.launchNewInstanceWizardUI(false);
        }
        if (n == GRID_EXEC_ALL_ID) {
            this.launchExecUI(new ExecuteCommandPanel(gridObject));
            bl2 = true;
        } else if (n == GRID_VIEW_MSGLOG_ID) {
            this.launchViewLogsUI(gridObject, LogInspectorMainWindow.LogViewerType.MSG);
            bl2 = true;
        } else if (n == GRID_VIEW_ERRORLOG_ID) {
            this.launchViewLogsUI(gridObject, LogInspectorMainWindow.LogViewerType.ERROR);
            bl2 = true;
        } else if (n == GRID_SHOW_CHANGES_ID) {
            this.launchShowChanges(gridObject);
            bl2 = true;
        } else if (n == SHELL_PROMPT_ID) {
            GridMouseListener.openEditor(gridObject.getGridNode().getShellNode(), null, gridObject);
            bl2 = true;
        } else if (n == INST_STATUS_ID) {
            GridMouseListener.openEditor(gridObject.getGridNode().getInstStatusNode(), null, gridObject);
            bl2 = true;
        }
        if (n == LOAD_DB_ID || n == START_DB_ID) {
            String string = context.getNode().getShortLabel();
            object = gridObject.getDatabase(string);
            gridObject.updateDBStatusOnRaptorTask((DatabaseObject)object, () -> GridNavigatorContextMenu.lambda$handleEvent$0((DatabaseObject)object, gridObject, string, n));
            bl2 = true;
        } else if (n == NEW_MGMT_INSTANCE_ID || n == MGMT_INSTANCE_ID) {
            this.launchNewInstanceWizardUI(true);
            bl2 = true;
        } else if (n == SWITCH_INSTANCE_ID) {
            ActiveStandbyPairManagement activeStandbyPairManagement = new ActiveStandbyPairManagement(gridObject);
            activeStandbyPairManagement.activeSwitch();
            bl2 = true;
        } else if (n == STDBY_START_ID) {
            ActiveStandbyPairManagement activeStandbyPairManagement = new ActiveStandbyPairManagement(gridObject);
            activeStandbyPairManagement.standbyStart();
            bl2 = true;
        } else if (n == STDBY_STOP_ID) {
            ActiveStandbyPairManagement activeStandbyPairManagement = new ActiveStandbyPairManagement(gridObject);
            activeStandbyPairManagement.stopStandby();
            bl2 = true;
        } else if (n == REPLACE_ID) {
            object = TTGridRootNode.getInstance();
            InstanceObject instanceObject = context.getNode().getShortLabel().contains(".") ? gridObject.getInstance(context.getNode().getShortLabel()) : gridObject.getInstance(((TTGridRootNode)((Object)object)).getCurrentHost(), context.getNode().getShortLabel());
            this.launchGUI(new NewInstanceWizard(true, instanceObject), Messages.getString("TimestenGrid.replaceMgmtTitle"), new Dimension(500, 430));
            bl2 = true;
        } else if (n == OPEN_DB_ID) {
            final String string = context.getNode().getShortLabel();
            GridCommand gridCommand = GridCommand.OPEN_DATABASE;
            gridCommand.prepareCommand(string);
            object = gridObject.getDatabase(string);
            gridObject.updateDBStatusOnRaptorTask((DatabaseObject)object, () -> {
                if (gridObject.getDatabase(string).getElementInDistMap().size() == 0) {
                    if (Common.displayConfirm((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbNoDistributionMessage"), Messages.getString("TimesTenGrid.openDB"), null, true)) {
                        DatabaseDistributionPanel.showDialog(gridObject, gridObject.getDatabase(string));
                    }
                } else {
                    gridObject.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.openingDBCommand"), string), gridCommand, new Runnable(){

                        @Override
                        public void run() {
                            Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.openDBStarted"), string), Messages.getString("TimesTenGrid.commandIssued"));
                        }
                    }, false);
                }
            });
            bl2 = true;
        } else if (n == REDISTRIBUTE_DB_ID) {
            String string = context.getNode().getShortLabel();
            object = gridObject.getDatabase(string);
            gridObject.updateDBStatusOnRaptorTask((DatabaseObject)object, () -> DatabaseDistributionPanel.showDialog(gridObject, gridObject.getDatabase(string)));
            bl2 = true;
        } else if (n == DESTROY_DB_ID) {
            String string = context.getNode().getShortLabel();
            object = gridObject.getDatabase(string);
            Runnable runnable = () -> GridNavigatorContextMenu.lambda$handleEvent$3(gridObject, (DatabaseObject)object);
            gridObject.updateDatabasesConnectionCountOnRaptorTask((DatabaseObject)object, runnable);
            bl2 = true;
        } else if (n == NEW_CS_CONN_ID) {
            String string = TTGridRootNode.getInstance().getCurrentDB();
            this.launchNewConnectable(gridObject, gridObject.getDBDef(string), true);
            bl2 = true;
        } else if (n == NEW_D_CONN_ID) {
            String string = TTGridRootNode.getInstance().getCurrentDB();
            this.launchNewConnectable(gridObject, gridObject.getDBDef(string), false);
            bl2 = true;
        } else if (n == EXPORT_CONN_ID) {
            String string = context.getNode().getShortLabel();
            object = TTGridRootNode.getInstance().getCurrentDB();
            ConnectableObject connectableObject = gridObject.getDBDef((String)object).getConnectable(string);
            DatabaseConnectablesPanel.exportMenuActionPerformed(connectableObject);
            bl2 = true;
        } else if (n == DELETE_CONN_ID) {
            String string = context.getNode().getShortLabel();
            object = TTGridRootNode.getInstance().getCurrentDB();
            ConnectableObject connectableObject = gridObject.getDBDef((String)object).getConnectable(string);
            connectableObject.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteConnectable"), string), Messages.getString("TimesTenGrid.deleteConnTitle"), null, () -> this.closeEditor(gridObject, ConnectablesEditor.class, string));
        } else if (n == EDIT_CONN_ID) {
            String string = context.getNode().getShortLabel();
            object = TTGridRootNode.getInstance().getCurrentDB();
            this.launchEditConnectable(gridObject, gridObject.getDBDef((String)object), gridObject.getDBDef((String)object).getConnectable(string));
        } else if (n == EXPORT_DBDEF_ID) {
            String string = TTGridRootNode.getInstance().getCurrentDB();
            gridObject.getDBDef(string).exportDBDef();
        } else if (n == DELETE_DBDEF_ID) {
            String string = context.getNode().getShortLabel();
            object = gridObject.getDBDef(string);
            object.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.destroyDBDefWNameConfirmation"), string), Messages.getString("TimesTenGrid.destroyDBDefConfirmation"), null, () -> this.lambda$handleEvent$5(gridObject, (DBDefObject)object));
            bl2 = true;
        } else if (n == CREATE_DB_ID) {
            final String string = context.getNode().getShortLabel();
            if (gridObject.getAllDataInstances().size() == 0) {
                Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.dbNotCreatedNoDataInst"), string));
                return true;
            }
            GridCommand gridCommand = GridCommand.CREATE_DATABASE;
            gridCommand.prepareCommand(string);
            gridObject.executeCommandOnRaptorTask(Messages.getString("TimesTenGrid.creatingDB"), gridCommand, new Runnable(){

                @Override
                public void run() {
                    Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.successcreatingDB"), string), Messages.getString("TimesTenGrid.commandIssued"));
                }
            }, true);
            bl2 = true;
        } else if (n == NEW_DB_ID) {
            if (gridObject.getAllDataInstances().size() == 0) {
                Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.cantCreateDBsNoDataInst"));
                return true;
            }
            WizardMain.getInstance().launchWizard();
            bl2 = true;
        } else if (n == NEW_DBDEF_ID) {
            this.launchNewDBDef(gridObject);
            bl2 = true;
        } else if (n == EDIT_DBDEF_ID) {
            String string = context.getNode().getShortLabel();
            this.launchEditDBDef(gridObject, gridObject.getDBDef(string));
            bl2 = true;
        } else if (n == STOP_DB_ID || n == CLOSE_DB_ID || n == UNLOAD_DB_ID) {
            String string = context.getNode().getShortLabel();
            this.showDisconnectionConfirmation(gridObject.getDatabase(string), gridObject, n);
            bl2 = true;
        } else if (n == START_INSTANCE_ID || n == START_SERVER_INST_ID || n == EDIT_INSTANCE_ID || n == STOP_INSTANCE_ID || n == STOP_SERVER_INST_ID || n == INSTANCE_EXEC_ID) {
            HostObject hostObject = gridObject.getHost(TTGridRootNode.getInstance().getCurrentHost());
            object = gridObject.getInstance(hostObject, context.getNode().getShortLabel());
            if (n == START_INSTANCE_ID) {
                InstanceActionPanel.showStartInstanceDialog((InstanceObject)object);
            } else if (n == START_SERVER_INST_ID) {
                InstanceActionPanel.showStartServerInstDialog((InstanceObject)object);
            } else if (n == EDIT_INSTANCE_ID) {
                this.launchEditInstanceUI((InstanceObject)object);
            } else if (n == STOP_INSTANCE_ID) {
                InstanceActionPanel.showStopInstanceDialog((InstanceObject)object);
            } else if (n == STOP_SERVER_INST_ID) {
                InstanceActionPanel.showStopServerInstDialog((InstanceObject)object);
            } else if (n == INSTANCE_EXEC_ID) {
                this.launchExecUI(new ExecuteCommandPanel((InstanceObject)object, gridObject));
            }
            bl2 = true;
        } else if (n == HOST_EXEC_ID) {
            HostObject hostObject = gridObject.getHost(TTGridRootNode.getInstance().getCurrentHost());
            this.launchExecUI(new ExecuteCommandPanel(hostObject, gridObject));
            bl2 = true;
        } else if (n == DELETE_HOST_ID) {
            HostObject hostObject = gridObject.getHost(TTGridRootNode.getInstance().getCurrentHost());
            if (hostObject != null && hostObject.canBeDeleted(gridObject)) {
                hostObject.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteHostInfo"), hostObject.getName()), Messages.getString("TimesTenGrid.deleteHost"), null, () -> this.closeEditor(gridObject, HostEditor.class, hostObject.getName()));
            }
            bl2 = true;
        } else if (n == NEW_HOST_ID) {
            this.launchNewHostUI();
            bl2 = true;
        } else if (FILTER_ID == n) {
            gridObject.getGridNode().launchNodeFilter(gridObject);
            bl2 = true;
        } else if (CLEAR_FILTER_ID == n) {
            gridObject.getGridNode().clearHostFilter(gridObject);
            bl2 = true;
        } else if (n == ASSIGN_DSGS_ID) {
            this.launchAssignDSGsUI(gridObject);
            bl2 = true;
        } else if (n == CLONE_HOST_ID) {
            this.launchCloneHostUI(context.getNode().getShortLabel());
            bl2 = true;
        } else if (n == NEW_PG_ID) {
            this.launchNewPGUI();
            bl2 = true;
        } else if (n == EDIT_PG_ID) {
            this.launchEditPG(gridObject.getPhysicalGroup(context.getNode().getShortLabel()));
            bl2 = true;
        } else if (n == DELETE_PG_ID) {
            PhysicalGroupObject physicalGroupObject = gridObject.getPhysicalGroup(context.getNode().getShortLabel());
            physicalGroupObject.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleteConfirmation"), physicalGroupObject.getName()), Messages.getString("TimesTenGrid.physicalGroupDelete"), null, null);
            bl2 = true;
        } else if (n == EDIT_HOST_ID) {
            this.launchEditHostUI(context.getNode().getShortLabel());
            bl2 = true;
        } else if (n == NEW_INSTANCE_ID) {
            this.launchNewInstanceUI();
            bl2 = true;
        } else if (n == NEW_INSTALLATION_ID) {
            this.launchNewInstallationUI(gridObject.getHost(TTGridRootNode.getInstance().getCurrentHost()));
            bl2 = true;
        } else if (n == DELETE_INSTALLATION_ID) {
            InstallationObject installationObject = gridObject.getHost(TTGridRootNode.getInstance().getCurrentHost()).getInstallation(context.getNode().getShortLabel());
            installationObject.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.installationDeleteConfirmation"), installationObject.getFullName()), Messages.getString("TimesTenGrid.installationDelete"), null, () -> this.closeEditor(gridObject, InstallationEditor.class, installationObject.getFullName()));
            bl2 = true;
        } else if (n == DELETE_INSTANCE_ID) {
            String string = context.getNode().getShortLabel();
            object = string.contains(".") ? gridObject.getInstance(string) : gridObject.getInstance(TTGridRootNode.getInstance().getCurrentHost(), string);
            if (((InstanceObject)object).isMgmtInstance()) {
                TTGridRootNode.getInstance().setCurrentHost(((InstanceObject)object).getHost().getName());
                object.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteInstanceConfirm"), ((InstanceObject)object).getFullName()), Messages.getString("TimesTenGrid.deleteInstance"), null, () -> this.lambda$handleEvent$8(gridObject, (InstanceObject)object));
            } else {
                object.deleteConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteInstanceInfo"), ((InstanceObject)object).getFullName()), Messages.getString("TimesTenGrid.deleteInstance"), null, () -> this.lambda$handleEvent$9(gridObject, (InstanceObject)object));
            }
            bl2 = true;
        } else if (n == CREATE_REPOSITORY_ID) {
            this.launchGUI(new CreateRepositoryPanel(), Messages.getString("TimesTenGrid.RepositoryCreate"), new Dimension(450, 300));
            bl2 = true;
        } else if (n == DETACH_REPOSITORY_ID) {
            String string = context.getNode().getShortLabel();
            object = gridObject.getRepository(string);
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("TimesTenGrid.RepositoryDetachConfirm"), string), (String)Messages.getString("TimesTenGrid.RepositoryDetach"), null, (boolean)true)) {
                ((RepositoryObject)object).detach(() -> this.closeEditor(gridObject, RepositoryEditor.class, string));
            }
            bl2 = true;
        }
        return bl2;
    }

    private void closeEditor(GridObject gridObject, Class<?> clazz, String string) {
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof TTBaseEditor) || !editor.getContext().getProperty("gridName").equals(gridObject.getName())) continue;
            StringBuilder stringBuilder = new StringBuilder();
            if (editor instanceof InstanceEditor || editor instanceof InstallationEditor) {
                stringBuilder.append(TTGridRootNode.getInstance().getCurrentHost());
                stringBuilder.append(".");
            }
            stringBuilder.append(editor.getContext().getNode().getShortLabel());
            if (!clazz.isInstance(editor) || !string.equals(stringBuilder.toString())) continue;
            List<TTBaseEditor> list = Arrays.asList((TTBaseEditor)editor);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(list));
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    Logger.getLogger(GridObject.class.getName()).log(Level.SEVERE, exception.getMessage());
                }
                continue;
            }
            EditorManager.getEditorManager().closeEditors(list);
        }
    }

    private void showDisconnectionConfirmation(DatabaseObject databaseObject, GridObject gridObject, int n) {
        Runnable runnable = () -> {
            Runnable runnable = null;
            String string = "";
            String string2 = "";
            String string3 = databaseObject.getName();
            boolean bl = Common.gridVersionGreaterThanOrEqual(gridObject, "18.1.2.0.0");
            JCheckBox jCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.forceDisconnect"));
            if (n == CLOSE_DB_ID) {
                if (!databaseObject.getDBStatus().isOpen()) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbIsAlreadyClosed"));
                    return;
                }
                string = Messages.getString("TimesTenGrid.closeDBConfirmTitle");
                string2 = Messages.getString("TimesTenGrid.closeDBConfirm");
                runnable = () -> {
                    GridCommand gridCommand = GridCommand.CLOSE_DATABASE;
                    gridCommand.prepareCommand(string3);
                    gridObject.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.closingDBCommand"), string3), gridCommand, () -> Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.closeDBStarted"), string3), Messages.getString("TimesTenGrid.commandIssued")), false);
                };
            } else if (n == UNLOAD_DB_ID) {
                if (databaseObject.getDBStatus().isOpen()) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbIsOpen"));
                    return;
                }
                if (!databaseObject.getDBStatus().isLoaded()) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbIsAlreadyUnloaded"));
                    return;
                }
                string = Messages.getString("TimesTenGrid.unloadDBConfirmTitle");
                string2 = bl ? Messages.getString("TimesTenGrid.unloadDBConfirmDBDisconn") : Messages.getString("TimesTenGrid.unloadDBConfirm");
                runnable = () -> {
                    GridCommand gridCommand = GridCommand.UNLOAD_DATABASE;
                    if (bl) {
                        gridCommand = GridCommand.PERL_UNLOAD_DATABASE;
                        String string2 = jCheckBox.isSelected() ? "-forceDisconnect" : "";
                        gridCommand.prepareCommand(string3, string2);
                        gridObject.executePerlOnSwingWorker(MessageFormat.format(Messages.getString("TimesTenGrid.tituloUnloadDBCommand"), string3), MessageFormat.format(Messages.getString("TimesTenGrid.unloadingDBCommand"), string3), gridCommand, MessageFormat.format(Messages.getString("TimesTenGrid.successUnloadDBCommand"), string3), MessageFormat.format(Messages.getString("TimesTenGrid.failedUnloadDBCommand"), string3));
                    } else {
                        gridCommand.prepareCommand(string3);
                        gridObject.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.unloadingDBCommand"), string3), gridCommand, () -> Common.displayInfoMsg(null, MessageFormat.format(Messages.getString("TimesTenGrid.unloadDBStarted"), string3), Messages.getString("TimesTenGrid.commandIssued")), false);
                    }
                };
            } else if (n == STOP_DB_ID) {
                string = Messages.getString("TimesTenGrid.stopDBConfirmTitle");
                string2 = bl ? Messages.getString("TimesTenGrid.stopDBConfirmDBDisconn") : Messages.getString("TimesTenGrid.stopDBConfirm");
                if (!databaseObject.getDBStatus().isLoaded()) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbIsAlreadyStopped"));
                    return;
                }
                runnable = () -> {
                    GridCommand gridCommand = GridCommand.PERL_STOP_DATABASE;
                    String string2 = bl ? "-dbDisconnect" : "";
                    String string3 = jCheckBox.isSelected() ? "-forceDisconnect" : "";
                    gridCommand.prepareCommand(string3, string2, string3);
                    gridObject.executePerlOnSwingWorker(MessageFormat.format(Messages.getString("TimesTenGrid.tituloStopDBCommand"), string3), MessageFormat.format(Messages.getString("TimesTenGrid.stopingDBCommand"), string3), gridCommand, MessageFormat.format(Messages.getString("TimesTenGrid.successStopDBCommand"), string3), MessageFormat.format(Messages.getString("TimesTenGrid.failedStopDBCommand"), string3));
                };
            }
            JTextPane jTextPane = new JTextPane();
            jTextPane.setOpaque(false);
            jTextPane.setEditable(false);
            jTextPane.setFocusable(false);
            jTextPane.setBackground(UIManager.getColor("Label.background"));
            jTextPane.setFont(UIManager.getFont("Label.font"));
            jTextPane.setBorder(UIManager.getBorder("Label.border"));
            Rectangle rectangle = jTextPane.getBounds();
            rectangle.width = 250;
            rectangle.height = 80;
            jTextPane.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
            jTextPane.setText(MessageFormat.format(string2, string3));
            JTextPane jTextPane2 = new JTextPane();
            jTextPane2.setOpaque(false);
            jTextPane2.setEditable(false);
            jTextPane2.setFocusable(false);
            jTextPane2.setBackground(UIManager.getColor("Label.background"));
            jTextPane2.setFont(UIManager.getFont("Label.font"));
            jTextPane2.setBorder(UIManager.getBorder("Label.border"));
            Rectangle rectangle2 = jTextPane2.getBounds();
            rectangle2.width = 250;
            rectangle2.height = 80;
            jTextPane2.setPreferredSize(new Dimension(rectangle2.width, rectangle2.height));
            jTextPane2.setText(Messages.getString("TimesTenGrid.forceDisconnectWarning"));
            TTGUIBasePanel tTGUIBasePanel = new TTGUIBasePanel();
            tTGUIBasePanel.setLayout(new GridBagLayout());
            tTGUIBasePanel.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (bl && n != CLOSE_DB_ID) {
                Object[] objectArray = new Object[]{jTextPane, jCheckBox, jTextPane2};
                tTGUIBasePanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                tTGUIBasePanel.add((Component)jTextPane2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                Object[] objectArray = new Object[]{jTextPane};
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)tTGUIBasePanel, TimesTenHelpID.STOP_CLOSE_UNLOAD.toString());
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)tTGUIBasePanel, (String)string, (ActionListener)tTGUIBasePanel);
            tTGUIBasePanel.setDialog(jEWTDialog);
            jEWTDialog.setButtonMask(7);
            Dimension dimension = new Dimension(400, 200);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.addActionListener((ActionListener)tTGUIBasePanel);
            jEWTDialog.setVisible(true);
            if (jEWTDialog.isOked()) {
                runnable.run();
            }
        };
        gridObject.updateDatabasesConnectionCountOnRaptorTask(databaseObject, runnable);
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        AbstractNode abstractNode = (AbstractNode)element;
        if (!bl && element instanceof TTGridRootNode) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_GRID_WIZARD), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_GRID), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_MANAGE_GRID), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_TEST_GRID), MenuConstants.SECTION_FILE_EXIT);
        } else if (!bl && abstractNode.isGridNode()) {
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            GridObject gridObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid());
            boolean bl2 = gridObject != null && gridObject.isPopulated();
            JMenu jMenu = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.new"), Integer.valueOf(0));
            jMenu.add((Action)ACTION_NEW_DATA_INSTANCE);
            jMenu.add((Action)ACTION_MGMT_INSTANCE);
            jMenu.setEnabled(bl2);
            contextMenu.add((Component)jMenu, 1.0f);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_GRID_CONN);
            jMenuItem.setEnabled(!bl2);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_GRID_DISCONN);
            jMenuItem.setEnabled(gridObject.isPopulated());
            contextMenu.add((Component)jMenuItem, 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_REMOVE_GRID), 1.0f);
            JMenu jMenu2 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.gridModel"), Integer.valueOf(0));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)ACTION_GRID_SHOW_CHANGES));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)ACTION_APPLY_GRID));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)ACTION_EXPORT_MODEL));
            JMenu jMenu3 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.SyncGrid"), Integer.valueOf(0));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((Action)ACTION_USE_LATEST_MODEL);
            jRadioButtonMenuItem.setSelected(gridObject.getShowingVersion() == GridObject.ModelVersion.LATEST);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu3.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem((Action)ACTION_USE_CURRENT_MODEL);
            jRadioButtonMenuItem.setSelected(gridObject.getShowingVersion() == GridObject.ModelVersion.CURRENT);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu3.add(jRadioButtonMenuItem);
            jMenu2.add(jMenu3);
            jMenu2.setEnabled(bl2);
            contextMenu.add((Component)jMenu2, MenuConstants.SECTION_FILE_IMPORT_EXPORT);
            JMenu jMenu4 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.InspectLogMenu"), Integer.valueOf(0));
            jMenu4.add((Action)ACTION_VIEW_MSGLOG);
            jMenu4.add((Action)ACTION_VIEW_ERRORLOG);
            jMenu4.setEnabled(bl2);
            contextMenu.add((Component)jMenu4, MenuConstants.SECTION_FILE_ADDINS);
            JMenu jMenu5 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.gridCtrl"), Integer.valueOf(0));
            jMenu5.add(contextMenu.createMenuItem((ToggleAction)ACTION_START_GRID));
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_INST_STATUS);
            jMenuItem.setEnabled(bl2);
            jMenu5.add(jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_SWITCH_INSTANCE);
            jMenuItem.setEnabled(bl2);
            jMenu5.add(jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_STDBY_START);
            jMenuItem.setEnabled(bl2);
            jMenu5.add(jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_STDBY_STOP);
            jMenuItem.setEnabled(bl2);
            jMenu5.add(jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_STOP_GRID);
            jMenuItem.setEnabled(bl2);
            jMenu5.add(jMenuItem);
            contextMenu.add((Component)jMenu5, MenuConstants.SECTION_FILE_ADDINS);
            JMenu jMenu6 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.execute"), Integer.valueOf(0));
            jMenu6.add((Action)ACTION_GRID_EXEC_ALL);
            jMenu6.add((Action)SHELL_PROMPT_PG);
            jMenu6.setEnabled(bl2);
            contextMenu.add((Component)jMenu6, MenuConstants.SECTION_FILE_ADDINS);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_GRID_PROP), MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
        } else if (!bl && abstractNode.isDBDefFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_DBDEF), 1.0f);
        } else if (!bl && abstractNode.isDatabaseFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_DB), 1.0f);
        } else if (!bl && abstractNode.isDBDefNode()) {
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            DBDefObject dBDefObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid()).getDBDef(tTGridRootNode.getCurrentDB());
            boolean bl3 = dBDefObject.isAppliedToCurrent();
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_CREATE_DB);
            jMenuItem.setEnabled(bl3);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_EDIT_DBDEF);
            contextMenu.add((Component)jMenuItem, 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_EXPORT_DBDEF), JDeveloperMenuConstants.SECTION_FILE_ERASE_REMOVE);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_DBDEF), JDeveloperMenuConstants.SECTION_FILE_ADDINS);
        } else if (!bl && abstractNode.isHostFolderNode()) {
            if (abstractNode.isMgmtHostFolderNode()) {
                JMenu jMenu = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.gridMgmt"), Integer.valueOf(0));
                jMenu.add((Action)ACTION_SWITCH_INSTANCE);
                jMenu.add((Action)ACTION_STDBY_START);
                jMenu.add((Action)ACTION_STDBY_STOP);
                jMenu.add((Action)ACTION_NEW_MGMT_INSTANCE);
                jMenu.setEnabled(true);
                contextMenu.add((Component)jMenu, 1.0f);
            } else {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_HOST), 1.0f);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_ASSIGN_DSGS), 1.0f);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_FILTER), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_CLEAR_FILTER), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            }
        } else if (!bl && abstractNode.isHostNode()) {
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            HostObject hostObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid()).getHost(tTGridRootNode.getCurrentHost());
            boolean bl4 = hostObject.isAppliedToCurrent();
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_CLONE_HOST), 1.0f);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_HOST_EXEC);
            jMenuItem.setEnabled(bl4);
            contextMenu.add((Component)jMenuItem, 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_EDIT_HOST), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_HOST), JDeveloperMenuConstants.SECTION_FILE_ERASE_REMOVE);
        } else if (!bl && abstractNode.isInstallationFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_INSTALLATION), 1.0f);
        } else if (!bl && abstractNode.isInstallationNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_INSTALLATION), 1.0f);
        } else if (!bl && abstractNode.isInstanceFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_INSTANCE), 1.0f);
        } else if (!bl && abstractNode.isMgmtInstanceNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_REPLACE), 1.0f);
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            GridObject gridObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid());
            String string = gridObject.getExecutor().getWorkingHost().getHostName() + "." + gridObject.getExecutor().getWorkingHost().getInstanceName();
            InstanceObject instanceObject = context.getNode().getShortLabel().contains(".") ? gridObject.getInstance(context.getNode().getShortLabel()) : gridObject.getInstance(tTGridRootNode.getCurrentHost(), context.getNode().getShortLabel());
            if (!instanceObject.isAppliedToCurrent() || gridObject.getProperties().getVersion() == 1 && !string.equalsIgnoreCase(instanceObject.getFullName())) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_INSTANCE), JDeveloperMenuConstants.SECTION_FILE_EXIT);
            }
        } else if (!bl && abstractNode.isInstanceNode()) {
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            InstanceObject instanceObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid()).getInstance(tTGridRootNode.getCurrentHost(), tTGridRootNode.getCurrentInstance());
            boolean bl5 = instanceObject != null && instanceObject.isAppliedToCurrent();
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_EDIT_INSTANCE);
            jMenuItem.setEnabled(bl5);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_INSTANCE_EXEC);
            jMenuItem.setEnabled(bl5);
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_FILE_ADDINS);
            JMenu jMenu = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.instCtrl"), Integer.valueOf(0));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)ACTION_START_INSTANCE));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)ACTION_STOP_INSTANCE));
            JMenu jMenu7 = contextMenu.createSubMenu(Messages.getString("TimesTenGrid.server"), Integer.valueOf(0));
            jMenu7.add(contextMenu.createMenuItem((ToggleAction)ACTION_START_SERVER_INST));
            jMenu7.add(contextMenu.createMenuItem((ToggleAction)ACTION_STOP_SERVER_INST));
            jMenu.setEnabled(bl5);
            jMenu.add(jMenu7);
            contextMenu.add((Component)jMenu, MenuConstants.SECTION_FILE_ADDINS);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_INSTANCE), JDeveloperMenuConstants.SECTION_FILE_EXIT);
        } else if (!bl && abstractNode.isDatabaseNode()) {
            TTGridRootNode tTGridRootNode = TTGridRootNode.getInstance();
            DatabaseObject databaseObject = tTGridRootNode.getGrid(tTGridRootNode.getCurrentGrid()).getDatabase(tTGridRootNode.getCurrentDB());
            boolean bl6 = databaseObject != null;
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_START_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_LOAD_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_OPEN_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, 1.0f);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_REDISTRIBUTE_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DESTROY_DB), JDeveloperMenuConstants.SECTION_FILE_ERASE_REMOVE);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_STOP_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_FILE_EXIT);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_CLOSE_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_FILE_EXIT);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_UNLOAD_DB);
            jMenuItem.setEnabled(bl6);
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_FILE_EXIT);
        } else if (!bl && abstractNode.isCSConnectableFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_CS_CONN), 1.0f);
        } else if (!bl && abstractNode.isDirConnectableFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_D_CONN), 1.0f);
        } else if (!bl && abstractNode.isConnectableNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_EXPORT_CONN), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_CONN), JDeveloperMenuConstants.SECTION_FILE_ERASE_REMOVE);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_EDIT_CONN), 1.0f);
        } else if (!bl && abstractNode.isPGFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_NEW_PG), 1.0f);
        } else if (!bl && abstractNode.isPGNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_EDIT_PG), 1.0f);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DELETE_PG), 1.0f);
        } else if (!bl && abstractNode.isConfigObjectNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_IMPORT), 1.0f);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ACTION_EXPORT);
            GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
            ConfigObject configObject = null;
            if (abstractNode.isMembershipConfigNode()) {
                configObject = gridObject.getMembershipConfiguration();
            } else if (abstractNode.isInstanceConfigNode()) {
                configObject = gridObject.getInstanceConfiguration();
            } else if (abstractNode.isSQLNetNode()) {
                configObject = gridObject.getSQLNet();
            } else if (abstractNode.isTNSNamesNode()) {
                configObject = gridObject.getTNSNames();
            }
            jMenuItem.setEnabled(!configObject.getContent().isEmpty());
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_FILE_IMPORT_EXPORT);
        } else if (!bl && abstractNode.isRepositoryFolderNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_CREATE_REPOSITORY), 1.0f);
        } else if (!bl && abstractNode.isRepositoryNode()) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ACTION_DETACH_REPOSITORY), MenuConstants.SECTION_FILE_ERASE_REMOVE);
        }
    }

    private void launchNewConnectable(GridObject gridObject, DBDefObject dBDefObject, boolean bl) {
        NewConnectablePanel newConnectablePanel = new NewConnectablePanel(bl, dBDefObject, gridObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)newConnectablePanel, TimesTenHelpID.NEW_CONNECTABLE.toString());
        this.launchConnUI(newConnectablePanel, true);
    }

    private void launchEditConnectable(GridObject gridObject, DBDefObject dBDefObject, ConnectableObject connectableObject) {
        NewConnectablePanel newConnectablePanel = new NewConnectablePanel(connectableObject, dBDefObject, gridObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)newConnectablePanel, TimesTenHelpID.CONNECTABLE_EDIT.toString());
        this.launchConnUI(newConnectablePanel, false);
    }

    private void launchConnUI(NewConnectablePanel newConnectablePanel, boolean bl) {
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)newConnectablePanel, (String)Messages.getString(bl ? "TimesTenGrid.newConnectable" : "TimesTenGrid.editConnectable"), (ActionListener)newConnectablePanel);
        newConnectablePanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        Dimension dimension = new Dimension(650, 450);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)newConnectablePanel.getOkButton());
        jEWTDialog.addActionListener((ActionListener)newConnectablePanel);
        jEWTDialog.setVisible(true);
    }

    private void launchShowChanges(GridObject gridObject) {
        LatestModelChangesPanel latestModelChangesPanel = new LatestModelChangesPanel(gridObject, true);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)latestModelChangesPanel, (String)Messages.getString("TimesTenGrid.MCWarningTitle"), (ActionListener)latestModelChangesPanel);
        latestModelChangesPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(5);
        jEWTDialog.setCancelButtonText(Messages.getString("TimesTenGrid.Close"));
        jEWTDialog.setDefaultCloseOperation(2);
        jEWTDialog.setSize(400, 300);
        HelpSystem.getHelpSystem().registerTopic((JComponent)latestModelChangesPanel, TimesTenHelpID.GRID_SHOW_CHANGES.toString());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
    }

    private void launchExecUI(ExecuteCommandPanel executeCommandPanel) {
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)executeCommandPanel, (String)Messages.getString("TimesTenGrid.executeCommandTitle"), (ActionListener)executeCommandPanel);
        executeCommandPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(4);
        Dimension dimension = new Dimension(800, 600);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setResizable(true);
        jEWTDialog.setDefaultCloseOperation(2);
        jEWTDialog.addCustomButton((Component)executeCommandPanel.getSaveAllButton());
        jEWTDialog.addCustomButton((Component)executeCommandPanel.getClearAllButton());
        jEWTDialog.addCustomButton((Component)executeCommandPanel.getExecuteButton());
        jEWTDialog.addCustomButton((Component)executeCommandPanel.getCloseButton());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    private void launchViewLogsUI(GridObject gridObject, LogInspectorMainWindow.LogViewerType logViewerType) {
        String string = logViewerType == LogInspectorMainWindow.LogViewerType.MSG ? Messages.getString("TimesTenGrid.InspectSupportLog") : Messages.getString("TimesTenGrid.InspectErrorLog");
        LogInspectorMainWindow logInspectorMainWindow = new LogInspectorMainWindow(gridObject, logViewerType);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)logInspectorMainWindow, (String)string, (ActionListener)logInspectorMainWindow);
        logInspectorMainWindow.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(20);
        jEWTDialog.setSize(new Dimension(800, 600));
        jEWTDialog.setResizable(true);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    private void launchNewGrid() {
        Dimension dimension = new Dimension(630, 630);
        GridMgmtInfoPanel gridMgmtInfoPanel = new GridMgmtInfoPanel(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)gridMgmtInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)jPanel, (String)Messages.getString("TimesTenGrid.newTTGrid"), (ActionListener)gridMgmtInfoPanel);
        gridMgmtInfoPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)gridMgmtInfoPanel.getCreateButton());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, TimesTenHelpID.NEW_GRID.toString());
        jEWTDialog.setVisible(true);
    }

    private void launchNewDBDef(GridObject gridObject) {
        NewDBDefinitionPanel newDBDefinitionPanel = new NewDBDefinitionPanel(gridObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)newDBDefinitionPanel, TimesTenHelpID.NEW_DB_DEF.toString());
        this.launchDBDefPanel(newDBDefinitionPanel, Messages.getString("TimesTenGrid.newDbDef"));
    }

    private void launchEditDBDef(GridObject gridObject, DBDefObject dBDefObject) {
        NewDBDefinitionPanel newDBDefinitionPanel = new NewDBDefinitionPanel(gridObject, dBDefObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)newDBDefinitionPanel, TimesTenHelpID.DB_DEF_EDIT.toString());
        this.launchDBDefPanel(newDBDefinitionPanel, Messages.getString("TimesTenGrid.editDbDef"));
    }

    private void launchDBDefPanel(NewDBDefinitionPanel newDBDefinitionPanel, String string) {
        Dimension dimension = new Dimension(740, 700);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)newDBDefinitionPanel, (String)string, (ActionListener)newDBDefinitionPanel);
        newDBDefinitionPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.addCustomButton((Component)newDBDefinitionPanel.getOkButton());
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    private void launchManageGridUI(GridObject gridObject) {
        String string = gridObject == null ? Messages.getString("TimesTenGrid.manageExistingGrid") : Messages.getString("TimesTen.mvlog.create.properties");
        ManageExistingGridPanel manageExistingGridPanel = new ManageExistingGridPanel(gridObject);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)manageExistingGridPanel, (String)string, (ActionListener)manageExistingGridPanel);
        manageExistingGridPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        Dimension dimension = new Dimension(550, 400);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)manageExistingGridPanel.getTestButton());
        jEWTDialog.addCustomButton((Component)manageExistingGridPanel.getOKButton());
        HelpSystem.getHelpSystem().registerTopic((JComponent)manageExistingGridPanel, gridObject == null ? TimesTenHelpID.MANAGE_EXISTING_GRID.toString() : TimesTenHelpID.GRID_PROPERTIES.toString());
        jEWTDialog.setVisible(true);
    }

    private void launchTestGridUI() {
        PasswordlessSSHTestPanel passwordlessSSHTestPanel = new PasswordlessSSHTestPanel();
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)passwordlessSSHTestPanel, (String)Messages.getString("TimesTenGrid.testSSH"), (ActionListener)passwordlessSSHTestPanel);
        passwordlessSSHTestPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.setCancelButtonText(Messages.getString("TimesTenGrid.Close"));
        Dimension dimension = new Dimension(600, 670);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        HelpSystem.getHelpSystem().registerTopic((JComponent)passwordlessSSHTestPanel, TimesTenHelpID.TEST_PWDLESS_SSH.toString());
        jEWTDialog.setVisible(true);
    }

    private void launchNewInstanceUI() {
        this.launchGUI(new NewInstancePanel(), Messages.getString("TimesTenGrid.newInstance"), new Dimension(550, 330));
    }

    private void launchEditInstanceUI(InstanceObject instanceObject) {
        this.launchGUI(new EditInstancePanel(instanceObject), MessageFormat.format(Messages.getString("TimesTenGrid.editInstance"), instanceObject), new Dimension(400, 300));
    }

    private void launchNewInstanceWizardUI(boolean bl) {
        TTGridRootNode tTGridRootNode;
        GridObject gridObject;
        if (bl && (gridObject = (tTGridRootNode = TTGridRootNode.getInstance()).getGrid(tTGridRootNode.getCurrentGrid())).getAllMgmtInstancesInLatest().size() > 1) {
            Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.moreThan2MgmtInstError"));
            return;
        }
        this.launchGUI(new NewInstanceWizard(bl), bl ? Messages.getString("TimesTenGrid.newMgmtInstance") : Messages.getString("TimesTenGrid.newDataInstance"), new Dimension(500, bl ? 430 : 400));
    }

    private void launchNewHostUI() {
        this.launchGUI(new NewStandaloneHostPanel(), Messages.getString("TimesTenGrid.newHost"), new Dimension(450, 300));
    }

    private void launchAssignDSGsUI(GridObject gridObject) {
        DSGAssignmentPanel dSGAssignmentPanel = new DSGAssignmentPanel();
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)dSGAssignmentPanel, (String)Messages.getString("TimesTenGrid.assignToDSG"), (ActionListener)dSGAssignmentPanel);
        dSGAssignmentPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        Dimension dimension = new Dimension(700, 500);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)dSGAssignmentPanel.getSuggestButton());
        jEWTDialog.addCustomButton((Component)dSGAssignmentPanel.getOkButton());
        HelpSystem.getHelpSystem().registerTopic((JComponent)dSGAssignmentPanel, TimesTenHelpID.ASSIGN_TO_DSG.toString());
        jEWTDialog.setVisible(true);
    }

    private void launchNewPGUI() {
        this.launchGUI(new PhysicalGroupCreatePanel(), Messages.getString("TimesTenGrid.newPG"), new Dimension(420, 350));
    }

    private void launchEditPG(PhysicalGroupObject physicalGroupObject) {
        this.launchGUI(new PhysicalGroupCreatePanel(physicalGroupObject), Messages.getString("TimesTenGrid.assignRemoveHostsPG"), new Dimension(420, 350));
    }

    private void launchNewInstallationUI(HostObject hostObject) {
        this.launchGUI(new InstallationCreatePanel(hostObject), Messages.getString("TimesTenGrid.newInstallation"), new Dimension(500, 320));
    }

    private void launchCloneHostUI(String string) {
        this.launchGUI(new CloneHostPanel(string), MessageFormat.format(Messages.getString("TimesTenGrid.cloneHost"), string), new Dimension(400, 250));
    }

    private void launchEditHostUI(String string) {
        this.launchGUI(new EditHostPanel(), MessageFormat.format(Messages.getString("TimesTenGrid.editHostTitle"), string), new Dimension(400, 250));
    }

    private void launchGUI(TTGUIBasePanel tTGUIBasePanel, String string, Dimension dimension) {
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)tTGUIBasePanel, (String)string, (ActionListener)tTGUIBasePanel);
        tTGUIBasePanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setPreferredSize(dimension);
        jEWTDialog.setMaximumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)tTGUIBasePanel.getOkButton());
        jEWTDialog.setVisible(true);
    }

    private void launchExportClientDSN() {
        Dimension dimension = new Dimension(400, 150);
        String string = Messages.getString("TimesTenGrid.exportGridDSNTitle");
        RegisterClientServerDSN registerClientServerDSN = new RegisterClientServerDSN(true);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)registerClientServerDSN, (String)string, (ActionListener)registerClientServerDSN);
        registerClientServerDSN.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(16);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)registerClientServerDSN.getCustomButton());
        jEWTDialog.setVisible(true);
    }

    private void launchExportImportUI(GridObject gridObject, ExportImportPanel.ExportImportObject exportImportObject, boolean bl) {
        if (bl && !gridObject.getProperties().hasOtherProperties()) {
            this.runGridDisplayCommand(gridObject, exportImportObject, bl);
        } else {
            this.showExportImportGUI(gridObject, exportImportObject, bl);
        }
    }

    private void runGridDisplayCommand(final GridObject gridObject, ExportImportPanel.ExportImportObject exportImportObject, boolean bl) {
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Boolean doWork() throws TaskException {
                try {
                    JsonObject jsonObject = gridObject.getExecutor().executeCommandGetJson(GridCommand.GRID_DISPLAY, true);
                    gridObject.getProperties().setOtherProperties(jsonObject);
                }
                catch (JsonException | GridCommandException throwable) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), throwable.getMessage());
                    return false;
                }
                return true;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.fetchingGrindInfo"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        try {
            Boolean bl2 = (Boolean)raptorTask.getResult();
            if (bl2.booleanValue()) {
                this.showExportImportGUI(gridObject, exportImportObject, bl);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.log(Level.INFO, exception.getMessage());
        }
    }

    private void showExportImportGUI(GridObject gridObject, ExportImportPanel.ExportImportObject exportImportObject, boolean bl) {
        Dimension dimension = new Dimension(600, 200);
        String string = "";
        TimesTenHelpID timesTenHelpID = TimesTenHelpID.NONE;
        switch (exportImportObject) {
            case GRID_MODEL: {
                string = bl ? Messages.getString("TimesTenGrid.exportModel") : Messages.getString("TimesTenGrid.importModel");
                timesTenHelpID = bl ? TimesTenHelpID.GRID_EXPORT_MODEL : timesTenHelpID;
                break;
            }
            case MEMBERSHIP_CONFIGURATION: {
                string = bl ? Messages.getString("TimesTenGrid.exportMemConf") : Messages.getString("TimesTenGrid.importMemConf");
                timesTenHelpID = bl ? TimesTenHelpID.MEMBERSHIP_CONF_EXPORT : TimesTenHelpID.MEMBERSHIP_CONF_IMPORT;
                break;
            }
            case INSTANCE_CONFIGURATION: {
                string = bl ? Messages.getString("TimesTenGrid.exportInstConf") : Messages.getString("TimesTenGrid.importInstConf");
                timesTenHelpID = bl ? TimesTenHelpID.INST_CONF_EXPORT : TimesTenHelpID.INST_CONF_IMPORT;
                break;
            }
            case SQLNET: {
                string = bl ? Messages.getString("TimesTenGrid.exportSQLNet") : Messages.getString("TimesTenGrid.importSQLNet");
                timesTenHelpID = bl ? TimesTenHelpID.SQLNET_EXPORT : TimesTenHelpID.SQLNET_IMPORT;
                break;
            }
            case TNS_NAMES: {
                string = bl ? Messages.getString("TimesTenGrid.exportTNSNames") : Messages.getString("TimesTenGrid.importTNSNames");
                timesTenHelpID = bl ? TimesTenHelpID.TNSNAMES_EXPORT : TimesTenHelpID.TNSNAMES_IMPORT;
            }
        }
        ExportImportPanel exportImportPanel = new ExportImportPanel(gridObject, exportImportObject, bl, string);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)exportImportPanel, (String)string, (ActionListener)exportImportPanel);
        exportImportPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)exportImportPanel.getCustomButton());
        HelpSystem.getHelpSystem().registerTopic((JComponent)exportImportPanel, timesTenHelpID.toString());
        jEWTDialog.setVisible(true);
    }

    public static boolean promptForPasswordKeyFile(final GridObject gridObject) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GridNavigatorContextMenu.showPassworKeyFiledUI(gridObject);
                    }
                });
                return gridObject.getExecutor().getWorkingHost().getPwd() != null || gridObject.getExecutor().getWorkingHost().getKeyFile() != null;
            }
            catch (InterruptedException | InvocationTargetException exception) {
                Logger.getLogger(GridNavigatorContextMenu.class.getName()).log(Level.SEVERE, exception.getMessage());
                return false;
            }
        }
        GridNavigatorContextMenu.showPassworKeyFiledUI(gridObject);
        return gridObject.getExecutor().getWorkingHost().getPwd() != null || gridObject.getExecutor().getWorkingHost().getKeyFile() != null;
    }

    private static void showPassworKeyFiledUI(final GridObject gridObject) {
        final CredentialsPanel credentialsPanel = new CredentialsPanel(false);
        credentialsPanel.initialize();
        credentialsPanel.setInstanceAdmin(gridObject.getExecutor().getWorkingHost().getInstanceAdmin(), false);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)credentialsPanel, (String)gridObject.getName(), null);
        credentialsPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(3);
        Dimension dimension = new Dimension(320, 250);
        jEWTDialog.setPreferredSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        jEWTDialog.setOKButtonEnabled(false);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.connectingToHost"), gridObject.getExecutor().getWorkingHost().getIPaddress()), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                char[] cArray = credentialsPanel.getPassword();
                String string = credentialsPanel.getKeyFile();
                if (cArray != null || string != null) {
                    try {
                        SSHChannel.tryConnect(gridObject.getExecutor().getWorkingHost().getIPaddress(), gridObject.getExecutor().getWorkingHost().getInstanceAdmin(), cArray, string);
                        gridObject.getExecutor().setPwd(cArray);
                        gridObject.getExecutor().setKeyFile(string);
                        TTGridRootNode.getStorage().saveGrid(gridObject);
                    }
                    catch (MySSHException mySSHException) {
                        gridObject.getExecutor().setPwd(null);
                        gridObject.getExecutor().setKeyFile(null);
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), mySSHException.getMessage());
                    }
                }
                return null;
            }
        };
        swingWorker.addPropertyChangeListener(new SwingWorkerCompletionWaiter(customProgressMonitor));
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
        customProgressMonitor.start();
    }

    private /* synthetic */ void lambda$handleEvent$9(GridObject gridObject, InstanceObject instanceObject) {
        this.closeEditor(gridObject, InstanceEditor.class, instanceObject.getFullName());
    }

    private /* synthetic */ void lambda$handleEvent$8(GridObject gridObject, InstanceObject instanceObject) {
        this.closeEditor(gridObject, InstanceEditor.class, instanceObject.getFullName());
    }

    private /* synthetic */ void lambda$handleEvent$5(GridObject gridObject, DBDefObject dBDefObject) {
        this.closeEditor(gridObject, DBDefEditor.class, dBDefObject.getName());
    }

    private static /* synthetic */ void lambda$handleEvent$3(GridObject gridObject, DatabaseObject databaseObject) {
        DbDestroyDialog.showDBDestroyDialog(gridObject, databaseObject);
    }

    private static /* synthetic */ void lambda$handleEvent$0(DatabaseObject databaseObject, GridObject gridObject, String string, int n) {
        if (databaseObject.getElementInDistMap().size() == 0) {
            if (Common.displayConfirm((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.dbNoDistributionMessage"), Messages.getString("TimesTenGrid.startDB"), null, true)) {
                DatabaseDistributionPanel.showDialog(gridObject, gridObject.getDatabase(string));
            }
        } else {
            gridObject.getDatabase(string).tryToLoadStart(n == START_DB_ID);
        }
    }

    static class SwingWorkerCompletionWaiter
    implements PropertyChangeListener {
        private CustomProgressMonitor _progressMonitor;

        public SwingWorkerCompletionWaiter(CustomProgressMonitor customProgressMonitor) {
            this._progressMonitor = customProgressMonitor;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && SwingWorker.StateValue.DONE == propertyChangeEvent.getNewValue()) {
                this._progressMonitor.close();
            }
        }
    }
}

